/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.model;

import de.accxia.apps.confluence.ium.job.MessageType;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobMessage;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class JobMessageDTO
implements Serializable {
    private Integer ID;
    String userName;
    private int adminRead;
    private int valid;
    private String message;
    private Date creationTime;
    private MessageType messageType;
    private int adjustSeats;

    public static JobMessageDTO fromAO(JobMessage jobMessage) {
        JobMessageDTO jobMessageDTO = new JobMessageDTO();
        if (jobMessage != null) {
            jobMessageDTO.setID(jobMessage.getID());
            jobMessageDTO.setUserName(jobMessage.getUserName());
            jobMessageDTO.setAdminRead(jobMessage.getAdminRead());
            jobMessageDTO.setValid(jobMessage.getValid());
            jobMessageDTO.setMessage(jobMessage.getMessage());
            jobMessageDTO.setCreationTime(jobMessage.getCreationTime());
            jobMessageDTO.setMessageType(MessageType.valueOfMessageType(jobMessage.getMessageType()));
            jobMessageDTO.setAdjustSeats(jobMessage.getAdjustSeats());
        }
        return jobMessageDTO;
    }

    public static JobMessageDTO createJobMessage(ProcessResult processResult, MessageType messageType, String currentUser, long elapsedTime) {
        JobMessageDTO jobMessageDTO = new JobMessageDTO();
        Date currentTime = new Date(System.currentTimeMillis());
        jobMessageDTO.setUserName(currentUser);
        jobMessageDTO.setAdminRead(0);
        jobMessageDTO.setMessage(processResult.getMessage());
        jobMessageDTO.setCreationTime(currentTime);
        jobMessageDTO.setMessageType(messageType);
        jobMessageDTO.setAdjustSeats(processResult.getAdjustSeats());
        return jobMessageDTO;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getAdminRead() {
        return this.adminRead;
    }

    public void setAdminRead(int adminRead) {
        this.adminRead = adminRead;
    }

    public int getValid() {
        return this.valid;
    }

    public void setValid(int valid) {
        this.valid = valid;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public int getAdjustSeats() {
        return this.adjustSeats;
    }

    public void setAdjustSeats(int adjustSeats) {
        this.adjustSeats = adjustSeats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobMessageDTO that = (JobMessageDTO)o;
        if (this.adminRead != that.adminRead) {
            return false;
        }
        if (this.valid != that.valid) {
            return false;
        }
        if (this.ID != null ? !this.ID.equals(that.ID) : that.ID != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.creationTime != null ? this.creationTime.equals(that.creationTime) : that.creationTime == null;
    }

    public int hashCode() {
        int result = this.ID != null ? this.ID.hashCode() : 0;
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + this.adminRead;
        result = 31 * result + this.valid;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.creationTime != null ? this.creationTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JobMessageDTO{ID=" + this.ID + ", userName='" + this.userName + "', adminRead=" + this.adminRead + ", valid=" + this.valid + ", message='" + this.message + "', creationTime=" + this.creationTime + ", messageType='" + this.messageType + "'}";
    }
}

