/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.repository;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import de.accxia.apps.confluence.ium.model.IUMAlert;
import de.accxia.apps.confluence.ium.model.IUMAlertDTO;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={IUMAlertRepository.class})
@Named(value="IUMAlertRepository")
public class IUMAlertRepository {
    private static final Logger logger = LoggerFactory.getLogger(IUMAlertRepository.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public IUMAlertRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public IUMAlert save(IUMAlertDTO alertDTO) {
        logger.debug("Called save for user {}", (Object)alertDTO.getUserName());
        final HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("ACTIVE", alertDTO.isActive());
        values.put("ADMIN", alertDTO.isAdmin());
        values.put("USER", alertDTO.isUser());
        values.put("USER_NAME", alertDTO.getUserName());
        values.put("MESSAGE", alertDTO.getMessage());
        values.put("TYPE", alertDTO.getType());
        IUMAlert response = (IUMAlert)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<IUMAlert>(){

            public IUMAlert doInTransaction() {
                IUMAlert response = (IUMAlert)IUMAlertRepository.this.ao.create(IUMAlert.class, values);
                return response;
            }
        });
        logger.debug("Successfully save for user {}", (Object)alertDTO.getUserName());
        return response;
    }

    public IUMAlert[] getActiveAlerts() {
        IUMAlert[] alerts = (IUMAlert[])this.ao.find(IUMAlert.class, Query.select().where("ACTIVE = ?", new Object[]{true}));
        return alerts;
    }

    public IUMAlert[] getAdminActiveAlerts() {
        IUMAlert[] alerts = (IUMAlert[])this.ao.find(IUMAlert.class, Query.select().where("ACTIVE = ? AND ADMIN = ? ", new Object[]{true, true}));
        return alerts;
    }

    public IUMAlert[] dismissAdminActiveAlert() {
        IUMAlert[] alerts = this.getAdminActiveAlerts();
        if (alerts.length > 0) {
            for (IUMAlert alert : alerts) {
                alert.setActive(false);
                alert.save();
            }
        }
        return alerts;
    }

    public IUMAlert[] getUserActiveAlerts() {
        IUMAlert[] alerts = (IUMAlert[])this.ao.find(IUMAlert.class, Query.select().where("ACTIVE = ? AND USER ", new Object[]{true, true}));
        return alerts;
    }

    public IUMAlert[] dismissUserActiveAlert() {
        IUMAlert[] alerts = this.getUserActiveAlerts();
        if (alerts.length > 0) {
            for (IUMAlert alert : alerts) {
                alert.setActive(false);
                alert.save();
            }
        }
        return alerts;
    }

    public void updateAlert(int alertId, boolean isActive) {
        IUMAlert alert = (IUMAlert)this.ao.get(IUMAlert.class, (Object)alertId);
        if (alert != null) {
            alert.setActive(isActive);
            alert.save();
        }
    }

    public void deleteAlert(int alertId) {
        IUMAlert alert = (IUMAlert)this.ao.get(IUMAlert.class, (Object)alertId);
        if (alert != null) {
            this.ao.delete(new RawEntity[]{alert});
        }
    }
}

