/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.search;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class GroupUserSearcher {
    private Logger LOG = LoggerFactory.getLogger(GroupUserSearcher.class);
    private final CrowdService crowdService;

    public GroupUserSearcher(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public List<String> getActiveUserNamesInGroup(String groupName, int startIndex, int maxResults) {
        List<String> activeUsers = new ArrayList<String>();
        try {
            MembershipQuery findUsersQuery = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), User.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true), (String[])new String[]{groupName});
            activeUsers = StreamSupport.stream(this.crowdService.search((Query)findUsersQuery).spliterator(), false).filter(u -> u.isActive()).map(u -> u.getName()).collect(Collectors.toList());
            return activeUsers;
        }
        catch (Exception e) {
            this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return activeUsers;
        }
    }

    public List<String> getActiveUserNamesInGroup2(String groupName, int startIndex, int maxResults) {
        List<String> activeUsers = new ArrayList<String>();
        try {
            TermRestriction searchRestriction = new TermRestriction((Property)new PropertyImpl("active", String.class), MatchMode.EXACTLY_MATCHES, (Object)"T");
            MembershipQuery findUsersQuery = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), User.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)searchRestriction, (String[])new String[]{groupName});
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Query Details: " + findUsersQuery.toString());
            }
            activeUsers = StreamSupport.stream(this.crowdService.search((Query)findUsersQuery).spliterator(), false).filter(u -> u.isActive()).map(u -> u.getName()).collect(Collectors.toList());
            return activeUsers;
        }
        catch (Exception e) {
            this.LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return activeUsers;
        }
    }

    public List<String> getActiveUserNamesInGroup3(String groupName, int startIndex, int maxResults) {
        ArrayList<String> activeUsers = new ArrayList();
        TermRestriction searchRestriction = new TermRestriction((Property)new PropertyImpl("active", Boolean.class), MatchMode.EXACTLY_MATCHES, (Object)Boolean.TRUE);
        MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)searchRestriction).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        activeUsers = StreamSupport.stream(this.crowdService.search((Query)membershipQuery).spliterator(), false).filter(u -> u.isActive()).map(u -> u.getName()).collect(Collectors.toList());
        return activeUsers;
    }
}

