/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.config.util.BootstrapUtils;
import de.accxia.apps.confluence.ium.config.DAO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class ImageServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ImageServlet.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long MAX_FILE_SIZE = 0x300000L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uploadPath = BootstrapUtils.getBootstrapManager().getApplicationHome() + File.separator + "uploads";
        String fileName = request.getParameter("fileName");
        if (fileName == null || fileName.isEmpty()) {
            response.sendError(400, "File name parameter is missing");
            return;
        }
        String filePath = uploadPath + File.separator + fileName;
        File imageFile = new File(filePath);
        if (!imageFile.exists()) {
            response.sendError(404, "Image file not found");
            return;
        }
        response.setContentType("image/png");
        response.setContentLength((int)imageFile.length());
        FileInputStream fileInputStream = new FileInputStream(imageFile);
        ServletOutputStream out = response.getOutputStream();
        byte[] buf = new byte[1024];
        int count = 0;
        while ((count = fileInputStream.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        out.close();
        fileInputStream.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println(request.toString());
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            try {
                String fileName = this.doUploadPicture(request, response);
                if (fileName != null) {
                    response.setContentType("text/plain");
                    PrintWriter out = response.getWriter();
                    out.write(fileName);
                    out.close();
                    return;
                }
            }
            catch (Exception e) {
                response.setContentType("text/html");
                response.sendError(404, e.getMessage());
            }
        }
        response.setContentType("text/html");
        response.sendError(404, "Image file not uploaded");
    }

    private String doUploadPicture(HttpServletRequest request, HttpServletResponse response) {
        String uploadPath = BootstrapUtils.getBootstrapManager().getApplicationHome() + File.separator + "uploads";
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = null;
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            File repository = new File(BootstrapUtils.getBootstrapManager().getFilePathProperty("struts.multipart.saveDir"));
            factory.setRepository(repository);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setFileSizeMax(0x300000L);
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                if (item.getSize() > 0x300000L) {
                    throw new RuntimeException("File size exceeds the limit");
                }
                fileName = new File(item.getName()).getName();
                String filePath = uploadPath + File.separator + fileName;
                File storeFile = new File(filePath);
                item.write(storeFile);
                request.setAttribute("message", (Object)"File upload success!");
                DAO.updateUrlLogo(fileName);
            }
        }
        catch (Exception ex) {
            request.setAttribute("message", (Object)("File upload failed due to " + ex));
        }
        return fileName;
    }
}

