/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.transformer;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.atlassian.webresource.api.transformer.TransformableResource;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.transformer.TransformerUrlBuilder;
import com.atlassian.webresource.spi.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.webresource.spi.transformer.WebResourceTransformerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccxiaWebResourceTransformerFactory
implements WebResourceTransformerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AccxiaWebResourceTransformerFactory.class);
    private final WebResourceUrlProvider webResourceUrlProvider;

    public AccxiaWebResourceTransformerFactory(WebResourceUrlProvider webResourceUrlProvider) {
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters transformerParameters) {
        return new UrlReadingWebResourceTransformer(){

            public DownloadableResource transform(final TransformableResource transformableResource, QueryParams params) {
                return new DownloadableResource(){

                    public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
                        return transformableResource.nextResource().isResourceModified(request, response);
                    }

                    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
                        transformableResource.nextResource().serveResource(request, response);
                    }

                    public void streamResource(OutputStream outputStream) throws DownloadException {
                        try {
                            ByteArrayOutputStream originalResourceStream = new ByteArrayOutputStream();
                            transformableResource.nextResource().streamResource((OutputStream)originalResourceStream);
                            originalResourceStream.flush();
                            outputStream.write(AccxiaWebResourceTransformerFactory.this.customTransform(originalResourceStream.toString(StandardCharsets.UTF_8.name())).toString().getBytes(StandardCharsets.UTF_8));
                        }
                        catch (IOException e) {
                            throw new DownloadException("Unable to stream to the output", (Exception)e);
                        }
                    }

                    public String getContentType() {
                        return transformableResource.nextResource().getContentType();
                    }
                };
            }
        };
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return new TransformerUrlBuilder(){

            public void addToUrl(UrlBuilder urlBuilder) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Call TransformerUrlBuilder");
                }
                urlBuilder.addToHash("_", (Object)String.valueOf(System.currentTimeMillis()));
                urlBuilder.addToQueryString("ts-accxia", String.valueOf(System.currentTimeMillis()));
            }
        };
    }

    protected CharSequence customTransform(CharSequence originalContent) {
        return originalContent;
    }
}

