/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import de.accxia.apps.confluence.ium.cache.UserCachedManager;
import de.accxia.apps.confluence.ium.config.DAO;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/cache")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class InfoCacheController {
    private static final Logger LOG = LoggerFactory.getLogger(InfoCacheController.class);
    public final UserCachedManager userCachedManager;

    @Inject
    public InfoCacheController(UserCachedManager userCachedManager) {
        this.userCachedManager = userCachedManager;
    }

    @Path(value="/property/list")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        if (DAO.propertyCachedManager != null) {
            Map<String, String> properties = DAO.propertyCachedManager.getValues();
            map.put("properties", properties);
        }
        return Response.ok(map).build();
    }

    @Path(value="/user/list")
    @GET
    @Produces(value={"application/json"})
    public Response getUserCachedList() {
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        if (this.userCachedManager != null) {
            Map<String, Long> properties = this.userCachedManager.getValues();
            map.put("properties", properties);
        }
        return Response.ok(map).build();
    }
}

