/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.side.LicenseData;
import de.accxia.apps.confluence.ium.side.VerifyMessage;
import java.text.SimpleDateFormat;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class ConfigResource {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private static String PATTERN = "yyyy-MM-dd";
    private static SimpleDateFormat SDF = new SimpleDateFormat(PATTERN);

    @Inject
    public ConfigResource(UserManager userManager, TransactionTemplate transactionTemplate) {
        this.userManager = userManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Path(value="/sidelicense")
    @GET
    @Produces(value={"application/json"})
    public Response getSideLicenseDetails() {
        LicenseData ourSideLicense = ConditionEvaluatorIUMImpl.getSideLicense();
        VerifyMessage.License_Result licenseStatus = VerifyMessage.getLicenseStatus(ourSideLicense, ConditionEvaluatorIUMImpl.getOurServerID());
        LicenseDetails licenseDetails = null;
        licenseDetails = ourSideLicense != null ? new LicenseDetails(licenseStatus, SDF.format(ourSideLicense.getDueDate()), ourSideLicense.getUsers(), ourSideLicense.getSSN(), ourSideLicense.getCustomer(), DAO.getSideLicense()) : new LicenseDetails(licenseStatus, null, 0, "", "", "");
        return Response.ok((Object)licenseDetails).build();
    }

    public class LicenseDetails {
        public VerifyMessage.License_Result licenseStatus;
        public String expires;
        public int users;
        public String SSN;
        public String customer;
        public String licenseKey;

        public LicenseDetails(VerifyMessage.License_Result licenseStatus, String expires, int users, String SSN, String customer, String licenseKey) {
            this.licenseStatus = licenseStatus;
            this.expires = expires;
            this.users = users;
            this.SSN = SSN;
            this.customer = customer;
            this.licenseKey = licenseKey;
        }
    }
}

