/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.Credential;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.Quota;
import de.accxia.apps.confluence.ium.util.UserStatus;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/apps")
@Component
@UnrestrictedAccess
public class IUMRest {
    private static final Logger LOG = LoggerFactory.getLogger(IUMRest.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final GroupManager groupManager;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;

    @Inject
    public IUMRest(UserAccessor userAccessor, UserManager userManager, GroupManager groupManager, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService) {
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
    }

    @Path(value="/retry")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response attemptToEnableUser(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, request);
        boolean message = currentUser != null;
        return Response.ok((Object)("{\"warningMessage\":\"" + message + "\"}")).build();
    }

    @Path(value="/check")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkCanGetFreeSlots(@QueryParam(value="username") String username) {
        try {
            Quota retVal = this.iumHelperCacheService.checkCanGetFreeSlots(username);
            return Response.ok((Object)retVal).build();
        }
        catch (EntityException e) {
            LOG.error("EntityException " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)Quota.Empty).build();
        }
    }

    @Path(value="/active")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkActiveUser() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        try {
            boolean isEnabled = this.iumHelperCacheService.isUserInEnableGroups(user);
            boolean isDisable = this.iumHelperCacheService.isUserInDisableGroups(user);
            return Response.ok((Object)new UserStatus(user, isEnabled, isDisable)).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)UserStatus.Empty).build();
        }
    }

    @Path(value="/interval")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getDefaultInterval() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        try {
            int duration = this.safeParseToInt(DAO.getDuration());
            int sync = this.safeParseToInt(DAO.getSyncLicenseInterval());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("duration", duration);
            map.put("sync", sync);
            return Response.ok(map).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)0).build();
        }
    }

    @Path(value="/create")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUsers(@QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="group") String group, @QueryParam(value="count") Integer count) {
        if (username != null) {
            try {
                Group parentGroup = this.groupManager.getGroup(group);
                for (int i = 0; i < count; ++i) {
                    String uname = String.format("%s%d", username, i + 1);
                    if (this.userAccessor.exists(uname)) continue;
                    ConfluenceUser usr = this.userAccessor.createUser((User)new ConfluenceUserImpl(uname, uname, "aurelian.cruceru+" + uname + "@alten.com"), Credential.unencrypted((String)password));
                    this.groupManager.addMembership(parentGroup, (User)usr);
                }
            }
            catch (Exception le) {
                LOG.error("Cannot create user '" + username + "'!", (Throwable)le);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Cannot create user '" + username + "'!")).build();
            }
            catch (Throwable t) {
                LOG.error("Failed to create user '" + username + "'!", t);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Failed to create user '" + username + "'!")).build();
            }
        } else {
            LOG.warn("Cannot add user with null username!");
        }
        return Response.ok().build();
    }

    @Path(value="/create2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUsersRange(@QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="group") String group, @QueryParam(value="start") Integer start, @QueryParam(value="count") Integer count) {
        if (username != null) {
            try {
                Group parentGroup = this.groupManager.getGroup(group);
                for (int i = start.intValue(); i < start + count; ++i) {
                    String uname = String.format("%s%d", username, i);
                    if (this.userAccessor.exists(uname)) continue;
                    ConfluenceUser usr = this.userAccessor.createUser((User)new ConfluenceUserImpl(uname, uname, "aurelian.cruceru+" + uname + "@alten.com"), Credential.unencrypted((String)password));
                    this.groupManager.addMembership(parentGroup, (User)usr);
                }
            }
            catch (Exception le) {
                LOG.error("Cannot create user '" + username + "'!", (Throwable)le);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Cannot create user '" + username + "'!")).build();
            }
            catch (Throwable t) {
                LOG.error("Failed to create user '" + username + "'!", t);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Failed to create user '" + username + "'!")).build();
            }
        } else {
            LOG.warn("Cannot add user with null username!");
        }
        return Response.ok().build();
    }

    @Path(value="/delete")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteUsersRange(@QueryParam(value="prefix") String prefix, @QueryParam(value="start") Integer start, @QueryParam(value="count") Integer count) {
        try {
            Pager userPager = this.userManager.getUsers();
            for (User user : userPager.getCurrentPage()) {
                if (!user.getName().startsWith(prefix)) continue;
                this.userManager.removeUser(user);
            }
        }
        catch (Exception le) {
            LOG.error("Cannot delete user '" + prefix + "'!", (Throwable)le);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Cannot create user '" + prefix + "'!")).build();
        }
        return Response.ok().build();
    }

    @Path(value="/delete2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteUsersRange2(@QueryParam(value="username") String username, @QueryParam(value="start") Integer start, @QueryParam(value="count") Integer count) {
        if (username != null) {
            try {
                for (int i = start.intValue(); i < start + count; ++i) {
                    String uname = String.format("%s%d", username, i);
                    if (!this.userAccessor.exists(uname)) continue;
                    this.userAccessor.removeUser((User)this.userAccessor.getUserByName(uname));
                }
            }
            catch (Exception le) {
                LOG.error("Cannot create user '" + username + "'!", (Throwable)le);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Cannot create user '" + username + "'!")).build();
            }
            catch (Throwable t) {
                LOG.error("Failed to create user '" + username + "'!", t);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Failed to create user '" + username + "'!")).build();
            }
        } else {
            LOG.warn("Cannot add user with null username!");
        }
        return Response.ok().build();
    }

    @Path(value="/copy2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response copyUsersRange(@QueryParam(value="username") String username, @QueryParam(value="group") String group, @QueryParam(value="start") Integer start, @QueryParam(value="count") Integer count) {
        if (username != null) {
            try {
                Group parentGroup = this.groupManager.getGroup(group);
                for (int i = start.intValue(); i < start + count; ++i) {
                    String uname = String.format("%s%d", username, i);
                    if (!this.userAccessor.exists(uname)) continue;
                    this.userAccessor.addMembership(group, uname);
                }
            }
            catch (Exception le) {
                LOG.error("Cannot copies users '" + username + "'!", (Throwable)le);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Cannot create user '" + username + "'!")).build();
            }
        } else {
            LOG.warn("Cannot copy with null username!");
        }
        return Response.ok().build();
    }

    @Path(value="/removal")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getRemovalStatus() {
        try {
            Map<String, Long> retVal = this.iumHelperCacheService.getUsersFromRemovalCache();
            return Response.ok(retVal).build();
        }
        catch (Exception le) {
            LOG.error("Exception " + le.getMessage(), (Throwable)le);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Exception " + le.getMessage())).build();
        }
    }

    private int safeParseToInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

