/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="UserCacheEntryAdapter")
public class UserCacheEntryAdapter<V>
implements CacheEntryListener<String, V> {
    private static final Logger LOG = LoggerFactory.getLogger(UserCacheEntryAdapter.class);

    @Inject
    public UserCacheEntryAdapter() {
    }

    public void onAdd(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (!(cacheEntryEvent.getKey() instanceof String) || !(cacheEntryEvent.getValue() instanceof Long)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("UserCacheEntry onAdd " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
    }

    public void onEvict(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("UserCacheEntry onEvict " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
    }

    public void onRemove(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("UserCacheEntry onRemove " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
    }

    public void onUpdate(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("UserCacheEntry onUpdate " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
            LOG.debug("UserCacheEntry onUpdate " + (String)cacheEntryEvent.getKey() + " new=" + cacheEntryEvent.getValue().getClass().getName());
        }
    }

    private Long extractValueFromEntryEvent(CacheEntryEvent<String, V> cacheEntryEvent) {
        if (cacheEntryEvent.getValue() instanceof Long) {
            return (Long)cacheEntryEvent.getValue();
        }
        if (cacheEntryEvent.getValue() == null) {
            return 0L;
        }
        Field field = null;
        try {
            field = FieldUtils.getField(cacheEntryEvent.getValue().getClass(), (String)"value", (boolean)true);
            field.setAccessible(true);
            Long value = field.get(cacheEntryEvent.getValue()) == null ? 0L : (Long)field.get(cacheEntryEvent.getValue());
            return value;
        }
        catch (Exception ex) {
            LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            return 0L;
        }
    }
}

