/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config;

import com.atlassian.confluence.plugins.rest.jackson2.manager.RequestContext;
import com.atlassian.confluence.plugins.rest.jackson2.manager.RequestContextThreadLocal;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.rest.api.security.exception.AuthenticationRequiredException;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.auth.AuthenticationContextImpl;
import com.atlassian.user.User;
import java.security.Principal;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public abstract class AbstractResource {
    protected final UserAccessor userAccessor;
    protected AuthenticationContext authContext = new AuthenticationContextImpl();
    @Context
    protected UriInfo uriInfo;
    private SpacePermissionManager spacePermissionManager;

    AbstractResource() {
        this.userAccessor = null;
    }

    public AbstractResource(UserAccessor userAccessor, SpacePermissionManager spm) {
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spm;
    }

    protected UriBuilder getContentUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("content").path("{id}");
    }

    protected UriBuilder getSpaceUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("space").path("{key}");
    }

    protected UriBuilder getAttachmentUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("attachment").path("{id}");
    }

    protected UriBuilder getUserUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("user").path("non-system").path("{username}");
    }

    protected UriBuilder getAnonymousUserUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("user").path("system").path("anonymous");
    }

    protected UriBuilder getMissingUserUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path("user").path("missing").queryParam("username", new Object[0]);
    }

    protected User getCurrentUser() {
        return this.convertPrincipalToUser(this.authContext.getUser());
    }

    protected RequestContext createRequestContext() {
        if (this.authContext.getUser() == null && !this.spacePermissionManager.hasPermission("USECONFLUENCE", (Space)null, (ConfluenceUser)null)) {
            throw new AuthenticationRequiredException();
        }
        RequestContext requestContext = new RequestContext(this.getCurrentUser(), this.uriInfo.getBaseUriBuilder());
        requestContext.setUriBuilder("content", this.getContentUriBuilder());
        requestContext.setUriBuilder("space", this.getSpaceUriBuilder());
        requestContext.setUriBuilder("attachment", this.getAttachmentUriBuilder());
        requestContext.setUriBuilder("user/non-system", this.getUserUriBuilder());
        requestContext.setUriBuilder("user/system/anonymous", this.getAnonymousUserUriBuilder());
        requestContext.setUriBuilder("user/missing", this.getMissingUserUriBuilder());
        RequestContextThreadLocal.set((RequestContext)requestContext);
        return requestContext;
    }

    private User convertPrincipalToUser(Principal principal) {
        if (principal == null) {
            return null;
        }
        return principal instanceof User ? (User)principal : this.userAccessor.getUserByName(principal.getName());
    }

    static Integer parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException var2) {
            return null;
        }
    }
}

