/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.listener;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.notification.NotificationsSender;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.mentions.api.MentionFinder;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.DeletedUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.util.EmailUtil;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.IUMMentionService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class HookListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(HookListener.class);
    public static final String PLUGIN_KEY = "de.accxia.apps.confluence.IUM.IUM4Confluence";
    @ConfluenceImport
    private final LocalNotificationService localNotificationService;
    @ConfluenceImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final MentionFinder mentionFinder;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final ContentPermissionManager contentPermissionManager;
    private final IUMHelperService helperService;
    private final IUMMentionService iumMentionService;

    @Inject
    public HookListener(EventPublisher eventPublisher, UserAccessor userAccessor, LocalNotificationService localNotificationService, NotificationManager notificationManager, MentionFinder mentionFinder, CrowdService crowdService, PermissionManager permissionManager, IUMHelperService helperService, IUMMentionService iumMentionService, ContentPermissionManager contentPermissionManager) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.userAccessor = Objects.requireNonNull(userAccessor);
        this.crowdService = Objects.requireNonNull(crowdService);
        this.notificationManager = Objects.requireNonNull(notificationManager);
        this.localNotificationService = Objects.requireNonNull(localNotificationService);
        this.permissionManager = Objects.requireNonNull(permissionManager);
        this.helperService = helperService;
        this.iumMentionService = iumMentionService;
        this.mentionFinder = mentionFinder;
        this.contentPermissionManager = contentPermissionManager;
    }

    @EventListener
    public void blogPostEvents(BlogPostCreateEvent event) {
        this.doBlogPostEvents((BlogPostEvent)event, null);
    }

    @EventListener
    public void blogPostEvents(BlogPostUpdateEvent event) {
        this.doBlogPostEvents((BlogPostEvent)event, (ContentEntityObject)event.getOriginalBlogPost());
    }

    @EventListener
    public void blogPostEvents(BlogPostTrashedEvent event) {
        this.doBlogPostEvents((BlogPostEvent)event, null);
    }

    public void doBlogPostEvents(BlogPostEvent event, ContentEntityObject original) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("BlogPostEvents " + event.getBlogPost().getType() + " " + event.toString());
        }
        List<String> disabledUsers = this.helperService.getOnlyDisabledUsers();
        if (!event.isSuppressNotifications()) {
            this.tryToNotifyInAppUser4DisableGroup(disabledUsers, (ContentEvent)event);
            this.tryToNotifyMailsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
            this.tryToMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        }
    }

    @EventListener
    public void allAttachmentEvent(AttachmentEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttachmentEvent " + event.getAttachedTo() + " " + event.toString());
        }
        if (event instanceof AttachmentCreateEvent || event instanceof AttachmentUpdateEvent || event instanceof AttachmentTrashedEvent) {
            this.doAttachmentEvent(event);
        }
    }

    private void doAttachmentEvent(AttachmentEvent event) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AttachmentEvent " + event.getAttachment().getType() + " " + event.toString());
        }
        List<String> disabledUsers = this.helperService.getOnlyDisabledUsers();
        if (!event.isSuppressNotifications()) {
            this.tryToNotifyMailsUser4DisableGroup(disabledUsers, (ContentEvent)event, null);
        }
    }

    @EventListener
    public void pageEvents(PageCreateEvent event) {
        this.doPageEvents((PageEvent)event, null);
    }

    @EventListener
    public void pageEvents(PageUpdateEvent event) {
        this.doPageEvents((PageEvent)event, (ContentEntityObject)event.getOriginalPage());
    }

    @EventListener
    public void pageEvents(PageTrashedEvent event) {
        this.doPageEvents((PageEvent)event, null);
    }

    private void doPageEvents(PageEvent event, ContentEntityObject original) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("PageEvents " + event.getPage().getType() + " " + event.toString());
        }
        List<String> disabledUsers = this.helperService.getOnlyDisabledUsers();
        if (!event.isSuppressNotifications()) {
            this.tryToNotifyInAppUser4DisableGroup(disabledUsers, (ContentEvent)event);
            this.tryToNotifyMailsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
            this.tryToMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        }
    }

    @EventListener
    public void commentEvents(CommentCreateEvent event) {
        this.doCommentEvents((CommentEvent)event, null);
    }

    @EventListener
    public void commentEvents(CommentUpdateEvent event) {
        this.doCommentEvents((CommentEvent)event, (ContentEntityObject)event.getOriginalComment());
    }

    @EventListener
    public void commentEvents(CommentRemoveEvent event) {
        this.doCommentEvents((CommentEvent)event, null);
    }

    private void doCommentEvents(CommentEvent event, ContentEntityObject original) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CommentEvents " + event.getComment().getType() + " " + event.toString());
        }
        List<String> disabledUsers = this.helperService.getOnlyDisabledUsers();
        this.tryToNotifyInAppUser4DisableGroup(disabledUsers, (ContentEvent)event);
        this.tryToNotifyMailsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        this.tryToMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        if (event instanceof CommentCreateEvent) {
            this.tryToEmailMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        }
    }

    private void tryToMentionsUser4DisableGroup(List<String> disabledUsers, ContentEvent event, ContentEntityObject original) {
        Set mentionedUsernames;
        Set set = mentionedUsernames = original != null ? this.mentionFinder.getNewMentionedUsernames(original.getBodyContent(), event.getContent().getBodyContent()) : this.mentionFinder.getMentionedUsernames(event.getContent().getBodyContent());
        if (mentionedUsernames == null || mentionedUsernames.size() == 0) {
            return;
        }
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        this.permissionManager.withExemption(() -> mentionedUsernames.stream().forEach(userName -> {
            ConfluenceUser mentionedUser = this.userAccessor.getUserByName(userName);
            if (mentionedUser != null && mentionedUser.getName() != null && !this.isDisabled(mentionedUser.getName()) && !DeletedUser.isDeletedUser((User)mentionedUser) && disabledUsers.contains(mentionedUser.getName())) {
                try {
                    this.iumMentionService.sendMentions(mentionedUser, event.getContent());
                }
                catch (Exception e) {
                    LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            }
        }));
    }

    private void tryToNotifyInAppUser4DisableGroup(List<String> disabledUsers, ContentEvent event) {
        List notificationList = this.notificationManager.getNotificationsByContent(event.getContent());
        if (notificationList == null || notificationList.size() == 0) {
            return;
        }
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        notificationList.stream().forEach(n -> {
            if (disabledUsers.contains(n.getReceiver().getName())) {
                try {
                    com.atlassian.mywork.model.Notification nx = this.createNotification(event);
                    ConfluenceUser notifyUser = n.getReceiver();
                    if (nx != null && notifyUser != null && notifyUser.getName() != null && !this.isDisabled(notifyUser.getName()) && !DeletedUser.isDeletedUser((User)notifyUser)) {
                        this.sendNotification((User)n.getReceiver(), nx);
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private void tryToEmailMentionsUser4DisableGroup(List<String> disabledUsers, ContentEvent event, ContentEntityObject original) {
        Set mentionedUsernames;
        Set set = mentionedUsernames = original != null ? this.mentionFinder.getNewMentionedUsernames(original.getBodyContent(), event.getContent().getBodyContent()) : this.mentionFinder.getMentionedUsernames(event.getContent().getBodyContent());
        if (mentionedUsernames == null || mentionedUsernames.size() == 0) {
            return;
        }
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        NotificationsSender notificationsSender = (NotificationsSender)ContainerManager.getComponent((String)"notificationsSender");
        PageContext renderContext = original == null ? event.getContent().toPageContext() : original.toPageContext();
        renderContext.setOutputType(ConversionContextOutputType.EMAIL.value());
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)renderContext);
        conversionContext.setProperty("renderForWorkBox", (Object)true);
        String actionDescription = " mentioned you in ";
        Comment comment = (Comment)event.getContent();
        ContentEntityObject page = comment.getContainer();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        this.permissionManager.withExemption(() -> this.lambda$tryToEmailMentionsUser4DisableGroup$4(mentionedUsernames, disabledUsers, page, original, event, currentUser, actionDescription, comment, notificationsSender, (ConversionContext)conversionContext));
    }

    private boolean isDisabled(String username) {
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
        return user == null || !user.isActive();
    }

    private void sendMailNotification(ConfluenceUser currentUser, ContentEvent event, ContentEntityObject original, String title, Notification notif, NotificationsSender notificationsSender, ConversionContext conversionContext) {
        try {
            NotificationData notificationData = this.getNotificationDataForEvent(event, (User)currentUser, (ConfluenceEntityObject)original);
            notificationData.setSubject(title);
            if (event instanceof AttachmentEvent) {
                ArrayList attachments = new ArrayList(((AttachmentEvent)event).getAttachments());
                if (event instanceof AttachmentCreateEvent || event instanceof AttachmentUpdateEvent) {
                    notificationData.setTemplateName("attachment-added-notification.vm");
                } else if (event instanceof AttachmentRemoveEvent || event instanceof AttachmentTrashedEvent) {
                    notificationData.setTemplateName("attachment-removed-notification.vm");
                }
                notificationData.addToContext("contentType", (Serializable)((Object)"attachment"));
                notificationData.addToContext("page.type", (Serializable)((Object)"attachment"));
                notificationData.addToContext("attachment.id", (Serializable)Long.valueOf(event.getContent().getId()));
                notificationData.addToContext("attachments", attachments);
                notificationData.addToContext("page", ((AttachmentEvent)event).getAttachedTo() instanceof Page ? (Page)((AttachmentEvent)event).getAttachedTo() : null);
            } else if (event instanceof CommentEvent) {
                if (event instanceof CommentCreateEvent) {
                    notificationData.setTemplateName("comment-added-notification.vm");
                    notificationData.addToContext("contentType", (Serializable)((Object)"comment"));
                    notificationData.addToContext("page.type", (Serializable)((Object)"comment"));
                    notificationData.addToContext("comment.id", (Serializable)Long.valueOf(event.getContent().getId()));
                    notificationData.addToContext("comment", (Serializable)event.getContent());
                    notificationData.addToContext("page", ((CommentEvent)event).getComment().getContainer() instanceof Page ? (Page)((CommentEvent)event).getComment().getContainer() : null);
                }
            } else {
                notificationData.setTemplateName("page-edited-notification.vm");
                notificationData.addToContext("contentType", (Serializable)((Object)"page"));
                notificationData.addToContext("page.id", (Serializable)Long.valueOf(event.getContent().getId()));
                notificationData.addToContext("page", (Serializable)event.getContent());
            }
            if (notificationData.getCommonContext().getContent() == null) {
                LOG.info("Find notificationData.getCommonContext().getContent()==null ");
                notificationData.addToContext("content", (Serializable)event.getContent());
            }
            notificationData.addToContext("originalContent", (Serializable)original);
            ConfluenceUserPreferences userPreferences = this.userAccessor.getConfluenceUserPreferences((User)notif.getReceiver());
            boolean showDiffs = userPreferences.isShowDifferencesInNotificationEmails();
            if (showDiffs && (notificationData.getCommonContext().getContent() == null || original == null)) {
                if (notificationData.getCommonContext().getContent() == null && original != null) {
                    notificationData.addToContext("content", (Serializable)original);
                } else if (notificationData.getCommonContext().getContent() != null && original == null) {
                    original = event.getContent();
                    notificationData.addToContext("originalContent", (Serializable)event.getContent());
                }
                if (notificationData.getCommonContext().getContent() == null || original == null) {
                    LOG.warn("Mail Notification send from " + currentUser.getName() + " to " + (notif.getReceiver() != null ? notif.getReceiver().getName() : "N/A") + " with empry content");
                    return;
                }
            }
            this.setPermissionEntity(notificationData);
            notificationsSender.sendNotification(notif, notificationData, conversionContext);
            if (LOG.isInfoEnabled()) {
                LOG.info("Mail Notification send from " + currentUser.getName() + " to " + (notif.getReceiver() != null ? notif.getReceiver().getName() : "N/A") + " with email=" + (notif.getReceiver() != null ? notif.getReceiver().getEmail() : "N/A"));
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    private void tryToNotifyMailsUser4DisableGroup(List<String> disabledUsers, ContentEvent event, ContentEntityObject original) {
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        if (EmailUtil.checkMailServer()) {
            String[] IUMEnables;
            List<Notification> filterPageNotification;
            List pageNotification;
            List notificationList = this.notificationManager.getNotificationsByContent(event.getContent());
            ArrayList<Notification> notificationPageList = new ArrayList<Notification>();
            if (event instanceof PageEvent) {
                pageNotification = this.notificationManager.getNotificationsBySpaceAndType(((PageEvent)event).getPage().getSpace(), null);
                filterPageNotification = this.filterNotificationBySpace(pageNotification, ((PageEvent)event).getPage().getSpace());
                notificationPageList.addAll(filterPageNotification);
            }
            if (event instanceof CommentEvent) {
                pageNotification = this.notificationManager.getNotificationsBySpaceAndType(((CommentEvent)event).getComment().getSpace(), null);
                filterPageNotification = this.filterNotificationBySpace(pageNotification, ((CommentEvent)event).getComment().getSpace());
                notificationPageList.addAll(filterPageNotification);
            }
            if (event instanceof BlogPostEvent) {
                notificationPageList.addAll(this.notificationManager.getNotificationsBySpaceAndType(((BlogPostEvent)event).getBlogPost().getSpace(), null));
            }
            if (event instanceof AttachmentEvent && ((AttachmentEvent)event).getAttachedTo() instanceof Page) {
                Page page = (Page)((AttachmentEvent)event).getAttachedTo();
                notificationPageList.addAll(this.notificationManager.getNotificationsBySpaceAndType(page.getSpace(), null));
            }
            ArrayList<String> remainingDisabledUsers = new ArrayList<String>(disabledUsers);
            ArrayList remainingNotificationList = new ArrayList();
            notificationList.stream().forEach(notif -> {
                if (disabledUsers.contains(notif.getReceiver().getName())) {
                    remainingNotificationList.add(notif);
                    remainingDisabledUsers.remove(notif.getReceiver().getName());
                }
            });
            notificationPageList.stream().forEach(notif -> {
                if (disabledUsers.contains(notif.getReceiver().getName())) {
                    remainingNotificationList.add(notif);
                    remainingDisabledUsers.remove(notif.getReceiver().getName());
                }
            });
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            String IUMDisabled = DAO.getIUMGroupsDisabled();
            String IUMEnable = DAO.getIUMGroups();
            String[] IUMDisables = IUMDisabled == null || IUMDisabled.length() == 0 ? new String[]{} : IUMDisabled.split(",");
            String[] stringArray = IUMEnables = IUMEnable == null || IUMEnable.length() == 0 ? new String[]{} : IUMEnable.split(",");
            if (remainingNotificationList != null && remainingNotificationList.size() > 0) {
                NotificationsSender notificationsSender = (NotificationsSender)ContainerManager.getComponent((String)"notificationsSender");
                PageContext renderContext = original == null ? event.getContent().toPageContext() : original.toPageContext();
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)renderContext);
                String title = this.buildTitle(event, original);
                try {
                    this.permissionManager.withExemption(() -> this.lambda$tryToNotifyMailsUser4DisableGroup$13(remainingNotificationList, original, event, IUMDisables, IUMEnables, currentUser, title, notificationsSender, (ConversionContext)conversionContext));
                }
                catch (Exception e) {
                    LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private List<Notification> filterNotificationBySpace(List<Notification> pageNotification, Space space) {
        ArrayList<Notification> filterPageNotification = new ArrayList<Notification>();
        HashMap<String, String> groups = new HashMap<String, String>();
        String[] iumEnableGroups = DAO.getIUMGroups().split(",");
        String[] iumDisableGroups = DAO.getIUMGroupsDisabled().split(",");
        for (int i = 0; i < iumDisableGroups.length; ++i) {
            groups.put(iumEnableGroups[i], iumDisableGroups[i]);
        }
        List permissionList = space.getPermissions();
        pageNotification.stream().forEach(notification -> {
            List<String> userGroups = this.helperService.getGroupsForUser(notification.getReceiver());
            List userPermissionList = permissionList.stream().filter(spacePermission -> {
                if (!SpacePermission.GENERIC_SPACE_PERMISSIONS.contains(spacePermission.getType())) {
                    return false;
                }
                if (spacePermission.getUserSubject() != null && spacePermission.getUserSubject().getName().equals(notification.getReceiver().getName())) {
                    return true;
                }
                if (spacePermission.getGroup() != null && userGroups.contains(spacePermission.getGroup())) {
                    return true;
                }
                return spacePermission.getGroup() != null && groups.containsKey(spacePermission.getGroup());
            }).collect(Collectors.toList());
            if (userPermissionList.size() > 0) {
                filterPageNotification.add((Notification)notification);
            }
        });
        return filterPageNotification;
    }

    private void setPermissionEntity(NotificationData notificationData) {
        Field field;
        try {
            field = notificationData.getClass().getDeclaredField("permissionEntity");
            field.setAccessible(true);
            field.set(notificationData, null);
        }
        catch (Exception e) {
            LOG.error("Exception permissionEntity accessible=" + e.getMessage());
        }
        try {
            field = notificationData.getClass().getDeclaredField("permissionEntity");
            Field modifierField = Field.class.getDeclaredField("modifiers");
            modifierField.setAccessible(true);
            modifierField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e) {
            LOG.error("Exception permissionEntity modifier=" + e.getMessage());
        }
    }

    private NotificationData getNotificationDataForEvent(ContentEvent event, User user, ConfluenceEntityObject entity) {
        NotificationData notificationData = new NotificationData(user, true, entity);
        NotificationContext commonContext = notificationData.getCommonContext();
        if (event instanceof ContentEvent) {
            commonContext.setContent((ConfluenceEntityObject)event.getContent());
        }
        commonContext.setEvent((Object)event);
        return notificationData;
    }

    private String buildTitle(ContentEvent event, ContentEntityObject original) {
        Object title = event.getContent().getDisplayTitle();
        if (event instanceof PageEvent) {
            title = ((PageEvent)event).getPage().getSpace().getDisplayTitle() + " > " + (String)title;
        } else if (event instanceof BlogPostEvent) {
            title = ((BlogPostEvent)event).getBlogPost().getSpace().getDisplayTitle() + " > " + (String)title;
        }
        return title;
    }

    private com.atlassian.mywork.model.Notification createNotification(ContentEvent event) {
        NotificationBuilder notificationBuilder = new NotificationBuilder().application(PLUGIN_KEY).groupingId(PLUGIN_KEY);
        if (event instanceof CommentEvent) {
            CommentEvent commentEvent = (CommentEvent)event;
            notificationBuilder.title(commentEvent.getComment().getDisplayTitle()).itemTitle(commentEvent.getComment().getContainer().getTitle()).description(commentEvent.getComment().getBodyAsString());
        } else if (event instanceof PageEvent) {
            PageEvent pageEvent = (PageEvent)event;
            notificationBuilder.title(pageEvent.getPage().getTitle()).itemTitle(pageEvent.getPage().getDisplayTitle()).description(pageEvent.getPage().getBodyAsString());
        } else if (event instanceof BlogPostEvent) {
            BlogPostEvent blogPostEvent = (BlogPostEvent)event;
            notificationBuilder.title(blogPostEvent.getBlogPost().getDisplayTitle()).itemTitle(blogPostEvent.getBlogPost().getTitle()).description(blogPostEvent.getBlogPost().getBodyAsString());
        } else {
            return null;
        }
        return notificationBuilder.createNotification();
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private com.atlassian.mywork.model.Notification sendNotification(User user, com.atlassian.mywork.model.Notification notification) throws InterruptedException, ExecutionException {
        return (com.atlassian.mywork.model.Notification)this.localNotificationService.createOrUpdate(user.getName(), notification).get();
    }

    private static String getContentTypeDescription(ContentEntityObject content) {
        String contentTypeDescription;
        switch (content.getTypeEnum()) {
            default: {
                contentTypeDescription = "a page";
                break;
            }
            case COMMENT: {
                contentTypeDescription = "a comment";
                break;
            }
            case BLOG: {
                contentTypeDescription = "a blog post";
            }
        }
        return contentTypeDescription;
    }

    private /* synthetic */ void lambda$tryToNotifyMailsUser4DisableGroup$13(List remainingNotificationList, ContentEntityObject original, ContentEvent event, String[] IUMDisables, String[] IUMEnables, ConfluenceUser currentUser, String title, NotificationsSender notificationsSender, ConversionContext conversionContext) {
        remainingNotificationList.stream().forEach(notif -> {
            boolean valid = false;
            ContentEntityObject workingContentEntityObject = original == null ? event.getContent() : original;
            List contentPermissionSetList = this.contentPermissionManager.getContentPermissionSets(workingContentEntityObject, "View");
            for (ContentPermissionSet contentPermissionSet : contentPermissionSetList) {
                valid = contentPermissionSet.getUserNames().stream().filter(user -> user.equalsIgnoreCase(notif.getReceiver().getName())).count() > 0L;
                valid = valid || contentPermissionSet.getGroupNames().stream().anyMatch(grp -> Arrays.stream(IUMDisables).anyMatch(grpx -> grp.equals(grpx)));
                boolean bl = valid = valid || contentPermissionSet.getGroupNames().stream().anyMatch(grp -> Arrays.stream(IUMEnables).anyMatch(grpx -> grp.equals(grpx)));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("contentPermissionSet.getUserNames= " + String.join((CharSequence)",", contentPermissionSet.getUserNames()));
                LOG.debug("contentPermissionSet.getGroupNames= " + String.join((CharSequence)",", contentPermissionSet.getGroupNames()));
                LOG.debug("contentPermissionSet user  " + notif.getReceiver().getName() + " valid = " + valid);
            }
            if ((valid || this.contentPermissionManager.hasContentLevelPermission(notif.getReceiver(), "View", workingContentEntityObject) || this.contentPermissionManager.hasContentLevelPermission(notif.getReceiver(), "Edit", workingContentEntityObject)) && this.permissionManager.hasPermission(notif.getReceiver(), Permission.VIEW, (Object)workingContentEntityObject)) {
                this.sendMailNotification(currentUser, event, workingContentEntityObject, title, (Notification)notif, notificationsSender, conversionContext);
            }
        });
    }

    private /* synthetic */ void lambda$tryToEmailMentionsUser4DisableGroup$4(Set mentionedUsernames, List disabledUsers, ContentEntityObject page, ContentEntityObject original, ContentEvent event, ConfluenceUser currentUser, String actionDescription, Comment comment, NotificationsSender notificationsSender, ConversionContext conversionContext) {
        mentionedUsernames.stream().forEach(userName -> {
            try {
                ConfluenceUser toUser = this.userAccessor.getUserByName(userName);
                if (toUser != null && toUser.getName() != null && !DeletedUser.isDeletedUser((User)toUser) && !this.isDisabled(toUser.getName()) && disabledUsers.contains(userName)) {
                    Notification notification = this.notificationManager.getNotificationByUserAndContent((User)toUser, page);
                    if (notification == null) {
                        notification = this.notificationManager.addContentNotification((User)toUser, original == null ? event.getContent() : original);
                    }
                    if (notification != null) {
                        NotificationData notificationData = this.getNotificationDataForEvent(event, (User)currentUser, (ConfluenceEntityObject)original);
                        String fullName = currentUser != null ? currentUser.getFullName() : "Anonymous";
                        notificationData.setSubject(fullName + actionDescription + "\"" + page.getTitle() + "\"");
                        notificationData.setTemplateName("comment-added-notification.vm");
                        notificationData.addToContext("contentType", (Serializable)((Object)"comment"));
                        notificationData.addToContext("comment.id", (Serializable)Long.valueOf(event.getContent().getId()));
                        notificationData.addToContext("comment", (Serializable)event.getContent());
                        notificationData.addToContext("originalContent", (Serializable)(original == null ? event.getContent() : new Comment()));
                        notificationData.addToContext("page", (Serializable)page);
                        notificationData.addToContext("url", (Serializable)((Object)comment.getUrlPath()));
                        this.setPermissionEntity(notificationData);
                        notificationsSender.sendNotification(notification, notificationData, conversionContext);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Mail Notification send " + toUser.getName() + " " + (notification.getReceiver() != null ? notification.getReceiver().getName() : "N/A") + " with email=" + (notification.getReceiver() != null ? notification.getReceiver().getEmail() : "N/A"));
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Exception " + e.getMessage(), (Throwable)e);
            }
        });
    }
}

