/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.mail.ChangeDigestNotificationBean;
import com.atlassian.confluence.mail.jobs.DailyReportManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import de.accxia.apps.confluence.ium.analytical.ChartRepository;
import de.accxia.apps.confluence.ium.analytical.CounterActionDTO;
import de.accxia.apps.confluence.ium.analytical.CounterActionEvent;
import de.accxia.apps.confluence.ium.analytical.CounterActionEventType;
import de.accxia.apps.confluence.ium.analytical.LicenseAnalyticalService;
import de.accxia.apps.confluence.ium.analytical.LicenseTierDTO;
import de.accxia.apps.confluence.ium.analytical.PermissionMarkerType;
import de.accxia.apps.confluence.ium.analytical.UserActionEvent;
import de.accxia.apps.confluence.ium.analytical.UserActionEventType;
import de.accxia.apps.confluence.ium.analytical.UserActivity;
import de.accxia.apps.confluence.ium.analytical.UserAnalyticalDTO;
import de.accxia.apps.confluence.ium.analytical.UserReference;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.listener.SyncListener;
import de.accxia.apps.confluence.ium.model.IUMAlert;
import de.accxia.apps.confluence.ium.model.IUMAlertDTO;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.notif.IUMDailyReportManager;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.repository.PocketRepository;
import de.accxia.apps.confluence.ium.search.GroupUserSearcher;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.DateUtil;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import de.accxia.apps.confluence.ium.util.ReflectionLoggingConfigService;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/test")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Component
public class TestServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final UserChecker userChecker;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final RecentlyViewedManager recentlyViewedManager;
    @ComponentImport
    private final DailyReportManager dailyReportManager;
    @ComponentImport
    private final ContentEntityManager contentEntityManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final I18NBeanFactory i18NBeanFactory;
    @ComponentImport
    private final LocaleManager localeManager;
    @ComponentImport
    private final LicenseService licenseService;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final EventPublisher eventPublisher;
    private PocketRepository pocketRepository;
    private final GroupUserSearcher groupUserSearcher;
    private final IUMDailyReportManager iumDailyReportManager;
    private final IUMAlertRepository iumAlertRepository;
    private final HelperTrialProcessing helperTrialProcessing;
    private final IUMHelperService iumHelperService;
    private final IUMHelperCacheService iumHelperCacheService;
    private final SyncListener syncListener;
    private final LicenseAnalyticalService licenseAnalyticalService;
    private final ChartRepository chartRepository;
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ReflectionLoggingConfigService loggingConfigService;
    private static final Random PRNG = new Random();

    @Inject
    public TestServlet(GroupManager groupManager, UserManager userManager, UserAccessor userAccessor, UserChecker userChecker, PocketRepository pocketRepository, RecentlyViewedManager recentlyViewedManager, IUMHelperService iumHelperService, GroupUserSearcher groupUserSearcher, DailyReportManager dailyReportManager, ContentEntityManager contentEntityManager, PermissionManager permissionManager, NotificationManager notificationManager, IUMDailyReportManager iumDailyReportManager, IUMAlertRepository iumAlertRepository, HelperTrialProcessing helperTrialProcessing, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, LicenseService licenseService, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, BandanaManager bandanaManager, EventPublisher eventPublisher, IUMHelperCacheService iumHelperCacheService, SyncListener syncListener, LicenseAnalyticalService licenseAnalyticalService, ChartRepository chartRepository) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.userChecker = userChecker;
        this.recentlyViewedManager = recentlyViewedManager;
        this.pocketRepository = pocketRepository;
        this.dailyReportManager = dailyReportManager;
        this.contentEntityManager = contentEntityManager;
        this.permissionManager = permissionManager;
        this.notificationManager = notificationManager;
        this.iumDailyReportManager = iumDailyReportManager;
        this.iumAlertRepository = iumAlertRepository;
        this.groupUserSearcher = groupUserSearcher;
        this.helperTrialProcessing = helperTrialProcessing;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.iumHelperService = iumHelperService;
        this.licenseService = licenseService;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.bandanaManager = bandanaManager;
        this.eventPublisher = eventPublisher;
        this.iumHelperCacheService = iumHelperCacheService;
        this.syncListener = syncListener;
        this.licenseAnalyticalService = licenseAnalyticalService;
        this.chartRepository = chartRepository;
        this.loggingConfigService = new ReflectionLoggingConfigService(ContainerManager.getComponent((String)"loggingConfigService"));
    }

    @Path(value="/kill")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getKillSession(@Context HttpServletRequest request) {
        request.getSession().invalidate();
        LOG.warn("Session invalidate");
        return Response.ok().build();
    }

    @Path(value="/view")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserAction4Group(@QueryParam(value="group") String groupName) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Group group = this.groupManager.getGroup(groupName);
            Iterable users = this.userAccessor.getMembers(group);
            for (ConfluenceUser user : users) {
                if (this.userManager.isAdmin(user.getKey())) continue;
                List recent = this.recentlyViewedManager.getRecentlyViewed(user.getKey(), true, 1);
                long lastViewed = 0L;
                if (recent.size() > 0) {
                    lastViewed = ((RecentlyViewed)recent.get(0)).getLastSeen();
                }
                map.put(user.getName(), lastViewed != 0L ? SDF.format(new Date(lastViewed)) : "Never");
            }
            return Response.ok(map).build();
        }
        catch (Exception e) {
            LOG.error("Exception" + e.getMessage(), (Throwable)e);
            return Response.ok(map).build();
        }
    }

    @Path(value="/nav1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllNavUserForGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getAllNavUserForGroup(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInactiveActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String group2 = request.getParameter("group2");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupWithGroupLtTime(group, group2, ts);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav4")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getNavUserForGroupWithGroupLtTime(@Context HttpServletRequest request) {
        String fromGroupName = request.getParameter("fromGroupName");
        String withGroupName = request.getParameter("withGroupName");
        long inactivityInterval = ParseUtil.safeParseInt(request.getParameter("time"));
        long refTS = System.currentTimeMillis() - inactivityInterval * 60L * 1000L;
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupWithGroupLtTime(fromGroupName, withGroupName, new Timestamp(refTS));
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav5")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveNavUserForGroupLtTime(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        long time = ParseUtil.safeParseInt(request.getParameter("time"));
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        Timestamp ts = new Timestamp(new Date().getTime() - time * 1000L * 60L);
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getNavUserForGroupLtTime(group, true, ts, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s - date %s", navUser.getUserName(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s - date %s", navUser.getUserNameEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav6")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav7")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        int offset = ParseUtil.safeParseInt(request.getParameter("offset"));
        int cnt = ParseUtil.safeParseInt(request.getParameter("cnt"));
        String filtergroup = request.getParameter("filtergroup");
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            List<NavUserDTO> navUsers = this.pocketRepository.getOldestUsers(group, filtergroup, offset, cnt);
            for (NavUserDTO navUser : navUsers) {
                if (navUser.getID() != null) {
                    retVal.add(String.format("User %s %s %s - date %s", navUser.getUserName(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), SDF.format(navUser.getLastAccessTime())));
                    continue;
                }
                retVal.add(String.format("User %s %s %s - date %s", navUser.getUserNameEx(), navUser.getDisplayNameEx(), navUser.getUserEmailEx(), "NEVER"));
            }
        }
        return Response.ok(retVal).build();
    }

    @Path(value="/nav8")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response countSortedUserListFromGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String filtergroup = request.getParameter("filtergroup");
        ArrayList retVal = new ArrayList();
        if (this.pocketRepository == null) {
            this.pocketRepository = (PocketRepository)ComponentLocator.getComponent(PocketRepository.class);
        }
        if (this.pocketRepository != null) {
            long countOldestUsers = this.pocketRepository.countOldestUsers(group, filtergroup);
            return Response.ok((Object)countOldestUsers).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
    }

    @Path(value="/gpage")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getMemberNames(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            ArrayList retVal = new ArrayList();
            Group workGroup = this.groupManager.getGroup(group);
            Pager members = this.groupManager.getMemberNames(workGroup);
            return Response.ok((Object)PagerUtils.toList((Pager)members)).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/vpage")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.groupUserSearcher.getActiveUserNamesInGroup(group, 0, 10);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/vpagex")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroupX(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.groupUserSearcher.getActiveUserNamesInGroup(group, 10, 5000);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/vpage2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.groupUserSearcher.getActiveUserNamesInGroup2(group, 0, 10);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/vpage2x")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroup2X(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.groupUserSearcher.getActiveUserNamesInGroup2(group, 10, 5000);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/vpage3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroup3(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.groupUserSearcher.getActiveUserNamesInGroup3(group, 0, 10);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/vpage3x")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroup3X(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.groupUserSearcher.getActiveUserNamesInGroup3(group, 10, 5000);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/wpage")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroup4(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.pocketRepository.getUsersForGroup(group, true, 0, 10);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/wpagex")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getActiveUserNamesInGroup4X(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.pocketRepository.getUsersForGroup(group, true, 10, 5000);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/allgroup")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllActiveUserNamesInGroup(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.iumHelperService.getActiveMemberNames(group);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/allgroup2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllActiveUserNamesInGroup2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        try {
            List<String> retVal = this.iumHelperService.getActiveMemberNames2(group);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/allgroup3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAllActiveUserNamesInGroup3(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String offset = request.getParameter("offset");
        String ctx = request.getParameter("ctx");
        try {
            List<String> retVal = this.iumHelperService.getActiveMemberNames2(group, Integer.parseInt(offset), Integer.parseInt(ctx));
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/gpage2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getMemberNames2(@Context HttpServletRequest request) {
        String group = request.getParameter("group");
        String page = request.getParameter("page");
        try {
            List<String> retVal = this.groupUserSearcher.getActiveUserNamesInGroup(group, 0, 5000);
            return Response.ok(retVal).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing pocket").build();
        }
    }

    @Path(value="/cnotif")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response countChangeReports(@Context HttpServletRequest request) {
        String strDays = request.getParameter("days");
        int days = strDays != null ? Integer.parseInt(strDays) : 10;
        Date date = DateUtils.addDays((Date)new Date(), (int)(-1 * days));
        ChangeDigestNotificationBean changeDigestNotificationBean = new ChangeDigestNotificationBean(this.contentEntityManager, this.userAccessor, this.permissionManager, this.notificationManager);
        List changeReports = changeDigestNotificationBean.getAllChangeReports(date);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("countChangeReports: " + changeReports.size())).build();
    }

    @Path(value="/notif2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response digestNotificationBean2(@Context HttpServletRequest request) {
        String strDays = request.getParameter("days");
        int days = strDays != null ? Integer.parseInt(strDays) : 10;
        Date date = DateUtils.addDays((Date)new Date(), (int)(-1 * days));
        this.permissionManager.withExemption(() -> this.dailyReportManager.generateDailyReports());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"dailyReportManager").build();
    }

    @Path(value="/notif")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response digestNotificationBean(@Context HttpServletRequest request) {
        String strDays = request.getParameter("days");
        int days = strDays != null ? Integer.parseInt(strDays) : 10;
        Date date = DateUtils.addDays((Date)new Date(), (int)(-1 * days));
        this.iumDailyReportManager.generateDailyReportsExemption(-1 * days);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("GenerateDailyReports days=" + strDays)).build();
    }

    @Path(value="/addGroupNotif")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addDigestNotificationBean(@Context HttpServletRequest request) {
        String groupName = request.getParameter("groupName");
        try {
            Group group = this.groupManager.getGroup(groupName);
            if (group != null) {
                Iterable iterable = this.userAccessor.getMembers(group);
                for (ConfluenceUser it : iterable) {
                    this.notificationManager.addDailyReportNotification(it);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("addDigestNotificationBean : " + e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("addDigestNotificationBean groupName=" + groupName)).build();
    }

    @Path(value="/alert1")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAlerts(@Context HttpServletRequest request) {
        ArrayList retVal = new ArrayList();
        if (this.iumAlertRepository != null) {
            IUMAlert[] iumAlerts = this.iumAlertRepository.getActiveAlerts();
            List alertList = Arrays.stream(iumAlerts).map(IUMAlertDTO::fromAO).collect(Collectors.toList());
            return Response.ok(alertList).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing alert repository").build();
    }

    private I18NBean i18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }

    @Path(value="/prop")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getProperties(@Context HttpServletRequest request) {
        String username = request.getParameter("username");
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.exceed.license"));
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.copy.group"));
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.removed.free.group"));
        retVal.add(this.i18nBean().getText("de.accxia.apps.confluence.IUM.copy.group.html"));
        return Response.ok(retVal).build();
    }

    @Path(value="/lic")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLic(@Context HttpServletRequest request) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (ConditionEvaluatorIUMImpl.getSideLicense() != null) {
            retVal.add(ConditionEvaluatorIUMImpl.getSideLicense().getAppKey());
            retVal.add(ConditionEvaluatorIUMImpl.getSideLicense().getCustomer());
            retVal.add(String.valueOf(ConditionEvaluatorIUMImpl.getSideLicense().getUsers()));
            retVal.add(ConditionEvaluatorIUMImpl.getSideLicense().getDueDate().toString());
        }
        retVal.add(DAO.getSideLicense());
        return Response.ok(retVal).build();
    }

    @Path(value="/adj")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response adjustStatus4FreeVersion(@Context HttpServletRequest request) {
        if (!ConditionEvaluatorIUMImpl.isFreeVersion()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMMembershipJob not trial at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            ArrayList retVal = new ArrayList();
            return Response.ok(retVal).build();
        }
        List<ProcessResult> processResults = this.helperTrialProcessing.adjustStatus4FreeVersion();
        return Response.ok(processResults).build();
    }

    @Path(value="/detail")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getRunDetailsDao(@Context HttpServletRequest request) {
        try {
            try {
                Class<?> clz = this.pluginAccessor.getClassLoader().loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
                Method method = clz.getDeclaredMethod("canUseConfluence", User.class);
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName("xuser1");
                method.invoke(null, this.userAccessor.getUserByName("xuser1"));
                return Response.ok((Object)clz.getName()).build();
            }
            catch (Throwable e) {
                LOG.error("Exception Accxia RunDetailsDao=" + e.getMessage(), e);
                return Response.ok((Object)e.getMessage()).build();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/logger")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLoggerLevel(@Context HttpServletRequest request) {
        try {
            String level = this.loggingConfigService.getLevelForLogger("de.accxia.apps.confluence.ium");
            return Response.ok((Object)String.valueOf(level)).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/logger2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setLoggerLevel(@Context HttpServletRequest request) {
        try {
            String level = request.getParameter("level");
            this.loggingConfigService.setLevelForLogger("de.accxia.apps.confluence.ium", level);
            String newLevel = this.loggingConfigService.getLevelForLogger("de.accxia.apps.confluence.ium");
            this.syncListener.sendMessage("LOGGER:de.accxia.apps.confluence.ium," + newLevel);
            return Response.ok((Object)(newLevel == null ? "N/A" : newLevel)).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    public String getServerId() {
        ConfluenceBandanaContext context = new ConfluenceBandanaContext();
        Object coreId = this.bandanaManager.getValue((BandanaContext)context, "com.atlassian.core");
        Object serverId = this.bandanaManager.getValue((BandanaContext)context, "confluence.server.id");
        return serverId != null ? serverId.toString() : "Server ID not found";
    }

    @Path(value="/analytical")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendAnalyticalEvent(@Context HttpServletRequest request) {
        try {
            CounterActionEvent event = CounterActionEvent.createAnalyticalEvent4Type(CounterActionEventType.randomEventType());
            this.eventPublisher.publish((Object)event);
            return Response.ok((Object)((Object)event.getEventType())).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/analyze")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendAnalyze(@Context HttpServletRequest request) {
        try {
            return Response.ok((Object)this.licenseAnalyticalService.getCounterAction()).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/license")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response licenseDetails(@Context HttpServletRequest request) {
        if (this.licenseService != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IUMMembershipJob not trial at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("PlatformId", this.applicationProperties.getPlatformId());
            map.put("ServerId", this.licenseService.retrieve().getServerId());
            map.put("AnonymizedNodeIdentifier", this.getServerId());
            return Response.ok(map).build();
        }
        return Response.serverError().entity((Object)"Missing license").build();
    }

    @Path(value="/license2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLicenseSize(@Context HttpServletRequest request) {
        try {
            ConfluenceLicense confluenceLicense = this.licenseService.retrieve();
            return Response.ok((Object)confluenceLicense).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/license3")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserNamesWithConfluenceAccess(@Context HttpServletRequest request) {
        try {
            List users = this.userAccessor.getUserNamesWithConfluenceAccess();
            return Response.ok((Object)users).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/license4")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInfoUserChecker(@Context HttpServletRequest request) {
        try {
            ConfluenceLicense confluenceLicense = this.licenseService.retrieve();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("NumberOfRegisteredUsers", String.valueOf(this.userChecker.getNumberOfRegisteredUsers()));
            map.put("MaximumNumberOfUsers", String.valueOf(confluenceLicense.getMaximumNumberOfUsers()));
            return Response.ok(map).build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/users")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendAsyncUserEvent(@Context HttpServletRequest request) {
        try {
            String sourceGroups = DAO.getIUMGroupsDisabled();
            if (!StringUtils.isEmpty((CharSequence)sourceGroups)) {
                String[] groups = sourceGroups.split(",");
                List<String> users = this.iumHelperCacheService.getUsersForGroup(groups[0]);
                ArrayList<String> eventsUsers = new ArrayList<String>();
                for (String user : users) {
                    UserActionEvent event = new UserActionEvent(UserActionEvent.class, this.userAccessor.getUserByName(user), UserActionEventType.randomEventType());
                    this.eventPublisher.publish((Object)event);
                    eventsUsers.add(user);
                }
                return Response.ok(eventsUsers).build();
            }
            return Response.serverError().entity((Object)"Missing groups").build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/saved2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response savedAsyncUsers(@Context HttpServletRequest request) {
        try {
            String sourceGroups = DAO.getIUMGroupsDisabled();
            if (!StringUtils.isEmpty((CharSequence)sourceGroups)) {
                String[] groups = sourceGroups.split(",");
                List<String> users = this.iumHelperCacheService.getUsersForGroup(groups[0]);
                ArrayList<UserAnalyticalDTO> eventsUsers = new ArrayList<UserAnalyticalDTO>();
                for (String user : users) {
                    PermissionMarkerType isConfluence = PermissionMarkerType.randomPermissionMarkerType();
                    PermissionMarkerType isIum = PermissionMarkerType.randomPermissionMarkerType();
                    PermissionMarkerType isAdmin = PermissionMarkerType.randomPermissionMarkerType();
                    int banned = PRNG.nextInt(2);
                    int jobBanned = PRNG.nextInt(2);
                    Date actionDate = DateUtil.getDate();
                    int actionHour = DateUtil.getCurrentHour();
                    UserAnalyticalDTO userAnalyticalDTO = new UserAnalyticalDTO(null, user, isConfluence, isIum, isAdmin, banned, jobBanned, actionHour, actionDate);
                    eventsUsers.add(userAnalyticalDTO);
                }
                this.licenseAnalyticalService.savedToDatabase(eventsUsers);
                return Response.ok(eventsUsers).build();
            }
            return Response.serverError().entity((Object)"Missing groups").build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/saved")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendSavedAsyncUsers(@Context HttpServletRequest request) {
        try {
            String sourceGroups = DAO.getIUMGroupsDisabled();
            if (!StringUtils.isEmpty((CharSequence)sourceGroups)) {
                String[] groups = sourceGroups.split(",");
                List<String> users = this.iumHelperCacheService.getUsersForGroup(groups[0]);
                ArrayList<String> eventsUsers = new ArrayList<String>();
                for (int i = 0; i < 20; ++i) {
                    String user = users.get(PRNG.nextInt(users.size()));
                    UserActionEvent event = new UserActionEvent(UserActionEvent.class, this.userAccessor.getUserByName(user), UserActionEventType.USER_ACTION);
                    this.eventPublisher.publish((Object)event);
                    eventsUsers.add(user);
                }
                return Response.ok(eventsUsers).build();
            }
            return Response.serverError().entity((Object)"Missing groups").build();
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @Path(value="/analyze2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendAnalyze2(@Context HttpServletRequest request) {
        return Response.ok(this.licenseAnalyticalService.getUserActionMap()).build();
    }

    @Path(value="/evaluation2")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendEvaluation2(@Context HttpServletRequest request) {
        Date date = DateUtil.getDate();
        CounterActionDTO counterAction = this.licenseAnalyticalService.getCounterActionByDay(date);
        LicenseTierDTO licenseTier = this.licenseAnalyticalService.getLicenseTierByDay(date);
        List<UserAnalyticalDTO> userAnalyticalList = this.licenseAnalyticalService.getUserAnalyticalByDay(date);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("counterAction", counterAction);
        params.put("licenseTier", licenseTier);
        params.put("userAnalytical", userAnalyticalList);
        return Response.ok(params).build();
    }

    @Path(value="/evaluation")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendEvaluation(@Context HttpServletRequest request) {
        Date date = DateUtil.getDate();
        int month = ParseUtil.safeParseInt(request.getParameter("month"), 5);
        int year = ParseUtil.safeParseInt(request.getParameter("year"), 2025);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<CounterActionDTO> counterAction = this.licenseAnalyticalService.getCounterActionByInterval(startDate, endDate);
        List<LicenseTierDTO> licenseTier = this.licenseAnalyticalService.getLicenseTierByInterval(startDate, endDate);
        Map<String, List<UserAnalyticalDTO>> userAnalyticalList = this.licenseAnalyticalService.getUserAnalyticalByInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("counterAction", counterAction);
        params.put("licenseTier", licenseTier);
        params.put("userAnalytical", userAnalyticalList);
        return Response.ok(params).build();
    }

    @Path(value="/xcounter")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCounter(@Context HttpServletRequest request) {
        CounterActionDTO counterAction = this.licenseAnalyticalService.getCounterAction();
        LicenseTierDTO licenseTier = this.licenseAnalyticalService.getLicenseTier();
        ConcurrentHashMap<UserReference, UserActivity> action = this.licenseAnalyticalService.getUserActionMap();
        this.licenseAnalyticalService.testFlushDatabase();
        return Response.ok((Object)"Ok").build();
    }
}

