/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import de.accxia.apps.confluence.ium.analytical.UserActionEvent;
import de.accxia.apps.confluence.ium.analytical.UserActionEventType;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.servlet.filter.AccxiaUserSessionTracker;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class AccessLogFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AccessLogFilter.class);
    @ConfluenceImport
    private EventPublisher eventPublisher;
    private final AccxiaUserSessionTracker accxiaUserSessionTracker;

    @Inject
    public AccessLogFilter(AccxiaUserSessionTracker accxiaUserSessionTracker, EventPublisher eventPublisher) {
        this.accxiaUserSessionTracker = accxiaUserSessionTracker;
        this.eventPublisher = eventPublisher;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AccessLogFilter initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.doUserAnalytical(httpServletRequest, httpServletResponse);
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            try {
                this.accxiaUserSessionTracker.recordInteraction(httpServletRequest, httpServletResponse);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void doUserAnalytical(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (!DAO.getAuditStatus()) {
            return;
        }
        if (userName == null || requestURI == null) {
            return;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return;
        }
        try {
            if (DAO.getAuditStatus()) {
                UserActionEvent userActionEvent = new UserActionEvent(user, UserActionEventType.USER_ACTION);
                this.eventPublisher.publish((Object)userActionEvent);
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }
}

