/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import de.accxia.apps.confluence.ium.util.Pair;
import java.text.SimpleDateFormat;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtil.class);

    public static Date getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2) && calendar1.get(5) == calendar2.get(5);
    }

    public static int getHourFromDate(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getCurrentHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        int currentMonth = calendar.get(2);
        int currentYear = calendar.get(1);
        if (currentMonth <= month) {
            --currentYear;
        }
        calendar.set(year, month - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        int currentMonth = calendar.get(2);
        int currentYear = calendar.get(1);
        if (currentMonth <= month) {
            --currentYear;
        }
        calendar.set(year, month - 1, 1, 23, 59, 59);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static List<Pair> getPrevious12Months() {
        ArrayList<Pair> monthsList = new ArrayList<Pair>();
        SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM yyyy", Locale.ENGLISH);
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyyMM", Locale.ENGLISH);
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < 12; ++i) {
            monthsList.add(new Pair(yearFormat.format(calendar.getTime()), monthFormat.format(calendar.getTime())));
            calendar.add(2, -1);
        }
        return monthsList;
    }

    public static int getDaysInMonth(int year, int month) {
        if (month < 1 || month > 12) {
            LOG.error("Month must be between 1 and 12.");
            return 0;
        }
        YearMonth yearMonth = YearMonth.of(year, month);
        return yearMonth.lengthOfMonth();
    }

    public static String getMonthName(int monthNumber) {
        if (monthNumber < 1 || monthNumber > 12) {
            throw new IllegalArgumentException("Month number must be between 1 and 12.");
        }
        return Month.of(monthNumber).getDisplayName(TextStyle.FULL, Locale.getDefault());
    }

    public static int getDayFromDate(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }
}

