/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionLoggingConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionLoggingConfigService.class);
    private final Object log4j2ConfigService;

    public ReflectionLoggingConfigService(Object log4j2ConfigService) {
        this.log4j2ConfigService = log4j2ConfigService;
    }

    public void setLevelForLogger(String className, String levelName) {
        Class<?> cls = this.log4j2ConfigService.getClass();
        try {
            Method method = cls.getDeclaredMethod("setLevelForLogger", String.class, String.class);
            method.setAccessible(true);
            method.invoke(this.log4j2ConfigService, className, levelName);
        }
        catch (Exception e) {
            LOG.error("Error setting logger level: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getLevelForLogger(String className) {
        try {
            Class<?> cls = this.log4j2ConfigService.getClass();
            Method method = cls.getDeclaredMethod("getLoggerConfig", new Class[0]);
            method.setAccessible(true);
            List loggingConfigEntryList = (List)method.invoke(this.log4j2ConfigService, new Object[0]);
            Class<?> clsConfigEntry = this.log4j2ConfigService.getClass().getClassLoader().loadClass("com.atlassian.confluence.impl.logging.admin.LoggingConfigEntry");
            Method method1 = clsConfigEntry.getDeclaredMethod("getClazz", new Class[0]);
            Method method2 = clsConfigEntry.getDeclaredMethod("getLevel", new Class[0]);
            method1.setAccessible(true);
            method2.setAccessible(true);
            Map<String, String> configEntryList = loggingConfigEntryList.stream().collect(Collectors.toMap(obj -> {
                try {
                    return (String)method1.invoke(obj, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }, obj -> {
                try {
                    return (String)method2.invoke(obj, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }));
            return configEntryList.get(className);
        }
        catch (Exception e) {
            LOG.error("Error getting logger level: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

