/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.analytical;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import de.accxia.apps.confluence.ium.analytical.CounterAction;
import de.accxia.apps.confluence.ium.analytical.CounterActionDTO;
import de.accxia.apps.confluence.ium.util.DateUtil;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={CounterActionRepository.class})
@Named(value="CounterActionRepository")
public class CounterActionRepository {
    private static final Logger LOG = LoggerFactory.getLogger(CounterActionRepository.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public CounterActionRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public CounterActionDTO saveOrUpdate(CounterActionDTO licenseAnalytical) {
        CounterActionDTO analytical = null;
        analytical = licenseAnalytical.getID() != null ? this.updatedBySum(licenseAnalytical) : (licenseAnalytical.getDay() != null ? this.updatedBySum(licenseAnalytical) : this.save(licenseAnalytical));
        return analytical;
    }

    public CounterActionDTO save(CounterActionDTO counterActionDTO) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called save for day {}", (Object)counterActionDTO.getDay());
        }
        final CounterActionDTO[] analyticalDTO = new CounterActionDTO[1];
        final HashMap<String, Comparable<Date>> values = new HashMap<String, Comparable<Date>>();
        values.put("DAY", counterActionDTO.getDay());
        values.put("APP_USER_COUNT", counterActionDTO.getAppUserCount());
        values.put("IUM_LICENSE_COUNT", counterActionDTO.getIumLicenseCount());
        values.put("LOGOUT_USER_COUNT", counterActionDTO.getLogoutUserCount());
        values.put("INACTIVE_USER_COUNT", counterActionDTO.getInactiveUserCount());
        values.put("LICENSE_REQUEST_COUNT", counterActionDTO.getLicenseRequestCount());
        values.put("REDUCED_EXCEED_COUNT", counterActionDTO.getReducedExceedCount());
        values.put("AUTO_REMOVAL_USER_COUNT", counterActionDTO.getAutoRemovalUserCount());
        values.put("GROUP_REMOVAL_USER_COUNT", counterActionDTO.getGroupRemovalUserCount());
        CounterAction response = (CounterAction)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<CounterAction>(){

            public CounterAction doInTransaction() {
                CounterAction response = (CounterAction)CounterActionRepository.this.ao.create(CounterAction.class, values);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Successfully created with ID {}", (Object)response.getID());
                }
                analyticalDTO[0] = CounterActionDTO.fromAO(response);
                return response;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully save for {} with ID {}", (Object)analyticalDTO[0].toString(), (Object)analyticalDTO[0].getID());
        }
        return analyticalDTO[0];
    }

    public CounterActionDTO updatedBySum(final CounterActionDTO counterActionDTO) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called updatedBySum for day {}", (Object)counterActionDTO.getDay());
        }
        final CounterActionDTO[] analyticalDTO = new CounterActionDTO[1];
        CounterAction response = (CounterAction)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<CounterAction>(){

            public CounterAction doInTransaction() {
                CounterAction counterAction = null;
                counterAction = counterActionDTO.getID() != null ? (CounterAction)CounterActionRepository.this.ao.get(CounterAction.class, (Object)counterActionDTO.getID()) : CounterActionRepository.this.getByDay(counterActionDTO.getDay());
                if (counterAction != null && counterAction.getID() != 0 && DateUtil.isSameDay(counterAction.getDay(), counterActionDTO.getDay())) {
                    counterAction.setDay(counterActionDTO.getDay());
                    counterAction.setAppUserCount(counterAction.getAppUserCount() == null ? counterActionDTO.getAppUserCount() : counterAction.getAppUserCount() + counterActionDTO.getAppUserCount());
                    counterAction.setIumLicenseCount(counterAction.getIumLicenseCount() == null ? counterActionDTO.getIumLicenseCount() : counterAction.getIumLicenseCount() + counterActionDTO.getIumLicenseCount());
                    counterAction.setLogoutUserCount(counterAction.getLogoutUserCount() == null ? counterActionDTO.getLogoutUserCount() : counterAction.getLogoutUserCount() + counterActionDTO.getLogoutUserCount());
                    counterAction.setInactiveUserCount(counterAction.getInactiveUserCount() == null ? counterActionDTO.getInactiveUserCount() : counterAction.getInactiveUserCount() + counterActionDTO.getInactiveUserCount());
                    counterAction.setLicenseRequestCount(counterAction.getLicenseRequestCount() == null ? counterActionDTO.getLicenseRequestCount() : counterAction.getLicenseRequestCount() + counterActionDTO.getLicenseRequestCount());
                    counterAction.setReducedExceedCount(counterAction.getReducedExceedCount() == null ? counterActionDTO.getReducedExceedCount() : counterAction.getReducedExceedCount() + counterActionDTO.getReducedExceedCount());
                    counterAction.setAutoRemovalUserCount(counterAction.getAutoRemovalUserCount() == null ? counterActionDTO.getAutoRemovalUserCount() : counterAction.getAutoRemovalUserCount() + counterActionDTO.getAutoRemovalUserCount());
                    counterAction.setGroupRemovalUserCount(counterAction.getGroupRemovalUserCount() == null ? counterActionDTO.getGroupRemovalUserCount() : counterAction.getGroupRemovalUserCount() + counterActionDTO.getGroupRemovalUserCount());
                    counterAction.save();
                } else {
                    HashMap<String, Comparable<Date>> values = new HashMap<String, Comparable<Date>>();
                    values.put("DAY", counterActionDTO.getDay());
                    values.put("APP_USER_COUNT", counterActionDTO.getAppUserCount());
                    values.put("IUM_LICENSE_COUNT", counterActionDTO.getIumLicenseCount());
                    values.put("LOGOUT_USER_COUNT", counterActionDTO.getLogoutUserCount());
                    values.put("INACTIVE_USER_COUNT", counterActionDTO.getInactiveUserCount());
                    values.put("LICENSE_REQUEST_COUNT", counterActionDTO.getLicenseRequestCount());
                    values.put("REDUCED_EXCEED_COUNT", counterActionDTO.getReducedExceedCount());
                    values.put("AUTO_REMOVAL_USER_COUNT", counterActionDTO.getAutoRemovalUserCount());
                    values.put("GROUP_REMOVAL_USER_COUNT", counterActionDTO.getGroupRemovalUserCount());
                    counterAction = (CounterAction)CounterActionRepository.this.ao.create(CounterAction.class, values);
                }
                analyticalDTO[0] = CounterActionDTO.fromAO(counterAction);
                return counterAction;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully updatedBySum for {} with ID {}", (Object)analyticalDTO[0].toString(), (Object)analyticalDTO[0].getID());
        }
        return analyticalDTO[0];
    }

    public CounterAction getByDay(Date date) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByDay ");
        }
        CounterAction[] queryResult = (CounterAction[])this.ao.find(CounterAction.class, Query.select().where("DAY = ?", new Object[]{date}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByDay");
        }
        if (queryResult != null && queryResult.length > 0) {
            return queryResult[0];
        }
        return null;
    }

    public CounterAction[] getByPeriod(Date startDate, Date endDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByPeriod ");
        }
        CounterAction[] queryResult = (CounterAction[])this.ao.find(CounterAction.class, Query.select().where("DAY BETWEEN ? AND ?", new Object[]{startDate, endDate}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByDay");
        }
        return queryResult;
    }

    public int deleteAll() {
        try {
            int recs = this.ao.deleteWithSQL(CounterAction.class, "1=1", new Object[0]);
            return recs;
        }
        catch (Exception e) {
            LOG.error("Error while deleting all records", (Throwable)e);
            return -1;
        }
    }
}

