/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.analytical;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import de.accxia.apps.confluence.ium.analytical.LicenseTier;
import de.accxia.apps.confluence.ium.analytical.LicenseTierDTO;
import de.accxia.apps.confluence.ium.util.DateUtil;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={LicenseTierRepository.class})
@Named(value="GlobalLicenseRepository")
public class LicenseTierRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseTierRepository.class);
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public LicenseTierRepository(ActiveObjects ao) {
        this.ao = ao;
    }

    public LicenseTierDTO saveOrUpdate(LicenseTierDTO licenseTier) {
        LicenseTierDTO analytical = null;
        analytical = licenseTier.getID() != null ? this.updatedBySum(licenseTier) : (licenseTier.getDay() != null ? this.updatedBySum(licenseTier) : this.save(licenseTier));
        return analytical;
    }

    public LicenseTierDTO save(LicenseTierDTO licenseTierDTO) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called save for day {}", (Object)licenseTierDTO.getDay());
        }
        final LicenseTierDTO[] analyticalDTO = new LicenseTierDTO[1];
        final HashMap<String, Comparable<Date>> values = new HashMap<String, Comparable<Date>>();
        values.put("DAY", licenseTierDTO.getDay());
        values.put("CONFLUENCE_LICENSE_TIER", licenseTierDTO.getConfluenceLicenseTier());
        values.put("CONFLUENCE_USER_TIER", licenseTierDTO.getConfluenceUserTier());
        values.put("IUM_LICENSE_TIER", licenseTierDTO.getIumLicenseTier());
        values.put("IUM_USER_TIER", licenseTierDTO.getIumUserTier());
        LicenseTier response = (LicenseTier)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<LicenseTier>(){

            public LicenseTier doInTransaction() {
                LicenseTier response = (LicenseTier)LicenseTierRepository.this.ao.create(LicenseTier.class, values);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Successfully created with ID {}", (Object)response.getID());
                }
                analyticalDTO[0] = LicenseTierDTO.fromAO(response);
                return response;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully save for {} with ID {}", (Object)analyticalDTO[0].toString(), (Object)analyticalDTO[0].getID());
        }
        return analyticalDTO[0];
    }

    public LicenseTierDTO updatedBySum(final LicenseTierDTO licenseTierDTO) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called updatedBySum for day {}", (Object)licenseTierDTO.getDay());
        }
        final LicenseTierDTO[] analyticalDTO = new LicenseTierDTO[1];
        LicenseTier response = (LicenseTier)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<LicenseTier>(){

            public LicenseTier doInTransaction() {
                LicenseTier licenseTier = null;
                licenseTier = licenseTierDTO.getID() != null ? (LicenseTier)LicenseTierRepository.this.ao.get(LicenseTier.class, (Object)licenseTierDTO.getID()) : LicenseTierRepository.this.getByDay(licenseTierDTO.getDay());
                if (licenseTier != null && licenseTier.getID() != 0 && DateUtil.isSameDay(licenseTier.getDay(), licenseTierDTO.getDay())) {
                    licenseTier.setDay(licenseTierDTO.getDay());
                    licenseTier.setConfluenceLicenseTier(LicenseTierRepository.this.getMax(licenseTier.getConfluenceLicenseTier(), licenseTierDTO.getConfluenceLicenseTier()));
                    licenseTier.setConfluenceUserTier(LicenseTierRepository.this.getMax(licenseTier.getConfluenceUserTier(), licenseTierDTO.getConfluenceUserTier()));
                    licenseTier.setIumLicenseTier(LicenseTierRepository.this.getMax(licenseTier.getIumLicenseTier(), licenseTierDTO.getIumLicenseTier()));
                    licenseTier.setIumUserTier(LicenseTierRepository.this.getMax(licenseTier.getIumUserTier(), licenseTierDTO.getIumUserTier()));
                    licenseTier.save();
                } else {
                    HashMap<String, Comparable<Date>> values = new HashMap<String, Comparable<Date>>();
                    values.put("DAY", licenseTierDTO.getDay());
                    values.put("CONFLUENCE_LICENSE_TIER", licenseTierDTO.getConfluenceLicenseTier());
                    values.put("CONFLUENCE_USER_TIER", licenseTierDTO.getConfluenceUserTier());
                    values.put("IUM_LICENSE_TIER", licenseTierDTO.getIumLicenseTier());
                    values.put("IUM_USER_TIER", licenseTierDTO.getIumUserTier());
                    licenseTier = (LicenseTier)LicenseTierRepository.this.ao.create(LicenseTier.class, values);
                }
                analyticalDTO[0] = LicenseTierDTO.fromAO(licenseTier);
                return licenseTier;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully updatedBySum for {} with ID {}", (Object)analyticalDTO[0].toString(), (Object)analyticalDTO[0].getID());
        }
        return analyticalDTO[0];
    }

    public LicenseTier getByDay(Date date) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getAll ");
        }
        LicenseTier[] queryResult = (LicenseTier[])this.ao.find(LicenseTier.class, Query.select().where("DAY = ?", new Object[]{date}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByDay");
        }
        if (queryResult != null && queryResult.length > 0) {
            return queryResult[0];
        }
        return null;
    }

    public LicenseTier[] getByPeriod(Date startDate, Date endDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Called getByPeriod ");
        }
        LicenseTier[] queryResult = (LicenseTier[])this.ao.find(LicenseTier.class, Query.select().where("DAY BETWEEN ? AND ?", new Object[]{startDate, endDate}));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetch result for getByPeriod ");
        }
        return queryResult;
    }

    public int deleteAll() {
        try {
            int recs = this.ao.deleteWithSQL(LicenseTier.class, "1=1", new Object[0]);
            return recs;
        }
        catch (Exception e) {
            LOG.error("Error while deleting all records", (Throwable)e);
            return -1;
        }
    }

    private Integer getMax(Integer tier1, Integer tier2) {
        boolean result = false;
        int m1 = tier1 == null ? 0 : tier1;
        int m2 = tier2 == null ? 0 : tier2;
        return Math.max(m1, m2);
    }
}

