/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webresource.api.QueryParams;
import de.accxia.apps.confluence.ium.conditions.IsUserInGroupsConditionBase;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IsUserInGuestGroupsCondition
extends IsUserInGroupsConditionBase {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGuestGroupsCondition.class);
    private static final String GUESTS = "guests";

    @Inject
    public IsUserInGuestGroupsCondition(UserManager userManager, UserAccessor userAccessor) {
        super(userManager, userAccessor);
    }

    @Override
    public boolean shouldDisplay(QueryParams queryParams) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return false;
        }
        if (this.isUserInGroups(user.getName(), GUESTS)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IsUserInGuestGroupsCondition user " + user.getName() + " is in groups=guests");
            }
            return true;
        }
        return false;
    }
}

