/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job.access;

import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.access.IUMBaseAccess;
import de.accxia.apps.confluence.ium.job.access.IntentRemoveAccess;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AccxiaAccessMap {
    private static final Logger LOG = LoggerFactory.getLogger(AccxiaAccessMap.class);
    private ConcurrentMap<String, IUMBaseAccess> concurrentMap = new ConcurrentHashMap<String, IUMBaseAccess>();

    public boolean add(String username) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding user " + username + " to concurrent map");
            }
            IntentRemoveAccess intentRemoveAccess = new IntentRemoveAccess(DAO.getIUMGroups(), DAO.getIUMGroupsDisabled());
            this.concurrentMap.put(username, intentRemoveAccess);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception : " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean add(String username, String enableGroups, String disableGroups) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding user " + username + " to concurrent map");
            }
            IntentRemoveAccess intentRemoveAccess = new IntentRemoveAccess(enableGroups, disableGroups);
            this.concurrentMap.put(username, intentRemoveAccess);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception : " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean remove(String username) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing user " + username + " from concurrent map");
            }
            this.concurrentMap.remove(username);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception : " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.concurrentMap.keySet());
    }

    public IUMBaseAccess getValue(String key) {
        return (IUMBaseAccess)this.concurrentMap.get(key);
    }
}

