/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.AlertType;
import de.accxia.apps.confluence.ium.model.FreeProcessing;
import de.accxia.apps.confluence.ium.model.FreeProcessingFactory;
import de.accxia.apps.confluence.ium.model.IUMAlertDTO;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class HelperTrialProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(HelperTrialProcessing.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final IUMAlertRepository alertRepository;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;

    @Inject
    public HelperTrialProcessing(IUMAlertRepository alertRepository, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService) {
        this.alertRepository = alertRepository;
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
    }

    public List<ProcessResult> adjustStatus4FreeVersion() {
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        String queueSize = DAO.getQueueSize();
        DAO.updateReservedLicense(String.valueOf(3));
        if (!StringUtils.isEmpty((CharSequence)targetGroup)) {
            String[] iumGroups = sourceGroups.split(",");
            String[] iumGroupDISs = targetGroup.split(",");
            CharSequence[] queueSizes = queueSize.split(",");
            UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
            GroupManager groupManager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
            ArrayList<String> users = new ArrayList<String>();
            int maxUsers = 5;
            int maxQueueSize = 5;
            if (iumGroups.length > 0 && iumGroupDISs.length > 0) {
                for (int i = 0; i < iumGroups.length; ++i) {
                    int adjustSeats = 0;
                    try {
                        int qSize = Integer.parseInt((String)queueSizes[i]);
                        if (qSize > maxQueueSize) {
                            adjustSeats = qSize - maxQueueSize;
                            qSize = maxQueueSize;
                            queueSizes[i] = String.valueOf(qSize);
                            maxQueueSize = 0;
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                    ProcessResult processResult = this.doProcessPair(groupManager, userAccessor, iumGroupDISs[i], iumGroups[i], maxUsers);
                    processResult.setAdjustSeats(adjustSeats);
                    processResultList.add(processResult);
                    users.addAll(processResult.getUsers());
                    try {
                        maxUsers -= this.helperService.getUsersFromGroup(iumGroupDISs[i]).size();
                        continue;
                    }
                    catch (EntityException e) {
                        LOG.error("EntityException " + e.getMessage(), (Throwable)e);
                    }
                }
                DAO.updateQueueSize(String.join((CharSequence)",", queueSizes));
            }
        }
        return processResultList;
    }

    private ProcessResult doProcessPair(GroupManager groupManager, UserAccessor userAccessor, String sourceGroup, String targetGroup, Integer maxUsers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HelperTrialProcessing process groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroup, targetGroup, SDF.format(new Date())});
        }
        int groupNameCount = this.iumHelperCacheService.countFromCacheUsersForGroupReal(sourceGroup);
        ProcessResult processResult = new ProcessResult("MembershipJob", sourceGroup, targetGroup);
        processResult.setUserRemoved(0L);
        if (groupNameCount > maxUsers) {
            try {
                Group sGroup = groupManager.getGroup(sourceGroup);
                Group tGroup = groupManager.getGroup(sourceGroup);
                List<ConfluenceUser> users = this.helperService.getUsersFromGroup(sGroup);
                int removeCount = groupNameCount - maxUsers;
                for (ConfluenceUser user : users) {
                    try {
                        groupManager.removeMembership(sGroup, (User)user);
                        groupManager.removeMembership(tGroup, (User)user);
                        processResult.getUsers().add(user.getName());
                        --removeCount;
                        processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while removing user from group [{}]", (Object)sourceGroup, (Object)e);
                    }
                    if (removeCount != 0) continue;
                    break;
                }
                maxUsers = 0;
            }
            catch (Exception e) {
                LOG.error("Exception while removing user from group [{}]", (Object)sourceGroup, (Object)e);
            }
        }
        return processResult;
    }

    public IUMAlertDTO markSyncProcessingError(AlertType alertType, String userName, String targetGroup, int size) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(HelperTrialProcessing.getMessageForSyncAlerts(targetGroup, size));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public IUMAlertDTO markMembershipChanges(AlertType alertType, String userName, String targetGroup, int adjustUsers, int adjustSeats) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(HelperTrialProcessing.getMessageForMembershipAlerts(targetGroup, adjustUsers, adjustSeats));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public IUMAlertDTO markGroupSizeAdjust(AlertType alertType, String userName, String targetGroup, int adjustUsers, int adjustSeats) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setUserName(userName);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        alertDTO.setMessage(HelperTrialProcessing.getMessageForGroupSizeAlerts(targetGroup, adjustUsers, adjustSeats));
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public IUMAlertDTO markLicenseExpireError(AlertType alertType, long days) {
        IUMAlertDTO alertDTO = new IUMAlertDTO();
        alertDTO.setActive(true);
        alertDTO.setAdmin(true);
        alertDTO.setUser(false);
        alertDTO.setType(alertType != null ? alertType.getValue() : AlertType.ALERT_NONE.getValue());
        if (days > 0L) {
            alertDTO.setMessage(HelperTrialProcessing.getMessageForLicenseWillExpireAlerts(days));
        } else if (days < 0L) {
            alertDTO.setMessage(HelperTrialProcessing.getMessageForLicenseWasExpiredAlerts(days));
        } else {
            alertDTO.setMessage(HelperTrialProcessing.getMessageForLicenseTodayExpiredAlerts(days));
        }
        this.alertRepository.save(alertDTO);
        return alertDTO;
    }

    public FreeProcessing exceedLimitByCopyUsers2TargetGroup(String toGroup, String[] selectedUsers) {
        FreeProcessing freeProcessing = FreeProcessingFactory.createFreeProcessing();
        if (!freeProcessing.isFree()) {
            return freeProcessing;
        }
        String[] groupsDisabled = DAO.getIUMGroupsDisabled().split(",");
        if (!HelperTrialProcessing.checkArray(groupsDisabled, toGroup)) {
            freeProcessing.setWarning(false);
            return freeProcessing;
        }
        freeProcessing.setDisableGroup(toGroup);
        freeProcessing.setCountDisableGroup(this.iumHelperCacheService.countFromCacheUsersForGroupReal(toGroup));
        if (freeProcessing.getCountDisableGroup() + selectedUsers.length > 5) {
            HashSet<String> users = new HashSet<String>();
            users.addAll(this.iumHelperCacheService.getUsersForGroup(toGroup));
            users.addAll(Arrays.asList(selectedUsers));
            if (users.size() > 5) {
                freeProcessing.setWarning(true);
                freeProcessing.setCountUsers(selectedUsers.length);
                freeProcessing.setExceed(users.size() - 5);
                return freeProcessing;
            }
        }
        freeProcessing.setWarning(false);
        return freeProcessing;
    }

    public FreeProcessing exceedLimitByCopyUsers2TargetGroup(String targetGroup, Set<String> selectedUsers) {
        return this.exceedLimitByCopyUsers2TargetGroup(targetGroup, selectedUsers.toArray(new String[selectedUsers.size()]));
    }

    public static String getMessageForManagementOperation(FreeProcessing freeProcessing) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        Locale locale = lManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.confluence.IUM.exceed.license= " + i18NBean.getText("de.accxia.apps.confluence.IUM.exceed.license"));
        }
        return freeProcessing.isWarning() ? String.format(i18NBean.getText("de.accxia.apps.confluence.IUM.exceed.license"), freeProcessing.getCountUsers(), freeProcessing.getDisableGroup(), 5, freeProcessing.getExceed()) : null;
    }

    public static String getMessageForMembershipAlerts(String targetGroup, int adjustUsers, int adjustSeats) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        Locale locale = lManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(locale);
        return String.format(i18NBean.getText("de.accxia.apps.confluence.IUM.removed.free.group"), 5, adjustUsers, targetGroup, adjustSeats);
    }

    public static String getMessageForGroupSizeAlerts(String targetGroup, int adjustUsers, int adjustSeats) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        Locale locale = lManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(locale);
        return String.format(i18NBean.getText("de.accxia.apps.confluence.IUM.removed.free.queue"), 5, adjustUsers, targetGroup, adjustSeats);
    }

    public static String getMessageForSyncAlerts(String targetGroup, int len) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        Locale locale = lManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.confluence.IUM.copy.group= " + i18NBean.getText("de.accxia.apps.confluence.IUM.copy.group"));
        }
        return String.format(i18NBean.getText("de.accxia.apps.confluence.IUM.copy.group"), 5, targetGroup);
    }

    public static String getMessageForLicenseTodayExpiredAlerts(long days) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        Locale locale = lManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.confluence.IUM.expire.today.license.html= " + i18NBean.getText("de.accxia.apps.confluence.IUM.expire.today.license.html"));
        }
        return i18NBean.getText("de.accxia.apps.confluence.IUM.expire.today.license.html");
    }

    public static String getMessageForLicenseWillExpireAlerts(long days) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        Locale locale = lManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.confluence.IUM.expire.will.license.html= " + i18NBean.getText("de.accxia.apps.confluence.IUM.expire.will.license.html"));
        }
        return String.format(i18NBean.getText("de.accxia.apps.confluence.IUM.expire.will.license.html"), days);
    }

    public static String getMessageForLicenseWasExpiredAlerts(long days) {
        LocaleManager lManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        I18NBeanFactory i18NBeanFactory = (I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class);
        Locale locale = lManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        I18NBean i18NBean = i18NBeanFactory.getI18NBean(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Locale=" + locale.getLanguage() + "default=" + Locale.getDefault().getLanguage());
            LOG.debug("de.accxia.apps.confluence.IUM.expire.was.license.html= " + i18NBean.getText("de.accxia.apps.confluence.IUM.expire.was.license.html"));
        }
        return String.format(i18NBean.getText("de.accxia.apps.confluence.IUM.expire.was.license.html"), -1L * days);
    }

    public static boolean isInGroupList(String group, String groups) {
        String[] groupList;
        if (groups == null || groups.isEmpty()) {
            return false;
        }
        if (group == null || group.isEmpty()) {
            return false;
        }
        for (String groupName : groupList = groups.split(",")) {
            if (!groupName.equals(group)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkArray(String[] arr, String targetValue) {
        for (String s : arr) {
            if (!s.equals(targetValue)) continue;
            return true;
        }
        return false;
    }
}

