/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.side;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.confluence.ium.model.IUMAlert;
import de.accxia.apps.confluence.ium.model.IUMAlertDTO;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/ium-alert")
@Named
public class IUMAlertResource {
    @ComponentImport
    private final UserManager userManager;
    private final IUMAlertRepository iumAlertRepository;
    private final HelperTrialProcessing helperTrialProcessing;

    public IUMAlertResource(UserManager userManager, IUMAlertRepository iumAlertRepository, HelperTrialProcessing helperTrialProcessing) {
        this.userManager = userManager;
        this.iumAlertRepository = iumAlertRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @GET
    @Path(value="/alerts")
    @Produces(value={"application/json"})
    public Response getAdminAlert() {
        IUMAlert[] alerts;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        HashMap map = new HashMap();
        if (user != null && this.isUserAdmin(user) && (alerts = this.iumAlertRepository.getAdminActiveAlerts()) != null && alerts.length > 0) {
            Map<Integer, List<IUMAlertDTO>> mapAlerts = Arrays.stream(alerts).map(IUMAlertDTO::fromAO).collect(Collectors.groupingBy(IUMAlertDTO::getType));
            ArrayList<String> messages = new ArrayList<String>();
            for (Integer key : mapAlerts.keySet()) {
                List<IUMAlertDTO> values = mapAlerts.get(key);
                Optional alert = values.stream().findFirst();
                if (!alert.isPresent()) continue;
                messages.add(((IUMAlertDTO)alert.get()).getMessage());
            }
            map.put("messages", messages);
            return Response.ok(map).build();
        }
        return Response.ok(map).build();
    }

    @POST
    @Path(value="/dismiss")
    @Produces(value={"application/json"})
    public Response dismissAdminAlert() {
        IUMAlert[] alerts;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        HashMap map = new HashMap();
        if (user != null && this.isUserAdmin(user) && (alerts = this.iumAlertRepository.dismissAdminActiveAlert()) != null && alerts.length > 0) {
            Map<Integer, List<IUMAlertDTO>> mapAlerts = Arrays.stream(alerts).map(IUMAlertDTO::fromAO).collect(Collectors.groupingBy(IUMAlertDTO::getType));
            ArrayList<String> messages = new ArrayList<String>();
            for (Integer key : mapAlerts.keySet()) {
                List<IUMAlertDTO> values = mapAlerts.get(key);
                Optional alert = values.stream().findFirst();
                if (!alert.isPresent()) continue;
                messages.add(((IUMAlertDTO)alert.get()).getMessage());
            }
            map.put("messages", messages);
            return Response.ok(map).build();
        }
        return Response.ok(map).build();
    }

    private boolean isUserAdmin(ConfluenceUser user) {
        return this.userManager.isUserInGroup(user.getKey(), "confluence-administrators");
    }
}

