/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseUtil {
    private static Logger LOG = LoggerFactory.getLogger(ParseUtil.class);

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static int safeParseInt(String value, int defValue) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return defValue;
        }
    }

    public static int safeParseInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static long safeParseLong(String str) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static double getNumeric(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            LOG.error("Exception:" + nfe.getMessage(), (Throwable)nfe);
            return 0.0;
        }
        return d;
    }

    public static boolean safeParseBoolean(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        try {
            return Boolean.parseBoolean(str);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

