/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.analytical;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import de.accxia.apps.confluence.ium.analytical.model.UserPeak;
import de.accxia.apps.confluence.ium.analytical.model.UserPeakEx;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={ChartRepository.class})
@Named(value="ChartRepository")
public class ChartRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ChartRepository.class);
    @ComponentImport
    private final ActiveObjects ao;
    private final DatabaseAccessor confluenceDatabaseAccessor;
    private final DataSourceProvider dataSourceProvider;
    private static final String USER_PEAKS_SQL_POSTGRESQL = "SELECT x.\"ACTION_DATE\", max(x.queue) , max(x.users) \n FROM( \n SELECT \"ACTION_DATE\", \"ACTION_HOUR\",  sum(\"BANNED\") as queue , count(\"USERNAME\" ) as users \n FROM \"AO_DD5258_IUM_USER_ACTIVITY\" \n WHERE  \"ACTION_DATE\" BETWEEN ? AND ? \n\t group by \"ACTION_DATE\", \"ACTION_HOUR\"\n\t order by \"ACTION_DATE\", \"ACTION_HOUR\"\n)x \n group by x.\"ACTION_DATE\"";
    private static final String USER_PEAKS_SQL_MYSQL = "SELECT x.ACTION_DATE, max(x.queue) , max(x.users) \n FROM( \n SELECT ACTION_DATE, ACTION_HOUR,  sum(BANNED) as queue , count(USERNAME ) as users \n FROM AO_DD5258_IUM_USER_ACTIVITY \n WHERE  ACTION_DATE BETWEEN ? AND ? \n\t group by ACTION_DATE, ACTION_HOUR\n\t order by ACTION_DATE, ACTION_HOUR\n)x \n group by x.ACTION_DATE";
    private static final String USER_PEAKS_SQL_POSTGRESQL2 = "WITH hourly_sales AS (\n    SELECT \"ACTION_DATE\", \"ACTION_HOUR\",  sum(\"BANNED\") as queue , count(\"USERNAME\" ) as users \n    FROM public.\"AO_DD5258_IUM_USER_ACTIVITY\"\n    where \"IUM\" =1 and \"ACTION_DATE\"  BETWEEN ? AND ?\n    GROUP BY \"ACTION_DATE\", \"ACTION_HOUR\"\n),\nranked_sales AS (\n    SELECT\n        \"ACTION_DATE\", \"ACTION_HOUR\" ,queue,users,\n        ROW_NUMBER() OVER (PARTITION BY \"ACTION_DATE\" ORDER BY queue desc, \"ACTION_HOUR\" desc) AS rn1,\n        ROW_NUMBER() OVER (PARTITION BY \"ACTION_DATE\" ORDER BY users desc,\"ACTION_HOUR\" desc) AS rn2\n    FROM hourly_sales\n)\nSELECT \"ACTION_DATE\", \"ACTION_HOUR\" ,queue ,users,rn1,rn2\nFROM ranked_sales\nWHERE rn1 =1 ";
    private static final String TRUNCATE_TABLE_IUM_COUNTER_EVENT = "truncate table \"AO_DD5258_IUM_COUNTER_EVENT\"";
    private static final String TRUNCATE_TABLE_IUM_COUNTER_LICENSE = "truncate table \"AO_DD5258_IUM_COUNTER_LICENSE\"";
    private static final String TRUNCATE_TABLE_IUM_USER_ACTIVITY = "truncate table \"AO_DD5258_IUM_USER_ACTIVITY\"";

    @Inject
    public ChartRepository(ActiveObjects ao, DatabaseAccessor confluenceDatabaseAccessor, DataSourceProvider dataSourceProvider) {
        this.ao = ao;
        this.dataSourceProvider = dataSourceProvider;
        this.confluenceDatabaseAccessor = confluenceDatabaseAccessor;
    }

    public List<UserPeak> userPeaksForInterval(java.util.Date startDate, java.util.Date endDate) {
        List userPeaksList = (List)this.confluenceDatabaseAccessor.run(databaseConnection -> {
            Connection conn = databaseConnection.getJdbcConnection();
            String userPeaksSQL = this.getUserPeaksSQL();
            if (LOG.isDebugEnabled()) {
                LOG.debug("UserPeaksForInterval startDate = " + startDate);
                LOG.debug("UserPeaksForInterval endDate = " + endDate);
                LOG.debug("Execute = " + userPeaksSQL);
            }
            ArrayList<UserPeak> userPeaks = new ArrayList<UserPeak>();
            try (PreparedStatement stmt = conn.prepareStatement(userPeaksSQL);){
                stmt.setDate(1, this.toSQLDate(startDate));
                stmt.setDate(2, this.toSQLDate(endDate));
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    Date rsDate = rs.getDate(1);
                    int rsQueue = rs.getInt(2);
                    int rsUsers = rs.getInt(3);
                    userPeaks.add(new UserPeak(rsDate, rsUsers, rsQueue));
                }
            }
            catch (SQLException e) {
                LOG.error("SQLException" + e.getMessage(), (Throwable)e);
            }
            return userPeaks;
        });
        return userPeaksList;
    }

    public List<UserPeak> userPeaksForInterval2(java.util.Date startDate, java.util.Date endDate) {
        List userPeaksList = (List)this.confluenceDatabaseAccessor.run(databaseConnection -> {
            Connection conn = databaseConnection.getJdbcConnection();
            String userPeaksSQL = USER_PEAKS_SQL_POSTGRESQL2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("UserPeaksForInterval startDate = " + startDate);
                LOG.debug("UserPeaksForInterval endDate = " + endDate);
                LOG.debug("Execute = " + userPeaksSQL);
            }
            ArrayList<UserPeakEx> userPeaks = new ArrayList<UserPeakEx>();
            try (PreparedStatement stmt = conn.prepareStatement(userPeaksSQL);){
                stmt.setDate(1, this.toSQLDate(startDate));
                stmt.setDate(2, this.toSQLDate(endDate));
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    Date rsDate = rs.getDate(1);
                    int rsHour = rs.getInt(2);
                    int rsQueue = rs.getInt(3);
                    int rsUsers = rs.getInt(4);
                    userPeaks.add(new UserPeakEx(rsDate, rsHour, rsUsers, rsQueue));
                }
            }
            catch (SQLException e) {
                LOG.error("SQLException" + e.getMessage(), (Throwable)e);
            }
            return userPeaks;
        });
        return userPeaksList;
    }

    public boolean truncateTable() {
        boolean truncateTable = (Boolean)this.confluenceDatabaseAccessor.run(databaseConnection -> {
            Boolean bl;
            block11: {
                Connection conn = databaseConnection.getJdbcConnection();
                ArrayList userPeaks = new ArrayList();
                Statement stmt = conn.createStatement();
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Execute = truncate table \"AO_DD5258_IUM_COUNTER_EVENT\"");
                    }
                    stmt.execute(TRUNCATE_TABLE_IUM_COUNTER_EVENT);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Execute = truncate table \"AO_DD5258_IUM_COUNTER_LICENSE\"");
                    }
                    stmt.execute(TRUNCATE_TABLE_IUM_COUNTER_LICENSE);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Execute = truncate table \"AO_DD5258_IUM_COUNTER_LICENSE\"");
                    }
                    stmt.execute(TRUNCATE_TABLE_IUM_USER_ACTIVITY);
                    bl = true;
                    if (stmt == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        LOG.error("SQLException" + e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                stmt.close();
            }
            return bl;
        });
        return truncateTable;
    }

    private String getUserPeaksSQL() {
        switch (this.dataSourceProvider.getDatabaseType()) {
            case MYSQL: {
                return USER_PEAKS_SQL_MYSQL;
            }
            case POSTGRESQL: {
                return USER_PEAKS_SQL_POSTGRESQL;
            }
            case ORACLE: {
                return USER_PEAKS_SQL_POSTGRESQL;
            }
            case MS_SQL: {
                return USER_PEAKS_SQL_MYSQL;
            }
        }
        return USER_PEAKS_SQL_POSTGRESQL;
    }

    private Date toSQLDate(java.util.Date startDate) {
        return new Date(startDate.getTime());
    }
}

