/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.IUMAccessJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.MessageType;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.confluence.ium.model.JobMessageDTO;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.notif.IUMDailyReportManager;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.repository.JobMessageRepository;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={MonitorJobRunnerImpl.class})
@Named(value="monitorJobRunner")
public class MonitorJobRunnerImpl
implements MonitorJobRunner {
    private static Logger LOG = LoggerFactory.getLogger(MonitorJobRunnerImpl.class);
    public static final String JOB_ID = "JOB_ID";
    public static final String PLUGIN_KEY = "de.accxia.apps.confluence.IUM.IUM4Confluence";
    public static final String GROUP_ID = "de.accxia.apps.confluence.ium.job";
    private final ConcurrentHashMap<JobId, JobRunnerKeyDetail> map;
    @ConfluenceImport
    private final SchedulerService schedulerService;
    @ComponentImport
    private final LocalNotificationService notificationService;
    private DisabledUserManager disabledUserManager;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;
    private final JobResultRepository jobResultRepository;
    private final JobMessageRepository jobMessageRepository;
    private final LicenseService licenseService;
    private final AccxiaAccessMap accxiaAccessMap;
    private final HelperTrialProcessing helperTrialProcessing;
    private final IUMDailyReportManager iumDailyReportManager;
    private final IUMAlertRepository iumAlertRepository;

    @Inject
    public MonitorJobRunnerImpl(SchedulerService schedulerService, LicenseService licenseService, LocalNotificationService notificationService, AccxiaAccessMap accxiaAccessMap, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobMessageRepository jobMessageRepository, JobResultRepository jobResultRepository, HelperTrialProcessing helperTrialProcessing, IUMDailyReportManager iumDailyReportManager, IUMAlertRepository iumAlertRepository) {
        this.schedulerService = schedulerService;
        this.licenseService = licenseService;
        this.iumDailyReportManager = iumDailyReportManager;
        this.iumAlertRepository = iumAlertRepository;
        this.helperTrialProcessing = helperTrialProcessing;
        this.map = new ConcurrentHashMap();
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.notificationService = notificationService;
        this.jobResultRepository = jobResultRepository;
        this.jobMessageRepository = jobMessageRepository;
        this.accxiaAccessMap = accxiaAccessMap;
        try {
            this.disabledUserManager = (DisabledUserManager)ComponentLocator.getComponent(DisabledUserManager.class);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String doSchedule(JobData jobData, final IJob job) throws SchedulerServiceException {
        boolean isStartingNow;
        JobId jobId = JobId.of((String)job.getClass().getName());
        JobRunnerKeyDetail jobRunnerKeyDetail = this.getOrCreateJob(jobId);
        job.injectService(this.helperTrialProcessing, this.helperService, this.iumHelperCacheService, this.jobResultRepository);
        job.injectService(this.iumAlertRepository);
        job.injectService(this.iumDailyReportManager);
        job.injectService(this.accxiaAccessMap);
        this.schedulerService.registerJobRunner(jobRunnerKeyDetail.jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRequest) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Begin ProcessingJob at " + new Date());
                    } else if (LOG.isInfoEnabled() && !(job instanceof IUMAccessJob)) {
                        LOG.info("Begin ProcessingJob at " + new Date());
                    }
                    MonitorJobRunnerImpl.this.doProcessingJob(job, jobRequest.getJobConfig().getParameters());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("End ProcessingJob at " + new Date());
                    } else if (LOG.isInfoEnabled() && !(job instanceof IUMAccessJob)) {
                        LOG.info("End ProcessingJob at " + new Date());
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception ProcessingJob: " + e.getMessage(), (Throwable)e);
                    return JobRunnerResponse.aborted((String)("Task aborted due to the following error : " + e.getMessage()));
                }
                return JobRunnerResponse.success();
            }
        });
        jobData.getParameters().put(JOB_ID, (Serializable)((Object)jobId.toString()));
        Date firstRunTime = null;
        boolean bl = isStartingNow = jobData.getParameters().get("start_immediate") != null && jobData.getParameters().get("start_immediate") instanceof Boolean && (Boolean)jobData.getParameters().get("start_immediate") != false;
        if (isStartingNow) {
            firstRunTime = this.createStartNowRunDate(jobData.getRepeatInterval());
        } else if (jobData.getCronExpression() == null) {
            firstRunTime = jobData.getParameters().get("restart") != null ? this.createNextRunDate(jobData.getRepeatInterval(), jobData.getStartingFrom()) : this.createFirstRunDate(jobData.getRepeatInterval(), jobData.getStartingFrom());
        }
        Schedule schedule = null;
        if (jobData.getCronExpression() != null) {
            schedule = Schedule.forCronExpression((String)jobData.getCronExpression(), (TimeZone)TimeZone.getDefault());
            jobRunnerKeyDetail.currentRunDate = null;
            jobRunnerKeyDetail.nextRunDate = this.schedulerService.calculateNextRunTime(schedule);
        } else {
            schedule = Schedule.forInterval((long)jobData.getRepeatInterval(), (Date)firstRunTime);
            if (isStartingNow) {
                jobRunnerKeyDetail.currentRunDate = new Date();
                jobRunnerKeyDetail.nextRunDate = this.schedulerService.calculateNextRunTime(schedule, new Date(System.currentTimeMillis() + jobData.getRepeatInterval()));
            } else {
                jobRunnerKeyDetail.currentRunDate = null;
                jobRunnerKeyDetail.nextRunDate = this.schedulerService.calculateNextRunTime(schedule);
            }
        }
        boolean runOncePerCluster = jobData.getParameters().get("run_once_per_cluster") != null && jobData.getParameters().get("run_once_per_cluster") instanceof Boolean && (Boolean)jobData.getParameters().get("run_once_per_cluster") != false;
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKeyDetail.jobRunnerKey).withRunMode(runOncePerCluster ? RunMode.RUN_ONCE_PER_CLUSTER : RunMode.RUN_LOCALLY).withParameters(jobData.getParameters()).withSchedule(schedule);
        try {
            this.schedulerService.scheduleJob(jobId, jobConfig);
            LOG.warn("Job schedule with id=" + jobId.toString());
            return jobRunnerKeyDetail.jobRunnerKey.toString();
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new SchedulerServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void doUnSchedule(Class classz) throws SchedulerServiceException {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            LOG.warn("Stopping..." + jobRunnerKeyDetail.jobRunnerKey);
            this.schedulerService.unscheduleJob(jobId);
            this.getOrCreateJob((JobId)jobId).nextRunDate = null;
        }
    }

    @Override
    public JobDetails getJobDetails(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.schedulerService.getJobDetails(jobId);
        }
        return null;
    }

    @Override
    public Date getNextRunDate(Class classz) {
        try {
            JobId jobId = JobId.of((String)classz.getName());
            if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
                JobDetails jobDetails = this.schedulerService.getJobDetails(jobId);
                if (jobDetails == null) {
                    return null;
                }
                long firedAt = System.currentTimeMillis();
                JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
                if (jobDetails.getNextRunTime() != null && jobDetails.getNextRunTime().getTime() < firedAt) {
                    return jobRunnerKeyDetail.nextRunDate;
                }
                return jobDetails.getNextRunTime();
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Date calculateNextRunTime(Class classz, long repeatInterval) {
        try {
            JobId jobId = JobId.of((String)classz.getName());
            if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
                JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
                Date refDate = new Date(System.currentTimeMillis() + repeatInterval);
                return this.schedulerService.calculateNextRunTime(this.schedulerService.getJobDetails(jobId).getSchedule(), refDate);
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void updateLastRunTime(Class classz, long timestamp) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            jobRunnerKeyDetail.currentRunDate = new Date(timestamp);
        }
    }

    @Override
    public RunDetails getLastRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return new RunDetails(){

                @Nonnull
                public Date getStartTime() {
                    return new Date();
                }

                public long getDurationInMillis() {
                    return 0L;
                }

                @Nonnull
                public RunOutcome getRunOutcome() {
                    return null;
                }

                @Nonnull
                public String getMessage() {
                    return "";
                }
            };
        }
        return null;
    }

    @Override
    public RunDetails getLastSuccessfulRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return new RunDetails(){

                @Nonnull
                public Date getStartTime() {
                    return new Date();
                }

                public long getDurationInMillis() {
                    return 0L;
                }

                @Nonnull
                public RunOutcome getRunOutcome() {
                    return null;
                }

                @Nonnull
                public String getMessage() {
                    return "";
                }
            };
        }
        return null;
    }

    @Override
    public boolean isWorking(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    @Override
    public List<JobDetails> getJobsByJobRunnerKey(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return this.schedulerService.getJobsByJobRunnerKey(jobRunnerKeyDetail.jobRunnerKey);
        }
        return Collections.EMPTY_LIST;
    }

    private void doProcessingJob(IJob job, Map<String, Serializable> parameters) {
        if (job != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ProcessingJob parameters ");
                for (Map.Entry<String, Serializable> parameter : parameters.entrySet()) {
                    LOG.debug("key: " + parameter.getKey() + " = " + parameter.getValue());
                }
            }
            long startTime = System.currentTimeMillis();
            String className = (String)((Object)parameters.get(JOB_ID));
            JobId jobId = JobId.of((String)className);
            job.injectService(this.helperTrialProcessing, this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            job.injectService(this.licenseService);
            job.injectService(this.disabledUserManager);
            List<ProcessResult> processResultList = job.doProcessingJob(parameters);
            long stopTime = System.currentTimeMillis();
            long elapsedTime = stopTime - startTime;
            this.doEmitSystemNotification(parameters, this.createPlainMessage(processResultList, elapsedTime));
            this.doSaveProcessResultList(processResultList, parameters, elapsedTime);
            Schedule schedule = this.schedulerService.getJobDetails(jobId).getSchedule();
            this.getOrCreateJob((JobId)jobId).currentRunDate = new Date(System.currentTimeMillis() + 2000L);
            if (schedule != null) {
                Date nextRunDate;
                try {
                    nextRunDate = this.schedulerService.calculateNextRunTime(schedule, this.getOrCreateJob((JobId)jobId).currentRunDate);
                }
                catch (Exception e) {
                    long timeInSecs = System.currentTimeMillis();
                    nextRunDate = new Date(timeInSecs + schedule.getIntervalScheduleInfo().getIntervalInMillis());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} nextRunDate= {}", (Object)this.schedulerService.getJobDetails(jobId).getJobId().toString(), (Object)nextRunDate);
                } else if (LOG.isInfoEnabled() && !(job instanceof IUMAccessJob)) {
                    LOG.info("{} nextRunDate= {}", (Object)this.schedulerService.getJobDetails(jobId).getJobId().toString(), (Object)nextRunDate);
                }
                this.getOrCreateJob((JobId)jobId).nextRunDate = nextRunDate;
            }
        } else {
            LOG.warn("ProcessingJob NO JOB");
        }
    }

    private String createPlainMessage(List<ProcessResult> processResultList, long elapsedTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("Status:Done").append("\n");
        for (ProcessResult processResult : processResultList) {
            sb.append(String.format("Copy From %s to %s #%d", processResult.getSourceGroups(), processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
            sb.append(String.format("Remove From %s #%d", processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
        }
        sb.append(String.format("Duration %5.1f", (double)elapsedTime / 60.0 / 1000.0)).append(" minutes");
        return sb.toString();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        MessageType messageType = ConditionEvaluatorIUMImpl.isFreeVersion() ? MessageType.MESSAGE_TYPE_LICENSE_FREE : MessageType.MESSAGE_TYPE_LICENSE_FREE;
        block8: for (ProcessResult processResult : processResultList) {
            switch (processResult.getProcess()) {
                case "LicenseJob": {
                    this.jobMessageRepository.save(JobMessageDTO.createJobMessage(processResult, messageType, currentUser, elapsedTime));
                    continue block8;
                }
                case "LevelJob": {
                    if (processResult.getUserRemoved() <= 0L) continue block8;
                    this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
                    continue block8;
                }
            }
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private boolean isRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    private boolean stopRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            jobRunnerKeyDetail.nextRunDate = null;
            return true;
        }
        return false;
    }

    private JobRunnerKeyDetail getOrCreateJob(String className) {
        JobId jobId = JobId.of((String)className);
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(className));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private JobRunnerKeyDetail getOrCreateJob(JobId jobId) {
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(jobId.toString()));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private Date createFirstRunDate(long repeatInterval, int hour) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval <= 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(11) >= hour) {
            calendar.set(5, calendar.get(5) + 1);
        }
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long calendarTimeMillis = calendar.getTime().getTime();
        return new Date(calendarTimeMillis + (long)randomNum);
    }

    private Date createNextRunDate(long repeatInterval, int hour) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval <= 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        int dh = (int)(repeatInterval / 3600000L);
        Calendar calendar = Calendar.getInstance();
        int currentHour = calendar.get(11);
        while (hour < 23 && hour <= currentHour) {
            hour += dh;
        }
        if (hour > 23) {
            calendar.set(5, calendar.get(5) + 1);
        }
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long calendarTimeMillis = calendar.getTime().getTime();
        return new Date(calendarTimeMillis + (long)randomNum);
    }

    private Date createStartNowRunDate(long repeatInterval) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval < 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        long currentTimeMillis = System.currentTimeMillis();
        return new Date(currentTimeMillis + (long)randomNum);
    }

    private void doEmitSystemNotification(Map<String, Serializable> parameters, String body) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        try {
            if (currentUser != null) {
                this.sendNotification(currentUser, "Automatic User Sync Job", body);
            }
        }
        catch (Exception e) {
            LOG.error(" " + e.getMessage(), (Throwable)e);
        }
    }

    private Notification sendNotification(String user, String title, String message) throws InterruptedException, ExecutionException {
        Notification notification = (Notification)this.notificationService.createOrUpdate(user, new NotificationBuilder().application(PLUGIN_KEY).title("Sync Job").itemTitle(title).description(message).groupingId(GROUP_ID).createNotification()).get();
        return notification;
    }

    class JobRunnerKeyDetail {
        public JobRunnerKey jobRunnerKey;
        public Date nextRunDate = null;
        public Date currentRunDate = null;

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey, Date currentRunDate, Date nextRunDate) {
            this.jobRunnerKey = jobRunnerKey;
            this.currentRunDate = currentRunDate;
            this.nextRunDate = nextRunDate;
        }

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey) {
            this(jobRunnerKey, null, null);
        }

        public JobRunnerKeyDetail(String className) {
            this.jobRunnerKey = JobRunnerKey.of((String)className);
            this.nextRunDate = null;
            this.currentRunDate = null;
        }
    }
}

