/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.analytical;

import de.accxia.apps.confluence.ium.analytical.CounterAction;
import de.accxia.apps.confluence.ium.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class CounterActionDTO {
    private Integer ID;
    private Date day;
    private Integer appUserCount;
    private Integer iumLicenseCount;
    private Integer logoutUserCount;
    private Integer inactiveUserCount;
    private Integer licenseRequestCount;
    private Integer reducedExceedCount;
    private Integer autoRemovalUserCount;
    private Integer groupRemovalUserCount;

    public CounterActionDTO(Integer ID, Date day, Integer appUserCount, Integer iumLicenseCount, Integer logoutUserCount, Integer inactiveUserCount, Integer licenseRequestCount, Integer reducedExceedCount, Integer autoRemovalUserCount, Integer groupRemovalUserCount) {
        this.ID = ID;
        this.day = day;
        this.appUserCount = appUserCount;
        this.iumLicenseCount = iumLicenseCount;
        this.logoutUserCount = logoutUserCount;
        this.licenseRequestCount = licenseRequestCount;
        this.reducedExceedCount = reducedExceedCount;
        this.inactiveUserCount = inactiveUserCount;
        this.autoRemovalUserCount = autoRemovalUserCount;
        this.groupRemovalUserCount = groupRemovalUserCount;
    }

    public CounterActionDTO(Integer ID, Date day) {
        this(ID, day, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public CounterActionDTO(Date day) {
        this(null, day, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public CounterActionDTO(Integer appUserCount, Integer iumLicenseCount, Integer logoutUserCount, Integer inactiveUserCount, Integer licenseRequestCount, Integer reducedExceedCount, Integer autoRemovalUserCount, Integer groupRemovalUserCount) {
        this(null, null, appUserCount, iumLicenseCount, logoutUserCount, inactiveUserCount, licenseRequestCount, reducedExceedCount, autoRemovalUserCount, groupRemovalUserCount);
    }

    protected CounterActionDTO() {
    }

    public static CounterActionDTO fromAO(CounterAction counterAction) {
        CounterActionDTO counterActionDTO = new CounterActionDTO();
        if (counterAction != null) {
            counterActionDTO.setID(counterAction.getID());
            counterActionDTO.setDay(counterAction.getDay());
            counterActionDTO.setAppUserCount(counterAction.getAppUserCount());
            counterActionDTO.setIumLicenseCount(counterAction.getIumLicenseCount());
            counterActionDTO.setLogoutUserCount(counterAction.getLogoutUserCount());
            counterActionDTO.setLicenseRequestCount(counterAction.getLicenseRequestCount());
            counterActionDTO.setReducedExceedCount(counterAction.getReducedExceedCount());
            counterActionDTO.setInactiveUserCount(counterAction.getInactiveUserCount());
            counterActionDTO.setAutoRemovalUserCount(counterAction.getAutoRemovalUserCount());
            counterActionDTO.setGroupRemovalUserCount(counterAction.getGroupRemovalUserCount());
        }
        return counterActionDTO;
    }

    public static List<CounterActionDTO> fromAOs(CounterAction[] counterActions) {
        ArrayList<CounterActionDTO> counterActionList = new ArrayList<CounterActionDTO>();
        if (counterActions != null) {
            for (CounterAction ca : counterActions) {
                counterActionList.add(CounterActionDTO.fromAO(ca));
            }
        }
        return counterActionList;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterActionDTO that = (CounterActionDTO)o;
        return Objects.equals(this.ID, that.ID) && Objects.equals(this.day, that.day) && Objects.equals(this.appUserCount, that.appUserCount) && Objects.equals(this.iumLicenseCount, that.iumLicenseCount) && Objects.equals(this.logoutUserCount, that.logoutUserCount) && Objects.equals(this.inactiveUserCount, that.inactiveUserCount) && Objects.equals(this.licenseRequestCount, that.licenseRequestCount) && Objects.equals(this.reducedExceedCount, that.reducedExceedCount) && Objects.equals(this.autoRemovalUserCount, that.autoRemovalUserCount) && Objects.equals(this.groupRemovalUserCount, that.groupRemovalUserCount);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.ID);
        result = 31 * result + Objects.hashCode(this.day);
        result = 31 * result + Objects.hashCode(this.appUserCount);
        result = 31 * result + Objects.hashCode(this.iumLicenseCount);
        result = 31 * result + Objects.hashCode(this.logoutUserCount);
        result = 31 * result + Objects.hashCode(this.inactiveUserCount);
        result = 31 * result + Objects.hashCode(this.licenseRequestCount);
        result = 31 * result + Objects.hashCode(this.reducedExceedCount);
        result = 31 * result + Objects.hashCode(this.autoRemovalUserCount);
        result = 31 * result + Objects.hashCode(this.groupRemovalUserCount);
        return result;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public int getDayAsInt() {
        return DateUtil.getDayFromDate(this.day);
    }

    public Integer getAppUserCount() {
        return this.appUserCount;
    }

    public void setAppUserCount(Integer appUserCount) {
        this.appUserCount = appUserCount;
    }

    public Integer getIumLicenseCount() {
        return this.iumLicenseCount;
    }

    public void setIumLicenseCount(Integer iumLicenseCount) {
        this.iumLicenseCount = iumLicenseCount;
    }

    public Integer getLogoutUserCount() {
        return this.logoutUserCount;
    }

    public void setLogoutUserCount(Integer logoutUserCount) {
        this.logoutUserCount = logoutUserCount;
    }

    public Integer getInactiveUserCount() {
        return this.inactiveUserCount;
    }

    public void setInactiveUserCount(Integer inactiveUserCount) {
        this.inactiveUserCount = inactiveUserCount;
    }

    public Integer getAutoRemovalUserCount() {
        return this.autoRemovalUserCount;
    }

    public void setAutoRemovalUserCount(Integer autoRemovalUserCount) {
        this.autoRemovalUserCount = autoRemovalUserCount;
    }

    public Integer getGroupRemovalUserCount() {
        return this.groupRemovalUserCount;
    }

    public void setGroupRemovalUserCount(Integer groupRemovalUserCount) {
        this.groupRemovalUserCount = groupRemovalUserCount;
    }

    public Integer getReducedExceedCount() {
        return this.reducedExceedCount;
    }

    public void setReducedExceedCount(Integer reducedExceedCount) {
        this.reducedExceedCount = reducedExceedCount;
    }

    public Integer getLicenseRequestCount() {
        return this.licenseRequestCount;
    }

    public void setLicenseRequestCount(Integer licenseRequestCount) {
        this.licenseRequestCount = licenseRequestCount;
    }

    public String toString() {
        return "CounterActionDTO{ID=" + this.ID + ", day=" + this.day + ", appUserCount=" + this.appUserCount + ", iumLicenseCount=" + this.iumLicenseCount + ", logoutUserCount=" + this.logoutUserCount + ", inactiveUserCount=" + this.inactiveUserCount + ", licenseRequestCount=" + this.licenseRequestCount + ", reducedExceedCount=" + this.reducedExceedCount + ", autoRemovalUserCount=" + this.autoRemovalUserCount + ", groupRemovalUserCount=" + this.groupRemovalUserCount + "}";
    }
}

