/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.analytical;

import de.accxia.apps.confluence.ium.analytical.LicenseTier;
import de.accxia.apps.confluence.ium.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class LicenseTierDTO {
    private Integer ID;
    private Date day;
    private Integer iumLicenseTier;
    private Integer confluenceLicenseTier;
    private Integer iumUserTier;
    private Integer confluenceUserTier;

    public LicenseTierDTO(Integer ID, Date day, Integer iumUserTier, Integer confluenceUserTier, Integer iumLicenseTier, Integer confluenceLicenseTier) {
        this.ID = ID;
        this.day = day;
        this.iumLicenseTier = iumLicenseTier;
        this.confluenceLicenseTier = confluenceLicenseTier;
        this.iumUserTier = iumUserTier;
        this.confluenceUserTier = confluenceUserTier;
    }

    public LicenseTierDTO(Integer ID, Date day) {
        this(ID, day, 0, 0, 0, 0);
    }

    public LicenseTierDTO(Date day) {
        this(null, day, 0, 0, 0, 0);
    }

    public LicenseTierDTO() {
        this.iumUserTier = 0;
        this.confluenceUserTier = 0;
        this.iumLicenseTier = 0;
        this.confluenceLicenseTier = 0;
    }

    public static LicenseTierDTO fromAO(LicenseTier licenseTier) {
        LicenseTierDTO licenseTierDTO = new LicenseTierDTO();
        if (licenseTier != null) {
            licenseTierDTO.setID(licenseTier.getID());
            licenseTierDTO.setDay(licenseTier.getDay());
            licenseTierDTO.setIumUserTier(licenseTier.getIumUserTier());
            licenseTierDTO.setIumLicenseTier(licenseTier.getIumLicenseTier());
            licenseTierDTO.setConfluenceUserTier(licenseTier.getConfluenceUserTier());
            licenseTierDTO.setConfluenceLicenseTier(licenseTier.getConfluenceLicenseTier());
        }
        return licenseTierDTO;
    }

    public static List<LicenseTierDTO> fromAOs(LicenseTier[] licenseTier) {
        ArrayList<LicenseTierDTO> licenseTierList = new ArrayList<LicenseTierDTO>();
        if (licenseTierList != null) {
            for (LicenseTier la : licenseTier) {
                licenseTierList.add(LicenseTierDTO.fromAO(la));
            }
        }
        return licenseTierList;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseTierDTO that = (LicenseTierDTO)o;
        return Objects.equals(this.ID, that.ID) && Objects.equals(this.day, that.day) && Objects.equals(this.iumUserTier, that.iumUserTier) && Objects.equals(this.confluenceUserTier, that.confluenceUserTier) && Objects.equals(this.iumLicenseTier, that.iumLicenseTier) && Objects.equals(this.confluenceLicenseTier, that.confluenceLicenseTier);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.ID);
        result = 31 * result + Objects.hashCode(this.day);
        result = 31 * result + Objects.hashCode(this.iumUserTier);
        result = 31 * result + Objects.hashCode(this.confluenceUserTier);
        result = 31 * result + Objects.hashCode(this.iumLicenseTier);
        result = 31 * result + Objects.hashCode(this.confluenceLicenseTier);
        return result;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public Date getDay() {
        return this.day;
    }

    public int getDayAsInt() {
        return DateUtil.getDayFromDate(this.day);
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public Integer getIumLicenseTier() {
        return this.iumLicenseTier;
    }

    public void setIumLicenseTier(Integer iumLicenseTier) {
        this.iumLicenseTier = iumLicenseTier;
    }

    public Integer getConfluenceLicenseTier() {
        return this.confluenceLicenseTier;
    }

    public void setConfluenceLicenseTier(Integer confluenceLicenseTier) {
        this.confluenceLicenseTier = confluenceLicenseTier;
    }

    public Integer getIumUserTier() {
        return this.iumUserTier;
    }

    public void setIumUserTier(Integer iumUserTier) {
        this.iumUserTier = iumUserTier;
    }

    public Integer getConfluenceUserTier() {
        return this.confluenceUserTier;
    }

    public void setConfluenceUserTier(Integer confluenceUserTier) {
        this.confluenceUserTier = confluenceUserTier;
    }

    public String toString() {
        return "LicenseTierDTO{ID=" + this.ID + ", day=" + this.day + ", iumUserTier=" + this.iumUserTier + ", confluenceUserTier=" + this.confluenceUserTier + ", iumLicenseTier=" + this.iumLicenseTier + ", confluenceLicenseTier=" + this.confluenceLicenseTier + "}";
    }
}

