/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.analytical;

import java.util.Random;

public enum PermissionMarkerType {
    PERMISSION_NONE(0),
    PERMISSION_ALLOW(1),
    PERMISSION_BOTH(2);

    private static final Random PRNG;
    private final int value;

    private PermissionMarkerType(int value) {
        this.value = value;
    }

    public static PermissionMarkerType from(int permission) {
        PermissionMarkerType[] eventTypes;
        for (PermissionMarkerType eventType : eventTypes = PermissionMarkerType.values()) {
            if (eventType.value != permission) continue;
            return eventType;
        }
        return PERMISSION_NONE;
    }

    public int getValue() {
        return this.value;
    }

    public static PermissionMarkerType randomPermissionMarkerType() {
        PermissionMarkerType[] eventTypes = PermissionMarkerType.values();
        return eventTypes[PRNG.nextInt(eventTypes.length)];
    }

    static {
        PRNG = new Random();
    }
}

