/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.job.access.AccxiaAccessMap;
import de.accxia.apps.confluence.ium.job.access.IUMBaseAccess;
import de.accxia.apps.confluence.ium.job.access.IntentRemoveAccess;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.repository.PocketRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMAccessJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMAccessJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMAccessJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private PocketRepository pocketRepository;
    private JobResultRepository jobResultRepository;
    private AccxiaAccessMap accxiaAccessMap;
    private HelperTrialProcessing helperTrialProcessing;

    private IUMAccessJob() {
    }

    public static IUMAccessJob getInstance() {
        if (instance == null) {
            instance = new IUMAccessJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Override
    public void injectService(AccxiaAccessMap accxiaAccessMap) {
        this.accxiaAccessMap = accxiaAccessMap;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        long timestamp = System.currentTimeMillis();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMAccessJob start process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        for (String username : this.accxiaAccessMap.getKeys()) {
            IUMBaseAccess baseAccess = this.accxiaAccessMap.getValue(username);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMAccessJob groups = {} -> {}  at [ {} ] ", new Object[]{baseAccess.getDisableGroups(), baseAccess.getEnableGroups(), SDF.format(new Date())});
            }
            if (!(baseAccess instanceof IntentRemoveAccess)) continue;
            this.removeUserFromGroup(username, baseAccess.getArrayEnableGroups());
            this.accxiaAccessMap.remove(username);
            ProcessResult processResult = new ProcessResult("AccessJob", baseAccess.getEnableGroups(), baseAccess.getDisableGroups());
            processResultList.add(processResult);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMAccessJob end process #[" + SDF.format(new Date()) + "]  time spent (sec) = " + String.valueOf((System.currentTimeMillis() - timestamp) / 1000L));
        }
        return processResultList;
    }

    private boolean removeUserFromGroup(String username, String[] groups) {
        try {
            for (String group : groups) {
                this.helperService.removeUserFromGroup(username, group);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.info("removeUserFromGroup Intent to removeMembership : user {} from group {} ", new Object[]{username, group});
            }
            return true;
        }
        catch (Exception e) {
            this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean addUserToGroup(String usename, String[] groups) {
        try {
            for (String group : groups) {
                this.helperService.addUserToGroup(usename, group);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.info("addUserToGroup: Intent to addMembership : user {} from group {} ", new Object[]{usename, group});
            }
            return true;
        }
        catch (Exception e) {
            this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

