/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.listener;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import de.accxia.apps.confluence.ium.util.ReflectionLoggingConfigService;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named(value="SyncListener")
public class SyncListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(SyncListener.class);
    private static final String IUM_CHANNEL = "ium-channel";
    private static final String PSEUDO_NODENAME = "Node" + System.currentTimeMillis();
    public static final String LOGGER_PREFIX = "LOGGER:";
    public static final String LOGGER_PREFIX_RESPONSE = "LOGGER_RESPONSE:";
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final ClusterManager clusterManager;
    private ReflectionLoggingConfigService loggingConfigService;

    @Inject
    public SyncListener(EventPublisher eventPublisher, ClusterManager clusterManager) {
        this.eventPublisher = eventPublisher;
        this.clusterManager = clusterManager;
        this.loggingConfigService = new ReflectionLoggingConfigService(ContainerManager.getComponent((String)"loggingConfigService"));
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void sendMessage(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SEND sendMessage=> ium-channel ==> " + message);
        }
        this.sendRemote(IUM_CHANNEL, message);
    }

    private void sendRemote(String channel, String message) {
        if (this.clusterManager.isClustered()) {
            String nodeName;
            ClusterNodeInformation clusterNodeInformation = this.clusterManager.getThisNodeInformation();
            String string = nodeName = clusterNodeInformation != null ? clusterNodeInformation.getAnonymizedNodeIdentifier() : PSEUDO_NODENAME;
            if (clusterNodeInformation != null && LOG.isDebugEnabled()) {
                LOG.debug("onSyncClusterMessage Source=" + clusterNodeInformation.getAnonymizedNodeIdentifier());
            }
            this.eventPublisher.publish((Object)new IUMSyncClusterMessage(nodeName, channel, message, nodeName));
        }
    }

    @EventListener
    public void onIUMSyncClusterMessage(ClusterEventWrapper clusterEventWrapper) {
        ClusterEvent wrappedEvent = clusterEventWrapper.getEvent();
        if (clusterEventWrapper.getEvent() instanceof IUMSyncClusterMessage) {
            String nodeName;
            IUMSyncClusterMessage event = (IUMSyncClusterMessage)wrappedEvent;
            ClusterNodeInformation clusterNodeInformation = this.clusterManager.getThisNodeInformation();
            String string = nodeName = clusterNodeInformation != null ? clusterNodeInformation.getAnonymizedNodeIdentifier() : PSEUDO_NODENAME;
            if (LOG.isDebugEnabled()) {
                LOG.debug("onSyncClusterMessage: channel=" + event.channel + " nodeName=" + nodeName + " message=" + event.getMessage());
            }
            if (IUM_CHANNEL.equals(event.channel) && !nodeName.equals(event.node) && clusterNodeInformation != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RECEIVED channel=ium-channel message=" + event.getMessage());
                }
                if (!StringUtils.isEmpty((CharSequence)event.getMessage())) {
                    if (event.getMessage().startsWith(LOGGER_PREFIX)) {
                        String[] parts = event.getMessage().substring(LOGGER_PREFIX.length()).split(",");
                        this.loggingConfigService.setLevelForLogger(parts[0], parts[1]);
                        this.sendMessage(LOGGER_PREFIX_RESPONSE + parts[1]);
                        return;
                    }
                    if (event.getMessage().startsWith(LOGGER_PREFIX_RESPONSE)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Processed:LOGGER_RESPONSE:" + event.getMessage().substring(LOGGER_PREFIX_RESPONSE.length()));
                        }
                        return;
                    }
                }
            }
        }
    }

    public static class IUMSyncClusterMessage
    extends ConfluenceEvent
    implements ClusterEvent {
        private final String channel;
        private final String message;
        private final String node;

        public IUMSyncClusterMessage(Object src, String channel, String message, String node) {
            super(src);
            this.channel = channel;
            this.message = message;
            this.node = node;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getMessage() {
            return this.message;
        }

        public String getNode() {
            return this.node;
        }
    }
}

