/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.repository;

import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLQuery;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.repository.AccxiaDatabaseAccessor;
import de.accxia.apps.confluence.ium.tables.QGroup;
import de.accxia.apps.confluence.ium.tables.QMembership;
import de.accxia.apps.confluence.ium.tables.QNavUser;
import de.accxia.apps.confluence.ium.tables.QUser;
import de.accxia.apps.confluence.ium.tables.QUserHistory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={PocketRepository.class})
@Named(value="PocketRepository")
public class PocketRepository {
    private static final Logger LOG = LoggerFactory.getLogger(PocketRepository.class);
    private static final String USERS4GROUP_ORACLE = "WITH all_groups AS (\n    SELECT g.id AS group_id FROM cwd_group g  WHERE g.lower_group_name = ? \n    UNION \n    SELECT g2.id AS group_id FROM cwd_membership gm \n    INNER JOIN cwd_group g2 ON gm.child_group_id = g2.id \n    INNER JOIN cwd_group g ON gm.parent_id = g.id \n    WHERE g.lower_group_name = ? \n) \nSELECT user_name \nFROM (\n    SELECT u.user_name, ROW_NUMBER() OVER (ORDER BY u.user_name) AS rn \n    FROM cwd_user u \n    JOIN cwd_membership m ON u.id = m.child_user_id \n    JOIN all_groups ag ON m.parent_id = ag.group_id \n    WHERE u.active = ? \n)\nWHERE rn BETWEEN ? AND  ?\nORDER BY user_name ";
    private static final String USERS4GROUP_POSTGRES = "WITH all_groups AS (\n SELECT g.id AS group_id FROM cwd_group g WHERE g.lower_group_name = ? \n UNION \n    SELECT g2.id AS group_id  FROM cwd_membership gm \n    INNER JOIN cwd_group g2 ON gm.child_group_id = g2.id \n    INNER JOIN cwd_group g ON gm.parent_id = g.id \n    WHERE g.lower_group_name = ? \n) \nSELECT u.user_name FROM cwd_user u \nJOIN cwd_membership m ON u.id = m.child_user_id \nJOIN all_groups ag ON m.parent_id = ag.group_id \nWHERE u.active= ? \nORDER BY u.user_name \nLIMIT ? OFFSET ? ";
    private AccxiaDatabaseAccessor accxiaDatabaseAccessor;
    private DatabaseAccessor confluenceDatabaseAccessor;
    private ExDatabaseAccessor databaseAccessor;
    private final DataSourceProvider dataSourceProvider;

    @Inject
    public PocketRepository(AccxiaDatabaseAccessor accxiaDatabaseAccessor, DatabaseAccessor confluenceDatabaseAccessor, DataSourceProvider dataSourceProvider) {
        this.dataSourceProvider = dataSourceProvider;
        this.confluenceDatabaseAccessor = confluenceDatabaseAccessor;
        this.accxiaDatabaseAccessor = accxiaDatabaseAccessor;
        this.databaseAccessor = this.dataSourceProvider.getDatabaseType() == DatabaseType.ORACLE ? arg_0 -> ((DatabaseAccessor)confluenceDatabaseAccessor).run(arg_0) : (this.dataSourceProvider.getDatabaseType() == DatabaseType.MYSQL ? accxiaDatabaseAccessor::run : accxiaDatabaseAccessor::run);
    }

    @Deprecated
    public List<NavUserDTO> getAllNavUserForGroup(String groupName, int offset, int ctx) {
        String groupNameLowerCase = groupName != null ? groupName.toLowerCase() : "";
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])path.toArray(new Path[0])).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq((Expression)QUser.MEMBERSHIP.lowerUserName))).where((Predicate)QUser.MEMBERSHIP.active.eq((Object)"T").and((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase)))).orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset((long)offset)).limit((long)ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAllNavUserForGroup SQL = " + sqlQuery.toString());
                LOG.debug("getAllNavUserForGroup groupName = " + groupNameLowerCase);
                LOG.debug("getAllNavUserForGroup offset = " + offset);
                LOG.debug("getAllNavUserForGroup ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupWithGroupLtTime(String fromGroupName, String withGroupName, Timestamp timestamp) {
        return this.getNavUserForGroupWithGroupLtTime(fromGroupName, withGroupName, timestamp, -1, 0);
    }

    public List<NavUserDTO> getNavUserForGroupWithGroupLtTime(String fromGroupName, String withGroupName, Timestamp timestamp, int offset, int ctx) {
        String fromGroupNameLowerCase = fromGroupName != null ? fromGroupName.toLowerCase() : "";
        String withGroupNameLowerCase = withGroupName != null ? withGroupName.toLowerCase() : "";
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])path.toArray(new Path[0])).from((Expression)QUser.MEMBERSHIP)).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq((Expression)QUser.MEMBERSHIP.lowerUserName))).innerJoin((EntityPath)QMembership.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on(new Predicate[]{QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId), QGroup.MEMBERSHIP.lowerGroupName.eq((Object)fromGroupNameLowerCase)})).innerJoin((EntityPath)QMembership.MEMBERSHIP2)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP2.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP2)).on(new Predicate[]{QGroup.MEMBERSHIP2.id.eq(QMembership.MEMBERSHIP2.parentId), QGroup.MEMBERSHIP2.lowerGroupName.eq((Object)withGroupNameLowerCase)});
            sqlQuery.where((Predicate)QNavUser.NAVUSER.lastAccessTime.lt((Comparable)timestamp).or((Predicate)QNavUser.NAVUSER.lastAccessTime.isNull()));
            sqlQuery.orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst());
            if (offset != -1) {
                ((SQLQuery)sqlQuery.offset((long)offset)).limit((long)ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupWithGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupWithGroupLtTime groupName = " + fromGroupNameLowerCase);
                LOG.debug("getNavUserForGroupWithGroupLtTime withGroupName = " + withGroupNameLowerCase);
                LOG.debug("getNavUserForGroupWithGroupLtTime timestamp = " + timestamp);
                LOG.debug("getNavUserForGroupWithGroupLtTime offset = " + offset);
                LOG.debug("getNavUserForGroupWithGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupLtTime(String groupName, boolean onlyActive, Timestamp timestamp, int offset, int ctx) {
        String groupNameLowerCase = groupName != null ? groupName.toLowerCase() : "";
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])path.toArray(new Path[0])).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq((Expression)QUser.MEMBERSHIP.lowerUserName));
            if (onlyActive) {
                sqlQuery.where((Predicate)QUser.MEMBERSHIP.active.eq((Object)"T").and((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase)).and((Predicate)QNavUser.NAVUSER.lastAccessTime.lt((Comparable)timestamp).or((Predicate)QNavUser.NAVUSER.lastAccessTime.isNull())));
            } else {
                sqlQuery.where((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase).and((Predicate)QNavUser.NAVUSER.lastAccessTime.lt((Comparable)timestamp).or((Predicate)QNavUser.NAVUSER.lastAccessTime.isNull())));
            }
            ((SQLQuery)((SQLQuery)sqlQuery.orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset((long)offset)).limit((long)ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getNavUserForGroupLtTime SQL = " + sqlQuery.toString());
                LOG.debug("getNavUserForGroupLtTime timestamp = " + timestamp);
                LOG.debug("getNavUserForGroupLtTime onlyActive = " + onlyActive);
                LOG.debug("getNavUserForGroupLtTime groupName = " + groupNameLowerCase);
                LOG.debug("getNavUserForGroupLtTime offset = " + offset);
                LOG.debug("getNavUserForGroupLtTime ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getNavUserForGroupLtTime(String groupName, Timestamp timestamp, int offset, int ctx) {
        return this.getNavUserForGroupLtTime(groupName, true, timestamp, offset, ctx);
    }

    public List<NavUserDTO> getOldestUsers(String groupName, int offset, int ctx) {
        String groupNameLowerCase = groupName != null ? groupName.toLowerCase() : "";
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])path.toArray(new Path[0])).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq((Expression)QUser.MEMBERSHIP.lowerUserName))).where((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase))).orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset((long)offset)).limit((long)ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                LOG.debug("getOldestUsers groupName = " + groupNameLowerCase);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public List<NavUserDTO> getOldestUsers(String groupName, String filterGroup, int offset, int ctx) {
        String groupNameLowerCase = StringUtils.isEmpty((CharSequence)groupName) ? "" : groupName.toLowerCase();
        String filterGroupLowerCase = StringUtils.isEmpty((CharSequence)filterGroup) ? "" : filterGroup.toLowerCase();
        List tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            List path = QNavUser.NAVUSER.getColumns();
            path.add(QUser.MEMBERSHIP.userName);
            path.add(QGroup.MEMBERSHIP.groupName);
            path.add(QUser.MEMBERSHIP.displayName);
            path.add(QUser.MEMBERSHIP.emailAddress);
            SubQueryExpression filterQuery = filterGroupLowerCase == null ? null : (SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)QUser.MEMBERSHIP.lowerUserName).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).where((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)filterGroupLowerCase));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])path.toArray(new Path[0])).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq((Expression)QUser.MEMBERSHIP.lowerUserName));
            if (filterGroupLowerCase != null) {
                sqlQuery.where((Predicate)QUser.MEMBERSHIP.active.eq((Object)"T").and((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase)).and((Predicate)QUser.MEMBERSHIP.userName.notIn(filterQuery)));
            } else {
                sqlQuery.where((Predicate)QUser.MEMBERSHIP.active.eq((Object)"T").and((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase)));
            }
            ((SQLQuery)((SQLQuery)sqlQuery.orderBy(QNavUser.NAVUSER.lastAccessTime.asc().nullsFirst())).offset((long)offset)).limit((long)ctx);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupLowerCase != null) {
                    LOG.debug("getOldestUsers filterGroup = " + filterGroup);
                    LOG.debug("getOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("getOldestUsers groupName = " + groupNameLowerCase);
                LOG.debug("getOldestUsers offset = " + offset);
                LOG.debug("getOldestUsers ctx = " + ctx);
            }
            List list = sqlQuery.fetch();
            return list;
        });
        return this.convertTuplesToNavUserDTO(tupleSQLQuery);
    }

    public long countOldestUsers(String groupName, String filterGroup) {
        String groupNameLowerCase = groupName != null ? groupName.toLowerCase() : "";
        String filterGroupLowerCase = StringUtils.isEmpty((CharSequence)filterGroup) ? null : filterGroup.toLowerCase();
        long tupleSQLQuery = this.databaseAccessor.run(databaseConnection -> {
            SubQueryExpression filterQuery = filterGroupLowerCase == null ? null : (SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression)QUser.MEMBERSHIP.lowerUserName).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).where((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)filterGroupLowerCase));
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[0]).from((Expression)QMembership.MEMBERSHIP)).innerJoin((EntityPath)QUser.MEMBERSHIP)).on((Predicate)QUser.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.childUserId))).innerJoin((EntityPath)QGroup.MEMBERSHIP)).on((Predicate)QGroup.MEMBERSHIP.id.eq(QMembership.MEMBERSHIP.parentId))).leftJoin((EntityPath)QNavUser.NAVUSER)).on((Predicate)QNavUser.NAVUSER.userName.eq((Expression)QUser.MEMBERSHIP.lowerUserName));
            if (filterGroupLowerCase != null) {
                sqlQuery.where((Predicate)QUser.MEMBERSHIP.active.eq((Object)"T").and((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase)).and((Predicate)QUser.MEMBERSHIP.userName.notIn(filterQuery)));
            } else {
                sqlQuery.where((Predicate)QUser.MEMBERSHIP.active.eq((Object)"T").and((Predicate)QGroup.MEMBERSHIP.lowerGroupName.eq((Object)groupNameLowerCase)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("countOldestUsers SQL = " + sqlQuery.toString());
                if (filterGroupLowerCase != null) {
                    LOG.debug("countOldestUsers filterGroup = " + filterGroupLowerCase);
                    LOG.debug("countOldestUsers filterQuery = " + filterQuery.toString());
                }
                LOG.debug("countOldestUsers groupName = " + groupNameLowerCase);
            }
            long retVal = sqlQuery.fetchCount();
            return retVal;
        });
        return tupleSQLQuery;
    }

    public List<String> getUsersForGroup(String groupName, boolean onlyActive, int offset, int ctx) {
        String groupNameLowerCase = groupName != null ? groupName.toLowerCase() : "";
        ArrayList<String> retVal = new ArrayList<String>();
        this.databaseAccessor.run(databaseConnection -> {
            if (this.dataSourceProvider.getDatabaseType() == DatabaseType.ORACLE) {
                String query = USERS4GROUP_ORACLE;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getUsersForGroup = " + query);
                }
                try (PreparedStatement preparedStatement = databaseConnection.getJdbcConnection().prepareStatement(query);){
                    preparedStatement.setString(1, groupNameLowerCase);
                    preparedStatement.setString(2, groupNameLowerCase);
                    preparedStatement.setString(3, "T");
                    preparedStatement.setInt(4, offset);
                    preparedStatement.setInt(5, ctx + offset);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            retVal.add(resultSet.getString("user_name"));
                            if (!LOG.isTraceEnabled()) continue;
                            LOG.trace("getUsersForGroup user_name= " + resultSet.getString("user_name"));
                        }
                    }
                }
                catch (SQLException e) {
                    LOG.error("SQLException = " + e.getMessage(), (Throwable)e);
                }
            } else {
                String query = USERS4GROUP_POSTGRES;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getUsersForGroup = " + query);
                }
                try (PreparedStatement preparedStatement = databaseConnection.getJdbcConnection().prepareStatement(query);){
                    preparedStatement.setString(1, groupNameLowerCase);
                    preparedStatement.setString(2, groupNameLowerCase);
                    preparedStatement.setString(3, "T");
                    preparedStatement.setInt(4, ctx);
                    preparedStatement.setInt(5, offset);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            retVal.add(resultSet.getString("user_name"));
                            if (!LOG.isTraceEnabled()) continue;
                            LOG.trace("getUsersForGroup user_name= " + resultSet.getString("user_name"));
                        }
                    }
                }
                catch (SQLException e) {
                    LOG.error("SQLException = " + e.getMessage(), (Throwable)e);
                }
            }
            return 1;
        });
        return retVal;
    }

    private List<NavUserDTO> convertTuplesToNavUserDTO(List<Tuple> tupleSQLQuery) {
        ArrayList<NavUserDTO> retVal = new ArrayList<NavUserDTO>();
        for (Tuple tuple : tupleSQLQuery) {
            retVal.add(this.convertTupleToEventModel(tuple));
        }
        return retVal;
    }

    private NavUserDTO convertTupleToEventModel(Tuple tuple) {
        NavUserDTO navUserDTO = new NavUserDTO();
        if (tuple.get(QNavUser.NAVUSER.id) != null) {
            navUserDTO.setID((Integer)tuple.get(QNavUser.NAVUSER.id));
            navUserDTO.setRequestCount((Long)tuple.get(QNavUser.NAVUSER.requestCount));
            navUserDTO.setUserName((String)tuple.get((Expression)QNavUser.NAVUSER.userName));
            navUserDTO.setUserKey((String)tuple.get((Expression)QNavUser.NAVUSER.userKey));
            navUserDTO.setLastAccessTime((Date)tuple.get(QNavUser.NAVUSER.lastAccessTime));
            navUserDTO.setCreationTime((Date)tuple.get(QNavUser.NAVUSER.creationTime));
        }
        navUserDTO.setUserNameEx((String)tuple.get((Expression)QUser.MEMBERSHIP.userName));
        navUserDTO.setGroupNameEx((String)tuple.get((Expression)QGroup.MEMBERSHIP.groupName));
        navUserDTO.setDisplayNameEx((String)tuple.get((Expression)QUser.MEMBERSHIP.displayName));
        navUserDTO.setUserEmailEx((String)tuple.get((Expression)QUser.MEMBERSHIP.emailAddress));
        navUserDTO.setLastViewTime(tuple.get(QUserHistory.MEMBERSHIP.lastViewed) != null ? new Date((Long)tuple.get(QUserHistory.MEMBERSHIP.lastViewed)) : null);
        return navUserDTO;
    }

    static interface ExDatabaseAccessor {
        public <T> T run(Function<DatabaseConnection, T> var1);
    }
}

