var IUMCheck = new function() {
    let self=this;
    let theTimer;
    let INTERVAL=15000;
    const ONE_MINUTE=60 * 1000;
    const DELTA=300;
    const DEBUG=false;
    const IUM_CHECK_SLOT_PING='confluence_ium_check_slot_ping'
    const IUM_CHECK_SLOT_LOGOUT='confluence_ium_check_slot_logout'
    const IUM_CHECK_ACCESS_PING='confluence_ium_check_access_ping'

    let doDisabled=function(force){
        //debugger;

        if(force){
            //clean - IUM_CHECK_ACCESS_PING/IUM_CHECK_ACCESS_LOGOUT
            window.localStorage.removeItem(IUM_CHECK_SLOT_PING);
            window.localStorage.removeItem(IUM_CHECK_SLOT_LOGOUT);
            window.localStorage.removeItem(IUM_CHECK_ACCESS_PING);

            AJS.$(".ium_removal").show();
            AJS.$(".ium_queue").hide();

            // document.location.href=AJS.contextPath() + "/logout.action";
            /*
            let redirectPage = encodeURIComponent(window.location.pathname.replace(AJS.contextPath(), ''));
            document.location.href =  AJS.contextPath() + '/login.action?permissionViolation=true&os_destination=' + redirectPage;
             */
            return;

        }

        if(self.theLastUserName){
            document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
        }else {
            document.location.href = AJS.contextPath() + "/dashboard.action";
        }
    }

    let doRetry=function(){
       if(document.forms['retry']){
           document.forms['retry'].submit();
           return;
       }
        //document.location.href="/secure/restore?username="+self.theLastUserName;
        document.location.href = AJS.contextPath() + "/dashboard.action";
    }

    let getJSONDateRef=function(){
        let dateStr=window.localStorage.getItem(IUM_CHECK_SLOT_PING);
        let dateRef =null;
        if(dateStr){
            try{
                dateRef = JSON.parse(dateStr);
            } catch (error) {
                console.error(error);
                dateRef=null;
            }
        }
        return dateRef;

    }

    let doRetryOrStop=function(){
        //called at the end of waiting interval

        let dateRef=getJSONDateRef();
        if(dateRef && dateRef.removal){
            let dateNow = Date.now();
            let dateDiff = dateNow - dateRef.timestamp;
            if(DEBUG){
                console.log("RM:" + "removal " + dateRef.removal + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
            }

            AJS.$(".ium_removal").show();
            AJS.$(".ium_queue").hide();

            return;
        }
        doRetry()
    }

    let checkApplicationAccess=function(){
        // debugger;

        //pass 15 sec
        self.duration=self.duration-INTERVAL;
        console.log("checkApplicationAccess self.duration= "+self.duration);

        if(self.duration>0){
            let dateNow = Date.now();
            let dateStr=window.localStorage.getItem(IUM_CHECK_SLOT_PING);
            let dateRef =null;
            if(dateStr){
                try{
                    let dateRef = JSON.parse(dateStr);
                    let dateDiff = dateNow - dateRef.timestamp;
                    if(DEBUG){
                        console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                    }

                    if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === self.theLastUserName)) {
                        if(DEBUG){
                            console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
                        }
                        doProcessData(dateRef,false);
                        return;
                    }
                } catch (error) {
                    console.error(error);
                    dateRef=null;
                }
            }

            if(DEBUG){
                if(dateRef && dateRef.timestamp){
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
                }else{
                    console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
                }
            }

            self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/apps/check?username="+self.theLastUserName);
        }else{
            callRetry();
        }
    }

    let doProcessData=function(data,withSaving){
       // debugger;

        if(DEBUG){
            console.log("data="+ JSON.stringify(data));
        }

        if(data.freeSlots && (data.removal===false)){
            doRetry()
        }

        if(withSaving){
            data.timestamp = Date.now();
            data.username=self.theLastUserName;
            localStorage.setItem(IUM_CHECK_SLOT_PING,JSON.stringify(data));
            if(DEBUG){
                console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
            }
        }

        if(data.removal===true){
            clearInterval(theTimer);
            doRetryOrStop();
        }
    }

    this.startCheckWatcher=function(){
        //1. retrive input.hidden
        let userName=AJS.$("#username").val();
        let duration=AJS.$("#duration").val();

        // TODO PING 1min
        self.duration = duration ? duration : 1;
        // self.duration = 1;

        //convert to milliseconds
        self.duration=self.duration * ONE_MINUTE;
        INTERVAL =Math.ceil( self.duration/4);
        INTERVAL= INTERVAL<ONE_MINUTE ? INTERVAL :ONE_MINUTE;

        if (typeof (userName)!="undefined"){
            self.theLastUserName=userName;
            theTimer=setInterval(checkApplicationAccess, INTERVAL);


            window.addEventListener('storage', function(event) {
                // Check the changed key and react accordingly
                if (event.key === IUM_CHECK_SLOT_LOGOUT) {
                    let datRef =JSON.parse(event.newValue);

                    console.warn("storage: IUM_CHECK_SLOT_LOGOUT" + datRef);
                    if(self.theLastUserName === datRef.username){
                        doDisabled(!!datRef.force);
                    }
                }
            });

            const onStorageEvent=function(event) {
                // Check the changed key and react accordingly
                if (event.key === IUM_CHECK_ACCESS_PING) {
                    //{"username":"account10","enabled":true,"timestamp":1713290928760}'
                    let datRef = JSON.parse(event.newValue);

                    console.warn("storage: IUM_CHECK_ACCESS_PING" + datRef);
                    if (self.theLastUserName === datRef.username && datRef.enabled) {
                        doRetry();
                        window.removeEventListener('storage', onStorageEvent);
                    }
                }
            }
            window.addEventListener('storage', onStorageEvent);

        }


    }

    let callRetry=function(){
        clearInterval(theTimer);
        doRetryOrStop();
    }

    let callDisabledOrLogout=function(force){
        clearInterval(theTimer);
        let dateRef={username:self.theLastUserName, timestamp:Date.now(),force:force};
        window.localStorage.setItem(IUM_CHECK_SLOT_LOGOUT,JSON.stringify(dateRef));
        doDisabled(!!datRef.force);
        console.log("ACCXIA IUM: User has been logged out");
    }

    this.ajaxGetCall = function(url) {
        jQuery.ajax({
            url : url,
            dataType : 'json',
            contentType: "application/json; charset=utf-8",
            async : true,
            success : function(data) {
                doProcessData(data,true)

            },
            error :function (xhr, textStatus, errorThrown ) {
                if (xhr.status >= 400 || errorThrown ) {
                    // {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
                    if(xhr.status==401){
                        callDisabledOrLogout(true);
                        return;
                    }

                    callDisabledOrLogout();
                }
            }
        });
    };
};

AJS.$( document ).ready(function() {
    IUMCheck.startCheckWatcher();
});
