/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

public class IntervalToCronConverter {
    public static String convertIntervalToCron(long intervalMillis, String timeZone) {
        if (intervalMillis < 1000L) {
            throw new IllegalArgumentException("Interval must be at least 1000 milliseconds (1 second).");
        }
        long intervalSeconds = intervalMillis / 1000L;
        if (intervalSeconds < 60L) {
            return "*/" + intervalSeconds + " * * * * ?";
        }
        long intervalMinutes = intervalSeconds / 60L;
        if (intervalMinutes < 60L) {
            return "0 */" + intervalMinutes + " * * * ?";
        }
        long intervalHours = intervalMinutes / 60L;
        if (intervalHours < 24L) {
            return "0 0 */" + intervalHours + " * * ?";
        }
        long intervalDays = intervalHours / 24L;
        return "0 0 0 */" + intervalDays + " * ?";
    }
}

