/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtil.class);

    public static boolean addPermissionExemptionForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("cachePermissionExemption", User.class, Boolean.TYPE);
            Object obj = method.invoke(null, confluenceUser, Boolean.TRUE);
            LOG.info("cachePermissionExemption  " + confluenceUser.getName() + " TRUE");
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean getPermissionExemptionForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("hasPermissionExemption", User.class);
            Object obj = method.invoke(null, confluenceUser);
            LOG.info("hasPermissionExemption  " + confluenceUser.getName() + " value=" + obj);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean addPermissionForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("cacheCanUseConfluence", User.class, Boolean.TYPE);
            Object obj = method.invoke(null, confluenceUser, Boolean.TRUE);
            LOG.info("cacheCanUseConfluence  " + confluenceUser.getName() + " TRUE");
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean removePermissionForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("cacheCanUseConfluence", User.class, Boolean.TYPE);
            Object obj = method.invoke(null, confluenceUser, Boolean.TRUE);
            LOG.info("Obj " + obj);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean getPermissionForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("canUseConfluence", User.class);
            Object obj = method.invoke(null, confluenceUser);
            LOG.info("cacheCanUseConfluence  " + confluenceUser.getName() + " permission=" + obj);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Object addAccessStatusForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("cacheUserAccessStatus", User.class, AccessStatus.class);
            AccessStatus accessStatus = ReflectionUtil.createAccessStatus();
            Object obj = method.invoke(null, confluenceUser, accessStatus);
            LOG.info("cacheUserAccessStatus  " + confluenceUser.getName() + " status=" + accessStatus.toString());
            return obj;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean removeAccessStatusForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("cacheCanUseConfluence", User.class, Boolean.TYPE);
            Object obj = method.invoke(null, confluenceUser, Boolean.TRUE);
            LOG.info("Obj " + obj);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Object getAccessStatusForUser(ClassLoader classLoader, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("getUserAccessStatus", User.class);
            Object obj = method.invoke(null, confluenceUser);
            LOG.info("getUserAccessStatus  " + confluenceUser.getName() + " permission=" + obj);
            return obj;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean addSpacePermissionForUser(ClassLoader classLoader, String permission, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("cacheSpacePermission", User.class, String.class, Space.class, Boolean.TYPE);
            Object obj = method.invoke(null, confluenceUser, permission, null, true);
            LOG.info("cacheSpacePermission  " + confluenceUser.getName() + " add permission=" + permission);
            return true;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static Object getSpacePermissionForUser(ClassLoader classLoader, String permission, ConfluenceUser confluenceUser) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("hasSpacePermission", String.class, Space.class, User.class);
            Object obj = method.invoke(null, permission, null, confluenceUser);
            LOG.info("hasSpacePermission  " + confluenceUser.getName() + " permission=" + permission + " value=" + obj);
            return obj;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object getSpacePermissionForUser(ClassLoader classLoader, String permission, ConfluenceUser confluenceUser, Space space) {
        try {
            Class<?> clz = classLoader.loadClass("com.atlassian.confluence.internal.security.ThreadLocalPermissionsCacheInternal");
            Method method = clz.getDeclaredMethod("hasSpacePermission", String.class, Space.class, User.class);
            Object obj = method.invoke(null, permission, space, confluenceUser);
            LOG.info("hasSpacePermission  " + space + " user " + confluenceUser.getName() + " permission=" + permission + " value=" + obj);
            return obj;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object createNoCheckAnnotatedPermitChecker(ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass("com.atlassian.confluence.impl.security.access.NoCheckAnnotatedPermitChecker");
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            Object object = ctor.newInstance(new Object[0]);
            return object;
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static AccessStatus createAccessStatus() {
        AccessStatus accessStatus = new AccessStatus(){

            public boolean hasLicensedAccess() {
                LOG.info("AccessStatus call hasLicensedAccess ==> true");
                return true;
            }

            public boolean hasUnlicensedAuthenticatedAccess() {
                LOG.info("AccessStatus call hasUnlicensedAuthenticatedAccess ==> true");
                return true;
            }

            public boolean hasAnonymousAccess() {
                LOG.info("AccessStatus call hasAnonymousAccess ==> true");
                return true;
            }

            public boolean canUseConfluence() {
                LOG.info("AccessStatus call canUseConfluence ==> true");
                return true;
            }

            public String toString() {
                return "AccessStatus{  hasLicensedAccess " + this.hasLicensedAccess() + ", hasUnlicensedAuthenticatedAccess " + this.hasUnlicensedAuthenticatedAccess() + ", hasAnonymousAccess " + this.hasAnonymousAccess() + ", canUseConfluence " + this.canUseConfluence() + "} ";
            }
        };
        return accessStatus;
    }
}

