document.addEventListener("DOMContentLoaded", function () {

    AJS.$("#cron-expression").on('click', function (e) {
        e.preventDefault();
        AJS.$("#cron-input").val(AJS.$("#cron-expression").val())
        cron-input
        AJS.dialog2("#cron-dialog").show();
    });

    AJS.$("#edit-cron").on('click', function (e) {
        e.preventDefault();
        AJS.$("#cron-input").val(AJS.$("#cron-expression").val())
        AJS.dialog2("#cron-dialog").show();
    });

    AJS.$("#save-cron").on("click", function (e) {
        e.preventDefault();
        AJS.$("#cron-expression").val(AJS.$("#cron-input").val())
        AJS.dialog2("#cron-dialog").hide();
    });

    AJS.$("#cancel-cron").on("click", function (e) {
        e.preventDefault();
        AJS.dialog2("#cron-dialog").hide();
    });

    AJS.$("#cron-input").on("keyup", function (e) {
        e.preventDefault();
        callFutureSchedules(AJS.$('#cronPreview'));
    });

    let callFutureSchedules=function(resultDiv){
        let cronExpression=AJS.$("#cron-input").val()

        // Validate using server-side API
        fetch(AJS.contextPath() + '/admin/scheduledjobs/getFutureSchedules.action?cronExpression=' + encodeURIComponent(cronExpression), {
            contentType: "application/json; charset=utf-8",
            method: 'GET'
        })
            .then(response => response.json())
            .then(data => {

                var html;
                if (!data.error && data.futureSchedules) {
                    $('#save-cron').prop('disabled', false);

                    var prevDate = null;
                    var rows = '';
                    for (var i = 0; i < data.futureSchedules.length; i++) {
                        var date = data.futureSchedules[i].date;
                        var time = data.futureSchedules[i].time;
                        rows += AJS.template.load('future-schedules-row')
                            .fillHtml({
                                date: (date == prevDate) ? '&nbsp;' : date,
                                time: time
                            })
                            .toString();
                        prevDate = date;
                    }

                    html = AJS.template.load('future-schedules-table')
                        .fillHtml({ rows: rows })
                        .toString();

                } else {
                    // An error occurred
                    $('#save-cron').prop('disabled', true);
                    html = AJS.template.load('validation-error')
                        .fillHtml({ dataError: (data.reason && (' - ' + data.reason)) || '' })
                        .toString();
                }

                resultDiv.html(html);

            })
            .catch(error => console.error('Error:', error));
    };

    let saveButton = document.getElementById("save-cron");

    // Validate and save cron expression
    saveButton.addEventListener("click", function () {
        let cronExpression=AJS.$("#cron-input").val()
        // Update input field in the form
        document.getElementById("cron-expression").value = cronExpression;
        AJS.dialog2("#cron-dialog").hide();

    });
});
