/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.Group;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.servlet.filter.AccxiaRequestWrapper;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class IntelligentUserManagerComalaFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerComalaFilter.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerComalaFilter(UserAccessor userAccessor, IUMHelperService helperService) {
        this.userAccessor = userAccessor;
        this.helperService = helperService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ConfluenceUser user;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (LOG.isDebugEnabled()) {
            LOG.debug("IntelligentUserManagerComalaFilter doFilter requestURI =" + (httpRequest.getRequestURI() != null ? httpRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpRequest.getPathInfo() != null ? httpRequest.getPathInfo() : "N/A") + ", user=" + (httpRequest.getRemoteUser() != null ? httpRequest.getRemoteUser() : "N/A"));
        }
        if ((user = AuthenticatedUserThreadLocal.get()) == null) {
            chain.doFilter(request, response);
            return;
        }
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("/rest/cw")) {
            AccxiaRequestWrapper accxiaRequestWrapper = new AccxiaRequestWrapper(httpRequest);
            String body = accxiaRequestWrapper.getBody();
            JsonNode jsonNode = IntelligentUserManagerComalaFilter.toJSONValid(body);
            if (jsonNode != null) {
                ArrayList<String> usernames = new ArrayList<String>();
                if (jsonNode.has("assignees") && jsonNode.get("assignees").isArray()) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get("assignees");
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        JsonNode node = arrayNode.get(i);
                        if (!node.has("username")) continue;
                        usernames.add(node.get("username").asText());
                    }
                }
                HashMap<String, ConfluenceUser> mapOfEnabledUser = new HashMap<String, ConfluenceUser>();
                HashMap<String, List<Group>> mapOfEnabledGroup = new HashMap<String, List<Group>>();
                if (usernames.size() > 0) {
                    for (String username : usernames) {
                        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
                        if (!this.helperService.isUserInGroups(confluenceUser, DAO.getIUMGroupsDisabled())) continue;
                        List<Group> groups = this.helperService.forceEnableUserFromGroup(confluenceUser);
                        mapOfEnabledUser.put(confluenceUser.getName(), confluenceUser);
                        mapOfEnabledGroup.put(confluenceUser.getName(), groups);
                    }
                }
                chain.doFilter((ServletRequest)accxiaRequestWrapper, response);
                if (mapOfEnabledUser.size() > 0) {
                    for (String username : mapOfEnabledUser.keySet()) {
                        if (mapOfEnabledUser.get(username) == null || mapOfEnabledGroup.get(username) == null || ((List)mapOfEnabledGroup.get(username)).size() <= 0) continue;
                        this.helperService.forceDisableUserFromGroup(user, (List)mapOfEnabledGroup.get(username));
                    }
                }
                return;
            }
            chain.doFilter((ServletRequest)accxiaRequestWrapper, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public static JsonNode toJSONValid(String jsonInString) {
        if (StringUtils.isEmpty((CharSequence)jsonInString)) {
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(jsonInString);
        }
        catch (IOException ex) {
            LOG.error(" " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

