//Should be declarated as var to allow  main calling
let DARK_MODE_COLOR = '#ffffff';
let DARK_GRID_MODE_COLOR= '#8f8c8c';

let LIGHT_MODE_COLOR = '#000000';
let LIGHT_GRID_MODE_COLOR= '#E9E9E9';

var IUMCharts= {
    //IUMCharts.accxiaChart.destroy();IUMCharts.accxiaChart=null;IUMCharts.loadRevocationData()

    //Chart.register(ChartDataLabels);
    accxiaChart:null,
    initAccxiaChart :function(json) {
        //hidden fields
        const chartTitle = document.getElementById("chart-title");
        const chartFileName = document.getElementById("chart-file-name");
        if(chartTitle){
            chartTitle.value = json.chartLabel ||  'IUM for Confluence';
        }
        if(chartFileName){
            chartFileName.value = json.chartFileNameTitle ||  'confluence';
        }

        const days=json.days;
        const monthName=json.month;

        const dayList = Array.from({length: days}, (_, i) => (i + 1).toString().padStart(2, '0'));

        const ctx = document.getElementById('userChart').getContext('2d');

        //debugger
        if (!IUMCharts.accxiaChart) {
            let fontColor=LIGHT_MODE_COLOR;
            let gridColor =LIGHT_GRID_MODE_COLOR;
            if(document.documentElement.dataset && document.documentElement.dataset.colorMode) {
                const htmlClass = document.documentElement.dataset.colorMode;
                if (htmlClass.includes('dark')) {
                    fontColor =DARK_MODE_COLOR;
                } else {
                    fontColor = LIGHT_MODE_COLOR;
                }
            }

            IUMCharts.accxiaChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: dayList,
                    datasets: [{
                        label: 'Users',
                        data: Array(31).fill(0),
                        backgroundColor: 'rgba(75, 192, 192, 0.6)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        title: {
                            display: true,
                            text: (json.chartLabel ||  'User peak and Queue display'),
                            font: {size: 18},
                            color: fontColor
                        },
                        legend: {
                            position: 'top',
                            labels: {color: fontColor}
                        },
                        tooltip: {
                            callbacks: {
                                // Format the value displayed for each item
                                label: function(context) {
                                    let roundValue = Math.round(context.parsed.y - (context.dataset.deltaX ? context.dataset.deltaX : 0));

                                    if(context.dataset.dataX){
                                        const hour = context.dataset.dataX[context.dataIndex];
                                        return `${context.dataset.label}: ${roundValue.toFixed(0)} at ${hour}:00`;
                                    }

                                    // debugger
                                    // return `${context.dataset.label}: ${context.parsed.y-(context.dataset.deltaX ? context.dataset.deltaX : 0 )}`;

                                    return `${context.dataset.label}: ${roundValue.toFixed(0)}`;
                                }

                            },
                            mode: 'index',
                            intersect: false,
                        },
                        /*
                        zoom: {
                            zoom: {
                                wheel: {enabled: true,},
                                pinch: {enabled: true},
                                mode: 'x',
                            }
                        }
                        */
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {display: true,text: 'Users'},
                            ticks: {color: fontColor},
                            grid: { color: gridColor}
                        },
                        x: {
                            title: {display: true,text: monthName || 'May'},
                            ticks: {color: fontColor},
                            grid: { color: gridColor}
                        }
                    },
                    interaction: {
                        mode: 'nearest',
                        axis: 'x',
                        intersect: false
                    },
                    animation:false

                }
            });

            const observer = new MutationObserver(() => {
                // debugger;
                if(document.documentElement.dataset && document.documentElement.dataset.colorMode){
                    const htmlClass = document.documentElement.dataset.colorMode;
                    if (htmlClass.includes('dark')) {
                        IUMCharts.accxiaChart.options.plugins.legend.labels.color =DARK_MODE_COLOR;
                        IUMCharts.accxiaChart.options.plugins.title.color =DARK_MODE_COLOR;
                        IUMCharts.accxiaChart.options.scales.y.ticks.color =DARK_MODE_COLOR;
                        IUMCharts.accxiaChart.options.scales.x.ticks.color =DARK_MODE_COLOR;

                        IUMCharts.accxiaChart.options.scales.y.grid.color =DARK_GRID_MODE_COLOR;
                        IUMCharts.accxiaChart.options.scales.x.grid.color =DARK_GRID_MODE_COLOR;

                        IUMCharts.accxiaChart.update();

                    } else {
                        IUMCharts.accxiaChart.options.plugins.legend.labels.color =LIGHT_MODE_COLOR;
                        IUMCharts.accxiaChart.options.plugins.title.color =LIGHT_MODE_COLOR;
                        IUMCharts.accxiaChart.options.scales.y.ticks.color =LIGHT_MODE_COLOR;
                        IUMCharts.accxiaChart.options.scales.x.ticks.color =LIGHT_MODE_COLOR;

                        IUMCharts.accxiaChart.options.scales.y.grid.color =LIGHT_GRID_MODE_COLOR;
                        IUMCharts.accxiaChart.options.scales.x.grid.color =LIGHT_GRID_MODE_COLOR;
                        IUMCharts.accxiaChart.update();

                    }
                }

            });

            observer.observe(document.documentElement, { attributes: true, attributeFilter: ['data-color-mode'] });

        }else{
            IUMCharts.accxiaChart.options.plugins.title.text=json.chartLabel ||  'User peak and Queue display'
        }

        //debugger


    },

    loadUserPeaksData2 :async function() {
        let year = document.getElementById('year').value;
        let month = document.getElementById('month').value;
        let url = AJS.contextPath() + `/rest/IUM/latest/charts/userpeak?year=${year}&month=${month}`;

        // debugger
        const response = await fetch(url);
        const json = await response.json();

        if(!json){
            return
        }

        //hidden fields
        const chartTitle = document.getElementById("chart-title");
        const chartFileName = document.getElementById("chart-file-name");
        if(chartTitle){
            chartTitle.value = json.chartLabel ||  'IUM for Confluence';
        }
        if(chartFileName){
            chartFileName.value = json.chartFileNameTitle ||  'confluence';
        }

        const days=json.days;
        const monthName=json.month;
        IUMCharts.initAccxiaChart(json);

        // Update chart data
        // Transform json.data for Chart.js
        var ID = 0;
        const datasets=[];
        let deltaX = [0,0.2];
        let tensionX=[0,0.2];

        //datasets

        let mUserPeaksDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.userPeaks.forEach(userPeak => {
            mUserPeaksDays[userPeak.day-1] += userPeak.peakUsers;
        });

        datasets.push({
            label: json.userPeakLabel,
            data: mUserPeaksDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.backgroundColors[ID],
            borderColor:IUMColorCharts.backgroundColors[ID++],
            borderWidth: 2
        });

        let mUserBannerDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.userPeaks.forEach(userPeak => {
            mUserBannerDays[userPeak.day-1] += userPeak.peakBanned;
        });

        datasets.push({
            label: json.userBannerLabel,
            data: mUserBannerDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.backgroundColors[ID],
            borderColor:IUMColorCharts.backgroundColors[ID++],
            borderWidth: 2
        });


        IUMCharts.accxiaChart.data.datasets=datasets;

        IUMCharts.accxiaChart.update();
    },

    loadUserPeaksData :async function() {
        let year = document.getElementById('year').value;
        let month = document.getElementById('month').value;
        let url = AJS.contextPath() + `/rest/IUM/latest/charts/userpeak2?year=${year}&month=${month}`;

        // debugger
        const response = await fetch(url);
        const json = await response.json();

        if(!json){
            return
        }

        //hidden fields
        const chartTitle = document.getElementById("chart-title");
        const chartFileName = document.getElementById("chart-file-name");
        if(chartTitle){
            chartTitle.value = json.chartLabel ||  'IUM for Confluence';
        }
        if(chartFileName){
            chartFileName.value = json.chartFileNameTitle ||  'confluence';
        }

        const days=json.days;
        IUMCharts.initAccxiaChart(json);

        // Update chart data
        // Transform json.data for Chart.js
        var ID = 0;
        const datasets=[];
        let deltaX = [0,0.2];
        let tensionX=[0,0.2];

        //datasets

        let mUserPeaksDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        let mUserPeaksHour = Array.from({length:days}, (_, i) =>  0);
        json.userPeaks.forEach(userPeak => {
            mUserPeaksDays[userPeak.day-1] += userPeak.peakUsers;
            mUserPeaksHour[userPeak.day-1] = userPeak.hour;
        });

        datasets.push({
            label: json.userPeakLabel,
            data: mUserPeaksDays,
            dataX: mUserPeaksHour,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.backgroundColors[ID],
            borderColor:IUMColorCharts.backgroundColors[ID++],
            borderWidth: 2
        });

        let mUserBannerDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        let mUserBannerHour = Array.from({length:days}, (_, i) =>  0);
        json.userPeaks.forEach(userPeak => {
            mUserBannerDays[userPeak.day-1] += userPeak.peakBanned;
            mUserBannerHour[userPeak.day-1] = userPeak.hour;
        });

        datasets.push({
            label: json.userBannerLabel,
            data: mUserBannerDays,
            dataX: mUserBannerHour,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.backgroundColors[ID],
            borderColor:IUMColorCharts.backgroundColors[ID++],
            borderWidth: 2
        });


        IUMCharts.accxiaChart.data.datasets=datasets;

        IUMCharts.accxiaChart.update();
    },


    loadLicensesTierData :async function() {
        let year = document.getElementById('year').value;
        let month = document.getElementById('month').value;
        let url = AJS.contextPath() + `/rest/IUM/latest/charts/licenses?year=${year}&month=${month}`;


        // debugger
        const response = await fetch(url);
        const json = await response.json();

        if(!json){
            return
        }

        const days=json.days;
        IUMCharts.initAccxiaChart(json);

        // Update chart data
        // Transform json.data for Chart.js
        var ID = 0;
        const datasets=[];
        let deltaX = [0,0,0.1,0.2,0.3,0.1];
        let tensionX=[0.2,0,0.2,0,0.2,0.1];

        //datasets

        //1. total users = user fixed (confluence) license + user IUM license
        let mTotalUsersDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.licenseTiers.forEach(licenseTier => {
            mTotalUsersDays[licenseTier.dayAsInt-1] += licenseTier.iumUserTier+licenseTier.confluenceUserTier;
        });

        datasets.push({
            label: json.iumTotalUsersLabel,
            data: mTotalUsersDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.licBackgroundColors[ID],
            borderColor:IUMColorCharts.licBackgroundColors[ID++],
            borderWidth: 2
        });

        //2. Users with IUM license
        let mIUMUserTierDays = Array.from({length:days}, (_, i)=>  deltaX[ID]);
        json.licenseTiers.forEach(licenseTier => {
            mIUMUserTierDays[licenseTier.dayAsInt-1] += licenseTier.iumUserTier;
        });

        datasets.push({
            label: json.iumUserTierLabel,
            data: mIUMUserTierDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.licBackgroundColors[ID],
            borderColor:IUMColorCharts.licBackgroundColors[ID++],
            borderWidth: 2
        });

        //3. Users with fix license (without ium_enable/ium_disable)
        let mConfluenceUserTierDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.licenseTiers.forEach(licenseTier => {
            mConfluenceUserTierDays[licenseTier.dayAsInt-1] += licenseTier.confluenceUserTier;
        });

        datasets.push({
            label: json.confluenceUserTierLabel,
            data: mConfluenceUserTierDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.licBackgroundColors[ID],
            borderColor:IUMColorCharts.licBackgroundColors[ID++],
            borderWidth: 2
        });

        //4. Confluence license tier
        let mConfluenceLicenseTierDays = Array.from({length:days}, (_, i)=>  deltaX[ID]);
        json.licenseTiers.forEach(licenseTier => {
            mConfluenceLicenseTierDays[licenseTier.dayAsInt-1] += licenseTier.confluenceLicenseTier;
        });

        datasets.push({
            label: json.confluenceLicenseTierLabel,
            data: mConfluenceLicenseTierDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.licBackgroundColors[ID],
            borderColor:IUMColorCharts.licBackgroundColors[ID++],
            borderWidth: 2
        });

        //5. IUM Shared license
        let mIUMLicenseTierDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.licenseTiers.forEach(licenseTier => {
            mIUMLicenseTierDays[licenseTier.dayAsInt-1] += licenseTier.iumLicenseTier;
        });

        datasets.push({
            label: json.iumLicenseTierLabel,
            data: mIUMLicenseTierDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.licBackgroundColors[ID],
            borderColor:IUMColorCharts.licBackgroundColors[ID++],
            borderWidth: 2
        });

        // user peaks
        let mUserPeaksDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.userPeaks.forEach(userPeak => {
            mUserPeaksDays[userPeak.day-1] += userPeak.peakUsers;
        });

        datasets.push({
            label: json.userPeakLabel,
            data: mUserPeaksDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.licBackgroundColors[ID],
            borderColor:IUMColorCharts.licBackgroundColors[ID++],
            borderWidth: 2
        });




        IUMCharts.accxiaChart.data.datasets=datasets;

        IUMCharts.accxiaChart.update();
    },

    loadRevocationData :async function() {
        let year = document.getElementById('year').value;
        let month = document.getElementById('month').value;
        let url = AJS.contextPath() + `/rest/IUM/latest/charts/revocation?year=${year}&month=${month}`;

        // debugger
        const response = await fetch(url);
        const json = await response.json();

        if(!json){
            return
        }

        const days=json.days;
        IUMCharts.initAccxiaChart(json);

        // Update chart data
        // Transform json.data for Chart.js
        var ID = 0;
        const datasets=[];
        let deltaX = [0,0,0.1,0.2,0.1,0.3];
        let tensionX=[0,0,0.1,0.2,0,0.2];

        //datasets

        //1. Licenses assigned by IUM
        let mIUMLicenseLabelDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.counterActions.forEach(counterAction => {
            mIUMLicenseLabelDays[counterAction.dayAsInt-1] += counterAction.iumLicenseCount;
        });

        datasets.push({
            label: json.iumLicenseLabel,
            data: mIUMLicenseLabelDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.revBackgroundColors[ID],
            borderColor:IUMColorCharts.revBackgroundColors[ID++],
            borderWidth: 2
        });

        //2. Total Number of users removed by IUM = licenseRequestCount + autoRemovalUserCount + groupRemovalUserCount
        let mTotalUsersRemovedDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.counterActions.forEach(counterAction => {
            mTotalUsersRemovedDays[counterAction.dayAsInt-1] += counterAction.licenseRequestCount + counterAction.autoRemovalUserCount + counterAction.groupRemovalUserCount + counterAction.logoutUserCount;
        });

        datasets.push({
            label: json.totalUsersRemovedLabel,
            data: mTotalUsersRemovedDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.revBackgroundColors[ID],
            borderColor:IUMColorCharts.revBackgroundColors[ID++],
            borderWidth: 2
        });


        //3. by IUM user logout
        let mTotalUsersLogoutDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.counterActions.forEach(counterAction => {
            mTotalUsersLogoutDays[counterAction.dayAsInt-1] += counterAction.logoutUserCount;
        });

        datasets.push({
            label: json.logoutUserLabel,
            data: mTotalUsersLogoutDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.revBackgroundColors[ID],
            borderColor:IUMColorCharts.revBackgroundColors[ID++],
            borderWidth: 2
        });


        //4. by another IUM user
        let mLicenseRequestDays = Array.from({length:days}, (_, i) =>  deltaX[ID]);
        json.counterActions.forEach(counterAction => {
            mLicenseRequestDays[counterAction.dayAsInt-1] += counterAction.licenseRequestCount;
        });

        datasets.push({
            label: json.licenseRequestLabel,
            data: mLicenseRequestDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.revBackgroundColors[ID],
            borderColor:IUMColorCharts.revBackgroundColors[ID++],
            borderWidth: 2
        });

        //5. by auto removal
        let mAutoRemovalDays = Array.from({length:days}, (_, i)  =>  deltaX[ID]);
        json.counterActions.forEach(counterAction => {
            mAutoRemovalDays[counterAction.dayAsInt-1] += counterAction.autoRemovalUserCount;
        });

        datasets.push({
            label: json.autoRemovalUserLabel,
            data: mAutoRemovalDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.revBackgroundColors[ID],
            borderColor:IUMColorCharts.revBackgroundColors[ID++],
            borderWidth: 2
        });

        //6. by group level removal
        let mGroupRemovalUserDays = Array.from({length:days}, (_, i)  =>  deltaX[ID]);
        json.counterActions.forEach(counterAction => {
            mGroupRemovalUserDays[counterAction.dayAsInt-1] += counterAction.groupRemovalUserCount;
        });

        datasets.push({
            label: json.groupRemovalUserLabel,
            data: mGroupRemovalUserDays,
            deltaX:deltaX[ID],
            tension:tensionX[ID],
            backgroundColor:IUMColorCharts.revBackgroundColors[ID],
            borderColor:IUMColorCharts.revBackgroundColors[ID++],
            borderWidth: 2
        });


        IUMCharts.accxiaChart.data.datasets=datasets;

        IUMCharts.accxiaChart.update();
    },


    downloadPDF: async function() {
        const { jsPDF } = window.jspdf;
        const pdf = new jsPDF({
            orientation: 'landscape',
            unit: 'pt',
            format: 'a4'
        });

        let fontColor=LIGHT_MODE_COLOR;
        let gridColor =LIGHT_GRID_MODE_COLOR;
        if(document.documentElement.dataset && document.documentElement.dataset.colorMode) {
            const htmlClass = document.documentElement.dataset.colorMode;
            if (htmlClass.includes('dark')) {
                IUMCharts.accxiaChart.options.plugins.legend.labels.color =fontColor;
                IUMCharts.accxiaChart.options.plugins.title.color =fontColor;
                IUMCharts.accxiaChart.options.scales.y.ticks.color =fontColor;
                IUMCharts.accxiaChart.options.scales.x.ticks.color =fontColor;
                IUMCharts.accxiaChart.options.scales.y.grid.color =gridColor;
                IUMCharts.accxiaChart.options.scales.x.grid.color =gridColor;


                IUMCharts.accxiaChart.options.plugins.backgroundPlugin = {
                    id: 'backgroundPlugin',
                    beforeDraw: (chart) => {
                        const ctx = chart.ctx;
                        ctx.save();
                        ctx.fillStyle = fontColor;
                        ctx.fillRect(0, 0, chart.width, chart.height);
                        ctx.restore();
                    }
                };
                // debugger
                IUMCharts.accxiaChart.update();
                await new Promise(resolve => setTimeout(resolve, 100));
                IUMCharts.accxiaChart.options.plugins.backgroundPlugin=null; // Remove the plugin after use
            }

        }


        const pageWidth = pdf.internal.pageSize.getWidth();
        const pageHeight = pdf.internal.pageSize.getHeight();

        const title = document.getElementById("chart-title")?.value;
        const fileName =  document.getElementById("chart-file-name")?.value;



        // Set font and size
        pdf.setFontSize(24);
        pdf.setFont('helvetica', 'bold');

        // Center title horizontally
        const titleWidth = pdf.getTextWidth(title);
        const tx = (pageWidth - titleWidth) / 2;
        const ty = 40;

        pdf.text(title, tx, ty);

        const canvas = document.getElementById('userChart');
        const imageData = canvas.toDataURL('image/png', 1.0);

        // Add chart image
        // Maintain aspect ratio
        const imgProps = {
            width: canvas.width,
            height: canvas.height
        };
        const ratio = imgProps.height / imgProps.width;
        const imgWidth = pageWidth;
        const imgHeight = imgWidth * ratio;

        // Center vertically (optional)
        const y = (pageHeight - imgHeight) / 2;

        pdf.addImage(imageData, 'PNG', 0, y, imgWidth, imgHeight);

        const imageY = 20;
        const finalY = imageY + imgHeight + 30; // Position after image

        // Add custom text at the end
        // const customText = `${lightLegend}   ||   ${darkLegend}`;
        // pdf.setFontSize(12);
        // pdf.setTextColor(150);
        // pdf.text(customText, 20, pageHeight - 20); // Stay within page

        /*
        // Add watermark (diagonal, semi-transparent)
        pdf.setTextColor(150, 150, 150); // light gray
        pdf.setFontSize(40);
        pdf.setFont("helvetica", "bold");
        pdf.setTextColor(150, 150, 150, 0.2); // optional transparency in RGB format (opacity simulated)

        // Rotate and place watermark text
        pdf.saveGraphicsState();
        pdf.setGState(new pdf.GState({ opacity: 0.1 }));
        pdf.text("IUM analyzer for Accxia ", 150, 450, { angle: 45 });
        pdf.restoreGraphicsState();
        */

        // Save file
        pdf.save(`${fileName}.pdf`);


        if(document.documentElement.dataset && document.documentElement.dataset.colorMode) {
            const htmlClass = document.documentElement.dataset.colorMode;
            if (htmlClass.includes('dark')) {
                fontColor=DARK_MODE_COLOR;
                gridColor =DARK_GRID_MODE_COLOR;

                IUMCharts.accxiaChart.options.plugins.legend.labels.color =fontColor;
                IUMCharts.accxiaChart.options.plugins.title.color =fontColor;
                IUMCharts.accxiaChart.options.scales.y.ticks.color =fontColor;
                IUMCharts.accxiaChart.options.scales.x.ticks.color =fontColor;
                IUMCharts.accxiaChart.options.scales.y.grid.color =gridColor;
                IUMCharts.accxiaChart.options.scales.x.grid.color =gridColor;

                IUMCharts.accxiaChart.update();

                await new Promise(resolve => setTimeout(resolve, 100));
            }

        }

    },

    refreshData: function () {
        IUMCharts.loadUserPeaksData();
     },


    updateAuditStatusCall : function() {
        let url = AJS.contextPath() + `/rest/IUM/latest/charts/auditstatus`;
        let elem = document.getElementById('auditStatus');
        let auditStatus= elem && elem.checked ? true : false;


        jQuery.ajax({
            url : url,
            method: "POST",
            dataType : "json",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify({auditStatus: auditStatus}),
            async : true,
            success : function(data) {
                // {"auditRequest":true} OR  {"auditRequest":false}
                AJS.flag({
                    type: 'success',
                    title:'Intelligent User Manager (IUM)',
                    body:'Audit Status: ' + ((data && data.auditRequest) ? "On" : "Off"),
                    close:"auto"
                });

               // doProcessData(data,true)
            },
            error :function (xhr, ajaxOptions, thrownError) {
                if (xhr.status >= 400 || errorThrown ) {
                    // {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
                    return;
                }
            }
        });
    },

    deleteAuditData : function() {
        let url = AJS.contextPath() + `/rest/IUM/latest/charts/dropaudit`;
        let elem = document.getElementById('auditStatus');
        let auditStatus= elem && elem.checked ? true : false;


        jQuery.ajax({
            url : url,
            method: "POST",
            dataType : "json",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify({auditStatus: auditStatus}),
            async : true,
            success : function(data) {
                // {"drop":true}

                AJS.flag({
                    type: 'success',
                    title:'Intelligent User Manager (IUM)',
                    body:'Deleted :' + ((data && data.drop) ? "Successful" : "Fail"),
                    close:"auto"
                });

                // doProcessData(data,true)
            },
            error :function (xhr, ajaxOptions, thrownError) {
                if (xhr.status >= 400 || errorThrown ) {
                    // {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
                    AJS.flag({
                        type: 'error',
                        title:'Intelligent User Manager (IUM)',
                        body:'Error raised on delete'
                    });

                    return;
                }
            }
        });
    }
}