/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.analytical;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.ium.analytical.CounterActionDTO;
import de.accxia.apps.confluence.ium.analytical.CounterActionEvent;
import de.accxia.apps.confluence.ium.analytical.CounterActionRepository;
import de.accxia.apps.confluence.ium.analytical.LicenseTierDTO;
import de.accxia.apps.confluence.ium.analytical.LicenseTierRepository;
import de.accxia.apps.confluence.ium.analytical.PermissionMarkerType;
import de.accxia.apps.confluence.ium.analytical.UserActionEvent;
import de.accxia.apps.confluence.ium.analytical.UserActivity;
import de.accxia.apps.confluence.ium.analytical.UserAnalyticalDTO;
import de.accxia.apps.confluence.ium.analytical.UserAnalyticalRepository;
import de.accxia.apps.confluence.ium.analytical.UserReference;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.util.DateUtil;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class LicenseAnalyticalService
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseAnalyticalService.class);
    private static final long INITIAL_DELAY = 1L;
    private static final long PERIOD = 5L;
    private final ReentrantLock lock1 = new ReentrantLock();
    private final ReentrantLock lock2 = new ReentrantLock();
    private final ReentrantLock lock3 = new ReentrantLock();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture scheduledLicenseFuture = null;
    private ScheduledFuture scheduledUserFuture = null;
    private ScheduledFuture scheduledTierFuture = null;
    private CounterActionDTO counterAction;
    private LicenseTierDTO licenseTier;
    private ConcurrentHashMap<UserReference, UserActivity> userActionMap = null;
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final LicenseService licenseService;
    private final IUMHelperService iumHelperService;
    private final CounterActionRepository counterActionRepository;
    private final UserAnalyticalRepository userAnalyticalRepository;
    private final LicenseTierRepository licenseTierRepository;

    @Inject
    public LicenseAnalyticalService(EventPublisher eventPublisher, UserAccessor userAccessor, LicenseService licenseService, IUMHelperService iumHelperService, CounterActionRepository counterActionRepository, UserAnalyticalRepository userAnalyticalRepository, LicenseTierRepository licenseTierRepository) {
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.licenseService = licenseService;
        this.iumHelperService = iumHelperService;
        this.counterActionRepository = counterActionRepository;
        this.userAnalyticalRepository = userAnalyticalRepository;
        this.licenseTierRepository = licenseTierRepository;
        this.startScheduledFlush();
    }

    public void publishEvent(CounterActionEvent event) {
        this.eventPublisher.publish((Object)event);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.userActionMap = null;
        this.counterAction = null;
        this.licenseTier = null;
        this.shutdownScheduled();
    }

    private void shutdownScheduled() {
        try {
            if (this.scheduledLicenseFuture != null) {
                LOG.info("LicenseAnalytical scheduledLicenseFuture canceled");
                this.scheduledLicenseFuture.cancel(true);
            }
            LOG.info("LicenseAnalytical scheduledLicenseFuture shutdown");
            if (this.scheduledUserFuture != null) {
                LOG.info("UserAnalytical scheduledUserFuture canceled");
                this.scheduledUserFuture.cancel(true);
            }
            LOG.info("LicenseAnalytical scheduledUserFuture shutdown");
            if (this.scheduledTierFuture != null) {
                LOG.info("UserAnalytical scheduledTierFuture canceled");
                this.scheduledTierFuture.cancel(true);
            }
            LOG.info("UserAnalytical scheduledTierFuture shutdown");
            this.scheduler.shutdown();
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.info("LicenseAnalytical/UserAnalytical/TierFuture scheduledFuture shutdownNow");
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.error("Exception while shutting down LicenseAnalytical/UserAnalytical scheduledFuture: {}", (Object)e.getMessage(), (Object)e);
            this.scheduler.shutdownNow();
        }
    }

    @EventListener
    public void onIssueEvent(CounterActionEvent event) {
        this.processAnalyticalEvent(event);
    }

    @EventListener
    public void onIssueEvent(UserActionEvent event) {
        this.processAsyncUserEvent(event);
    }

    private void startScheduledFlush() {
        this.scheduledLicenseFuture = this.scheduler.scheduleAtFixedRate(this::flushCounterActionToDatabase, 1L, 5L, TimeUnit.MINUTES);
        this.scheduledUserFuture = this.scheduler.scheduleAtFixedRate(this::flushUserActionToDatabase, 1L, 10L, TimeUnit.MINUTES);
        this.scheduledTierFuture = this.scheduler.scheduleAtFixedRate(this::flushTierAnalyticalToDatabase, 1L, 10L, TimeUnit.MINUTES);
    }

    private void flushCounterActionToDatabase() {
        if (!this.scheduledLicenseFuture.isCancelled()) {
            this.lock1.lock();
            try {
                LOG.info("Lock aquired");
                LOG.info("Flushing CounterAction to database");
                CounterActionDTO analytical = this.counterActionRepository.saveOrUpdate(this.getCounterAction());
                LOG.info("Saved  CounterAction with ID: {} and day {}", (Object)analytical.getID(), (Object)analytical.getDay());
                this.counterAction = new CounterActionDTO(DateUtil.getDate());
            }
            catch (Exception e) {
                LOG.error("Error while saving CounterAction: {}", (Object)e.getMessage(), (Object)e);
                this.counterAction = new CounterActionDTO(DateUtil.getDate());
            }
            finally {
                this.lock1.unlock();
                LOG.info("Lock released");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushUserActionToDatabase() {
        if (!this.scheduledUserFuture.isCancelled()) {
            List confluenceAccess = this.userAccessor.getUserNamesWithConfluenceAccess();
            List<String> iumAccess = this.iumHelperService.getDisabledUsers();
            this.lock2.lock();
            try {
                LOG.info("Lock aquired");
                LOG.info("Flushing UserAnalytical to database");
                ArrayList<UserAnalyticalDTO> userAnalyticalList = new ArrayList<UserAnalyticalDTO>();
                this.getUserActionMap().forEach((key, value) -> userAnalyticalList.add(new UserAnalyticalDTO((UserReference)key, (UserActivity)value)));
                this.userActionMap = new ConcurrentHashMap();
                for (UserAnalyticalDTO ua : userAnalyticalList) {
                    if (iumAccess.contains(ua.getUsername())) {
                        ua.setPermIum(PermissionMarkerType.PERMISSION_ALLOW);
                    } else {
                        ua.setPermIum(PermissionMarkerType.PERMISSION_NONE);
                    }
                    if (confluenceAccess.contains(ua.getUsername())) {
                        ua.setPermConfluence(PermissionMarkerType.PERMISSION_ALLOW);
                        continue;
                    }
                    ua.setPermConfluence(PermissionMarkerType.PERMISSION_NONE);
                }
                this.userAnalyticalRepository.saveOrUpdateBatch(userAnalyticalList);
            }
            catch (Exception e) {
                LOG.error("Error while saving UserAnalytical: {}", (Object)e.getMessage(), (Object)e);
                this.userActionMap = new ConcurrentHashMap();
            }
            finally {
                this.lock2.unlock();
                LOG.info("Lock released");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushTierAnalyticalToDatabase() {
        if (!this.scheduledLicenseFuture.isCancelled()) {
            this.lock3.lock();
            try {
                LOG.info("Lock aquired");
                LOG.info("Flushing TierAnalytical to database");
                this.licenseTier = new LicenseTierDTO(DateUtil.getDate());
                String queueSize = DAO.getQueueSize();
                if (!StringUtils.isEmpty((CharSequence)queueSize)) {
                    this.licenseTier.setIumLicenseTier(Arrays.stream(queueSize.split(",")).map(qs -> ParseUtil.safeParseInt(qs)).reduce(0, Integer::sum));
                } else {
                    this.licenseTier.setIumLicenseTier(0);
                }
                ConfluenceLicense confluenceLicense = this.licenseService.retrieve();
                this.licenseTier.setConfluenceLicenseTier(confluenceLicense.getMaximumNumberOfUsers());
                this.licenseTier.setConfluenceUserTier(this.iumHelperService.getUserNamesWithConfluenceAccessOtherIUM().size());
                this.licenseTier.setIumUserTier(this.iumHelperService.getDisabledUsers().size());
                LicenseTierDTO analytical = this.licenseTierRepository.saveOrUpdate(this.licenseTier);
                LOG.info("Saved  GlobalLicense with ID: {} and day {}", (Object)analytical.getID(), (Object)analytical.getDay());
            }
            catch (Exception e) {
                LOG.error("Error while saving GlobalLicense: {}", (Object)e.getMessage(), (Object)e);
                this.licenseTier = new LicenseTierDTO(DateUtil.getDate());
            }
            finally {
                this.lock3.unlock();
                LOG.info("Lock released");
            }
        }
    }

    private void processAsyncUserEvent(UserActionEvent event) {
        LOG.info("Processing user event: {}", (Object)event.getUser().getName());
        UserReference userReference = new UserReference(event.getUser().getName());
        this.getUserActionMap();
        UserActivity userActivity = this.userActionMap.containsKey(userReference) ? this.userActionMap.get(userReference) : new UserActivity();
        switch (event.getEventType()) {
            case USER_ACTION: {
                userActivity.incAction();
                break;
            }
            case USER_SLOT_REVOKED: {
                userActivity.incBanned();
                break;
            }
            case USER_SLOT_GRANTED: {
                userActivity.incActivated();
                break;
            }
            case USER_JOB_REVOKED: {
                userActivity.incJobBanned();
            }
        }
        this.userActionMap.put(userReference, userActivity);
    }

    public void processAnalyticalEvent(CounterActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing event: {} on thread# {}", (Object)event, (Object)Thread.currentThread().getName());
        }
        switch (event.getEventType()) {
            case ANALYTICAL_EVENT_APP: {
                this.incrementAppTier();
                break;
            }
            case ANALYTICAL_EVENT_IUM: {
                this.incrementIumTier();
                break;
            }
            case ANALYTICAL_EVENT_LOGOUT: {
                this.incrementLogoutUserCount();
                break;
            }
            case ANALYTICAL_EVENT_INACTIVE: {
                this.incrementInactiveUserCount();
                break;
            }
            case ANALYTICAL_EVENT_LICENSE_REQ: {
                this.incrementLicenseReq();
                break;
            }
            case ANALYTICAL_EVENT_REDUCED_EXCEED: {
                this.reducedExceedCount(event.getQuantity());
                break;
            }
            case ANALYTICAL_EVENT_AUTO_REMOVAL: {
                this.incrementAutoRemovalUserCount();
                break;
            }
            case ANALYTICAL_EVENT_GROUP_REMOVAL: {
                this.incrementGroupRemovalUserCount();
                break;
            }
            default: {
                LOG.warn("Unknown event type: {}", (Object)event.getEventType());
            }
        }
    }

    private void incrementAppTier() {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setAppUserCount(lCounter.getAppUserCount() + 1);
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementIumTier() {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setIumLicenseCount(lCounter.getIumLicenseCount() + 1);
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementLogoutUserCount() {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setLogoutUserCount(lCounter.getLogoutUserCount() + 1);
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementInactiveUserCount() {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setInactiveUserCount(lCounter.getInactiveUserCount() + 1);
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementLicenseReq() {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setLicenseRequestCount(lCounter.getLicenseRequestCount() + 1);
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void reducedExceedCount(int quantity) {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setReducedExceedCount(lCounter.getReducedExceedCount() + (quantity > 0 ? quantity : 1));
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementAutoRemovalUserCount() {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setAutoRemovalUserCount(lCounter.getAutoRemovalUserCount() + 1);
        }
        finally {
            this.lock1.unlock();
        }
    }

    private void incrementGroupRemovalUserCount() {
        this.lock1.lock();
        try {
            CounterActionDTO lCounter = this.getCounterAction();
            lCounter.setGroupRemovalUserCount(lCounter.getGroupRemovalUserCount() + 1);
        }
        finally {
            this.lock1.unlock();
        }
    }

    public CounterActionDTO getCounterAction() {
        if (this.counterAction == null) {
            this.counterAction = new CounterActionDTO(DateUtil.getDate());
        }
        return this.counterAction;
    }

    public ConcurrentHashMap<UserReference, UserActivity> getUserActionMap() {
        if (this.userActionMap == null) {
            this.userActionMap = new ConcurrentHashMap();
        }
        return this.userActionMap;
    }

    public LicenseTierDTO getLicenseTier() {
        if (this.licenseTier == null) {
            this.licenseTier = new LicenseTierDTO(DateUtil.getDate());
        }
        return this.licenseTier;
    }

    public void savedToDatabase(List<UserAnalyticalDTO> userAnalyticalList) {
        if (userAnalyticalList == null || userAnalyticalList.isEmpty()) {
            return;
        }
        this.userAnalyticalRepository.saveOrUpdateBatch(userAnalyticalList);
    }

    public CounterActionDTO getCounterActionByDay(Date date) {
        CounterActionDTO action = CounterActionDTO.fromAO(this.counterActionRepository.getByDay(date));
        return action;
    }

    public LicenseTierDTO getLicenseTierByDay(Date date) {
        LicenseTierDTO action = LicenseTierDTO.fromAO(this.licenseTierRepository.getByDay(date));
        return action;
    }

    public List<UserAnalyticalDTO> getUserAnalyticalByDay(Date date) {
        List<UserAnalyticalDTO> action = this.userAnalyticalRepository.getByDay(date);
        return action;
    }

    public List<CounterActionDTO> getCounterActionByInterval(Date startDate, Date endDate) {
        List<CounterActionDTO> actions = CounterActionDTO.fromAOs(this.counterActionRepository.getByPeriod(startDate, endDate));
        if (actions != null && !actions.isEmpty()) {
            for (CounterActionDTO action : actions) {
                int diff = action.getLicenseRequestCount() - action.getLogoutUserCount();
                action.setLicenseRequestCount(Math.max(diff, 0));
            }
        }
        return actions;
    }

    public List<LicenseTierDTO> getLicenseTierByInterval(Date startDate, Date endDate) {
        List<LicenseTierDTO> action = LicenseTierDTO.fromAOs(this.licenseTierRepository.getByPeriod(startDate, endDate));
        return action;
    }

    public Map<String, List<UserAnalyticalDTO>> getUserAnalyticalByInterval(Date startDate, Date endDate) {
        List<UserAnalyticalDTO> actions = UserAnalyticalDTO.fromAOs(this.userAnalyticalRepository.getByPeriod(startDate, endDate));
        Map<String, List<UserAnalyticalDTO>> result = actions.stream().collect(Collectors.groupingBy(UserAnalyticalDTO::getActionDateAsYYYYMMDD));
        return result;
    }

    public boolean dropAuditData() {
        int rec1 = this.userAnalyticalRepository.deleteAll();
        int rec2 = this.licenseTierRepository.deleteAll();
        int rec3 = this.counterActionRepository.deleteAll();
        return rec1 != -1 && rec2 != -1 && rec3 != -1;
    }

    public void testFlushDatabase() {
        this.flushCounterActionToDatabase();
        this.flushUserActionToDatabase();
        this.flushTierAnalyticalToDatabase();
    }
}

