/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.ium.cache.AbstractCachedManager;
import de.accxia.apps.confluence.ium.cache.PropertyCachedManager;
import de.accxia.apps.confluence.ium.cache.UserCacheEntryAdapter;
import de.accxia.apps.confluence.ium.config.DAO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@Named(value="UserCachedManager")
public class UserCachedManager
extends AbstractCachedManager<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCachedManager.class);
    private Cache<String, Long> cache = null;
    private UserCacheEntryAdapter<Long> userCacheEntryAdapter;

    @Inject
    public UserCachedManager(@Qualifier(value="UserCacheEntryAdapter") UserCacheEntryAdapter<Long> userCacheEntryAdapter, @ComponentImport ClusterManager clusterManager, @ComponentImport CacheManager cacheManager, @ComponentImport ApplicationContext applicationContext) {
        super(userCacheEntryAdapter, clusterManager, cacheManager, applicationContext);
        this.userCacheEntryAdapter = userCacheEntryAdapter;
    }

    @Override
    protected void doInit(CacheEntryListener<String, Long> cacheEntryListener) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Call PropertyCachedManager doInit ");
        }
        this.cache = this.getCacheManager().getCache(DAO.class.getName() + ".user2.cache", null, new CacheSettingsBuilder().remote().maxEntries(1000).unflushable().replicateAsynchronously().replicateViaCopy().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cache.addListener(this.getCacheEntryListener(), true);
    }

    @Override
    public void cleanup() {
        this.cache.removeListener(this.userCacheEntryAdapter);
    }

    public Long getKeyValue(String key) {
        if (this.getCache() == null) {
            LOG.info("GET Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            return null;
        }
        Long value = (Long)this.cache.get((Object)key);
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET Cache[" + this.cache.getName() + "],Node[" + this.getClusterName() + "] key=" + key + " value=" + (Serializable)(value != null ? value : "N/A"));
        }
        return value;
    }

    public Long setKeyValue(String key, Long value) {
        if (this.getCache() == null) {
            LOG.info("SET Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT Cache[" + this.cache.getName() + "],Node[" + this.getClusterName() + "] key=" + key + " value=" + value);
        }
        this.cache.put((Object)key, (Object)value);
        return (Long)this.cache.get((Object)key);
    }

    public void deleteKey(String key) {
        if (this.getCache() == null) {
            LOG.info("DELETE Cache=NULL[" + this.getClusterName() + "] for key=" + key);
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("DELETE Cache[" + this.cache.getName() + "][" + this.getClusterName() + "] key=" + key);
        }
        this.cache.remove((Object)key);
    }

    public Map<String, Long> getValues() {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        if (this.getCache() == null) {
            LOG.info("GET Cache=NULL[" + this.getClusterName() + "]");
            return retVal;
        }
        for (String key : this.cache.getKeys()) {
            Long cacheValue = (Long)this.cache.get((Object)key);
            if (LOG.isTraceEnabled()) {
                LOG.info("GET Cache[" + this.cache.getName() + "][" + this.getClusterName() + "]" + (Serializable)(cacheValue == null ? "" : cacheValue));
            }
            retVal.put(key, cacheValue);
        }
        return retVal;
    }

    public boolean deleteValues() {
        if (this.getCache() == null) {
            LOG.info("DELETE Cache=NULL[" + this.getClusterName() + "]");
            return false;
        }
        this.cache.removeAll();
        return true;
    }

    private Cache<String, Long> getCache() {
        if (this.cache == null) {
            LOG.info("RECREATE Cache=NULL[" + this.getClusterName() + "]");
            this.doInit((CacheEntryListener<String, Long>)this.userCacheEntryAdapter);
        }
        return this.cache;
    }
}

