/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import de.accxia.apps.confluence.ium.analytical.CounterActionEventType;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.AlertType;
import de.accxia.apps.confluence.ium.repository.IUMAlertRepository;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.servlet.filter.HelperTrialProcessing;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMMembershipJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMMembershipJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMMembershipJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private IUMAlertRepository alertRepository;
    private HelperTrialProcessing helperTrialProcessing;
    int syncUsers = 0;

    private IUMMembershipJob() {
    }

    public static IUMMembershipJob getInstance() {
        if (instance == null) {
            instance = new IUMMembershipJob();
        }
        return instance;
    }

    @Override
    public void injectService(HelperTrialProcessing helperTrialProcessing, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        IUMMembershipJob.instance.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
        this.helperTrialProcessing = helperTrialProcessing;
    }

    @Override
    public void injectService(IUMAlertRepository alertRepository) {
        IUMMembershipJob.instance.alertRepository = alertRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (!ConditionEvaluatorIUMImpl.isFreeVersion()) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMMembershipJob not trial at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            return Collections.emptyList();
        }
        List<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob Process #[" + SDF.format(new Date()) + "] ");
        }
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        String queueSize = DAO.getQueueSize();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob check groups ={} <=> {} at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (!StringUtils.isEmpty((CharSequence)targetGroup)) {
            String[] iumGroups = sourceGroups.split(",");
            String[] iumGroupDISs = targetGroup.split(",");
            String[] queueSizes = queueSize.split(",");
            processResultList = this.helperTrialProcessing.adjustStatus4FreeVersion();
            for (ProcessResult processResult : processResultList) {
                if (processResult.getUsers().size() <= 0) continue;
                this.helperTrialProcessing.markMembershipChanges(AlertType.ALERT_JOBS_MEMBERSHIP, (String)((Object)parameters.get("current_user")), iumGroupDISs[0], processResult.getUsers().size(), processResult.getAdjustSeats());
                this.helperService.emitAnalyticaEvent(CounterActionEventType.ANALYTICAL_EVENT_REDUCED_EXCEED, processResult.getUsers().size());
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    private ProcessResult processPair(GroupManager groupManager, UserAccessor userAccessor, String sourceGroup, String targetGroup, int maxUsers) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob process groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroup, targetGroup, SDF.format(new Date())});
        }
        int groupNameCount = this.iumHelperCacheService.countFromCacheUsersForGroupReal(sourceGroup);
        ProcessResult processResult = new ProcessResult("MembershipJob", sourceGroup, targetGroup);
        processResult.setUserRemoved(0L);
        if (groupNameCount > maxUsers) {
            try {
                Group sGroup = groupManager.getGroup(sourceGroup);
                Group tGroup = groupManager.getGroup(sourceGroup);
                List<ConfluenceUser> users = this.helperService.getUsersFromGroup(sGroup);
                int removeCount = groupNameCount - maxUsers;
                for (ConfluenceUser user : users) {
                    try {
                        groupManager.removeMembership(sGroup, (User)user);
                        groupManager.removeMembership(tGroup, (User)user);
                        processResult.getUsers().add(user.getName());
                        --removeCount;
                        processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                    }
                    catch (Exception e) {
                        this.LOG.error("Exception while removing user from group [{}]", (Object)sourceGroup, (Object)e);
                    }
                    if (removeCount != 0) continue;
                    break;
                }
            }
            catch (Exception e) {
                this.LOG.error("Exception while removing user from group [{}]", (Object)sourceGroup, (Object)e);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMMembershipJob removed #" + processResult.getProcess() + " from group " + sourceGroup);
        }
        return processResult;
    }
}

