/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import de.accxia.apps.confluence.ium.analytical.ChartRepository;
import de.accxia.apps.confluence.ium.analytical.CounterActionDTO;
import de.accxia.apps.confluence.ium.analytical.LicenseAnalyticalService;
import de.accxia.apps.confluence.ium.analytical.LicenseTierDTO;
import de.accxia.apps.confluence.ium.analytical.model.AuditRequest;
import de.accxia.apps.confluence.ium.analytical.model.UserPeak;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.util.DateUtil;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/charts")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestChartsData {
    private static final Logger LOG = LoggerFactory.getLogger(RestChartsData.class);
    private final LicenseAnalyticalService licenseAnalyticalService;
    private final ChartRepository chartRepository;

    @Inject
    public RestChartsData(LicenseAnalyticalService licenseAnalyticalService, ChartRepository chartRepository) {
        this.licenseAnalyticalService = licenseAnalyticalService;
        this.chartRepository = chartRepository;
    }

    @GET
    @Path(value="/userpeak")
    public Response userpeak(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<UserPeak> userPeaks = this.chartRepository.userPeaksForInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userPeaks", userPeaks);
        params.put("chartLabel", "User peak and Queue display");
        params.put("userPeakLabel", "User Peak");
        params.put("userBannerLabel", "Queue");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "User peak and Queue display");
        params.put("chartFileNameTitle", "user-peak");
        return Response.ok(params).build();
    }

    @GET
    @Path(value="/licenses")
    public Response licenses(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<LicenseTierDTO> licenseTierList = this.licenseAnalyticalService.getLicenseTierByInterval(startDate, endDate);
        List<UserPeak> userPeaks = this.chartRepository.userPeaksForInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("licenseTiers", licenseTierList);
        params.put("userPeaks", userPeaks);
        params.put("chartLabel", "User and Licenses");
        params.put("iumTotalUsersLabel", "Total Users");
        params.put("confluenceUserTierLabel", "Users with fix license");
        params.put("iumUserTierLabel", "IUM Users");
        params.put("confluenceLicenseTierLabel", "Confluence license tier");
        params.put("iumLicenseTierLabel", "IUM Shared license");
        params.put("userPeakLabel", "User Peak");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "User and Licenses");
        params.put("chartFileNameTitle", "ium-confluence-user-and-licenses");
        return Response.ok(params).build();
    }

    @GET
    @Path(value="/revocation")
    public Response revocation(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<CounterActionDTO> counterActionList = this.licenseAnalyticalService.getCounterActionByInterval(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("counterActions", counterActionList);
        params.put("chartLabel", "IUM License and Revocation");
        params.put("iumLicenseLabel", "Licenses assigned by IUM");
        params.put("totalUsersRemovedLabel", "Total Number of users removed by IUM");
        params.put("logoutUserLabel", "by IUM user logout");
        params.put("licenseRequestLabel", "by another IUM user");
        params.put("autoRemovalUserLabel", "by auto removal");
        params.put("groupRemovalUserLabel", "by group level removal");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "IUM License and Revocation");
        params.put("chartFileNameTitle", "ium-confluence-statistics");
        return Response.ok(params).build();
    }

    @GET
    @Path(value="/userpeak2")
    public Response userpeak2(@Context HttpServletRequest req) {
        String strYear = req.getParameter("year");
        String strMonth = req.getParameter("month");
        int year = ParseUtil.safeParseInt(strYear);
        int month = ParseUtil.safeParseInt(strMonth);
        Date startDate = DateUtil.getFirstDayOfMonth(year, month);
        Date endDate = DateUtil.getLastDayOfMonth(year, month);
        List<UserPeak> userPeaks = this.chartRepository.userPeaksForInterval2(startDate, endDate);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userPeaks", userPeaks);
        params.put("chartLabel", "User peak and Queue display");
        params.put("userPeakLabel", "User Peak");
        params.put("userBannerLabel", "Queue");
        params.put("days", DateUtil.getDaysInMonth(year, month));
        params.put("month", DateUtil.getMonthName(month));
        params.put("chartTitle", "User peak and Queue display");
        params.put("chartFileNameTitle", "user-peak");
        return Response.ok(params).build();
    }

    @POST
    @Path(value="/auditstatus")
    public Response updateAuditStatus(@Context HttpServletRequest req, AuditRequest auditRequest) {
        if (auditRequest != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(auditRequest.toString());
            }
            DAO.updateAuditStatus(auditRequest.isAuditStatus() ? "true" : "false");
        }
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("auditRequest", DAO.getAuditStatus());
        return Response.ok(params).build();
    }

    @POST
    @Path(value="/dropaudit")
    public Response dropAuditData(@Context HttpServletRequest req) {
        boolean retVal = this.chartRepository.truncateTable();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("drop", retVal);
        return Response.ok(params).build();
    }
}

