/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerPullFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerPullFilter.class);
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final AuthenticationService authenticationService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerPullFilter(UserService userService, IUMHelperService helperService, TemplateRenderer renderer, AuthenticationService authenticationService, AuthenticationContext authenticationContext) {
        this.userService = userService;
        this.helperService = helperService;
        this.renderer = renderer;
        this.authenticationService = authenticationService;
        this.authenticationContext = authenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        ApplicationUser loggedInUser = this.authenticationContext.getCurrentUser();
        String thePar = req.getQueryString();
        if (!req.getMethod().equalsIgnoreCase("POST")) {
            chain.doFilter(request, response);
            return;
        }
        if (!"create".equals(thePar)) {
            chain.doFilter(request, response);
            return;
        }
        String theUsers = req.getParameter("reviewers");
        if (theUsers == null || "".equals(theUsers)) {
            chain.doFilter(request, response);
        }
        String[] reviewers = theUsers.split("\\|\\!\\|");
        ApplicationUser reviewerUser = null;
        final ArrayList<String> reEnabledUsers = new ArrayList<String>();
        final ArrayList<CurrentUser> disabledUsers = new ArrayList<CurrentUser>();
        for (String reviewer : reviewers) {
            String currentUser;
            reviewerUser = this.userService.getUserByName(reviewer);
            log.warn("PullFilter" + reviewerUser);
            if (!this.helperService.isUserInGroups(reviewerUser, DAO.getIUMGroupsDisabled())) continue;
            CurrentUser oldest = this.helperService.disableUserFromGroupforPullforUser(reviewerUser, req);
            if (oldest != null && oldest.user != null) {
                log.warn("disabled user " + oldest.user.getName());
                disabledUsers.add(oldest);
            }
            if ((currentUser = this.helperService.addUserToPullGroup(reviewer)) == null) continue;
            reEnabledUsers.add(currentUser);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                for (String reEnabledUser : reEnabledUsers) {
                    IntelligentUserManagerPullFilter.this.helperService.removeUserfromPullGroup(reEnabledUser);
                }
                for (CurrentUser currentUser : disabledUsers) {
                    IntelligentUserManagerPullFilter.this.helperService.enableUserFromGroup(currentUser.user.getName(), req, true);
                }
            }
        };
        Timer timer = new Timer("Timer");
        long delay = 1000L;
        timer.schedule(task, delay);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        resp.setStatus(307);
        resp.setHeader("Location", req.getRequestURI());
        resp.getWriter().write("");
    }
}

