/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.util;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.impl.OldestUser;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IUMHelperServiceImpl
implements IUMHelperService {
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final SecurityService securityService;
    @ComponentImport
    private final UserAdminService userAdminService;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final AuthenticationService authenticationService;
    public static final boolean MOVE_USER = false;
    private static final Logger log = LoggerFactory.getLogger(IUMHelperServiceImpl.class);

    @Inject
    public IUMHelperServiceImpl(UserService userService, UserAdminService userAdminService, UserManager userManager, SecurityService securityService, AuthenticationService authenticationService) {
        this.userService = userService;
        this.userAdminService = userAdminService;
        this.userManager = userManager;
        this.securityService = securityService;
        this.authenticationService = authenticationService;
    }

    @Override
    public boolean isUserInGroups(ApplicationUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        if (currentUser != null) {
            for (String group : groups.split(",")) {
                try {
                    Boolean isInGroup = (Boolean)this.securityService.withPermission(Permission.ADMIN, "Retrieving repository hook").call(() -> this.userService.isUserInGroup(currentUser, group));
                    if (!isInGroup.booleanValue()) continue;
                    return isInGroup;
                }
                catch (Exception e) {
                    log.error("Error Line 85:" + e.getMessage(), (Throwable)e);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public ApplicationUser getUserByName(String user) {
        try {
            return (ApplicationUser)this.securityService.withPermission(Permission.ADMIN, "IUM Auth").call(() -> this.userService.getUserByName(user));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Authentication checkAuthentication(String user, String password) {
        try {
            return (Authentication)this.securityService.withPermission(Permission.ADMIN, "IUM Auth").call(() -> this.authenticationService.authenticate(user, password));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String test() {
        return "Hallo Heiko";
    }

    public static double getNumeric(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
        return d;
    }

    @Override
    public String moveUserFromGroupToGroup(ApplicationUser user, String group, String toGroup, boolean move) {
        if (group.equals(toGroup)) {
            return "";
        }
        try {
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            this.disableUserFromGroup(user, group, toGroup, move, true);
            theLog.append(user.getName() + "=>" + toGroup + "</br>\n");
            return theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (String it : selectedUsersList) {
                ApplicationUser user = this.userService.getUserByName(it);
                if (user == null) continue;
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(user, group, toGroup, move));
            }
            String action = "Copied";
            if (move) {
                action = "Moved";
            }
            return "<b>" + action + " " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String moveAllUsersFromGroupToGroup(String group, String toGroup) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (ApplicationUser applicationUser : this.getUsersFromGroup(group)) {
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(applicationUser, group, toGroup, true));
            }
            return "<b>Moved " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String disabelAllUsersFromTheEnabledGroups(String movegroup) {
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String[] groups = null;
            String[] groupsDisabled = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            StringBuffer theLog = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                if (!group.equals(movegroup)) continue;
                theLog.append(this.moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
            }
            return theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public ApplicationUser disableUserFromGroup(ApplicationUser user, String group, String groupDisabled, boolean move) {
        return this.disableUserFromGroup(user, group, groupDisabled, move, false);
    }

    @Override
    public ApplicationUser disableUserFromGroup(ApplicationUser user, String group, String groupDisabled, boolean move, boolean isWeb) {
        try {
            this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> this.doDisableUserFromGroup(user, group, groupDisabled, move, isWeb));
            return user;
        }
        catch (Exception e) {
            log.error("Error Line 240 " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String addUserToPullGroup(String user) {
        try {
            String res = (String)this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> this.doAddUserToPullGroup(user));
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String doAddUserToPullGroup(String user) {
        HashSet<String> userSet = new HashSet<String>(Arrays.asList(user));
        this.userAdminService.addMembersToGroup("pullgroup", userSet);
        return user;
    }

    @Override
    public String removeUserfromPullGroup(String user) {
        try {
            String res = (String)this.securityService.withPermission(Permission.ADMIN, "Accxia").call(() -> this.doRemoveUserFromPullGroup(user));
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String doRemoveUserFromPullGroup(String user) {
        this.userAdminService.removeUserFromGroup("pullgroup", user);
        return user;
    }

    public ApplicationUser doDisableUserFromGroup(ApplicationUser user, String group, String groupDisabled, boolean move, boolean isWeb) {
        if (this.userService.isUserInGroup(user, group)) {
            HashSet<String> userSet = new HashSet<String>(Arrays.asList(user.getName()));
            try {
                if (isWeb) {
                    this.userAdminService.addMembersToGroup(groupDisabled, userSet);
                }
                if (move) {
                    this.userAdminService.removeUserFromGroup(group, user.getName());
                }
                return user;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
        return this.enableUserFromGroup(userName, request, false);
    }

    @Override
    public CurrentUser enableUserFromGroup(String userName, HttpServletRequest request, boolean ignoreQueue) {
        try {
            ApplicationUser user = this.userService.getUserByName(userName);
            CurrentUser res = (CurrentUser)this.securityService.withPermission(Permission.ADMIN, "Retrieving repository hook").call(() -> this.enableUserFromGroup(user, request, ignoreQueue));
            return res;
        }
        catch (Exception e) {
            log.error("Error in Enabling line 264 " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public CurrentUser enableUserFromGroup(ApplicationUser user, HttpServletRequest request) {
        return this.enableUserFromGroup(user, request, false);
    }

    @Override
    public CurrentUser enableUserFromGroup(ApplicationUser user, HttpServletRequest request, boolean ignoreQueue) {
        try {
            int i;
            String[] queueSizes;
            String groupEnabled = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String queueSizeTxt = DAO.getQueueSize();
            String[] groupsEnabled = groupEnabled != null ? groupEnabled.split(",") : null;
            String[] groupsDisabled = groupDisabled != null ? groupDisabled.split(",") : null;
            String[] stringArray = queueSizes = queueSizeTxt != null ? queueSizeTxt.split(",") : null;
            if (groupsEnabled == null || groupsDisabled == null || queueSizes == null) {
                return new CurrentUser(null, 0);
            }
            CurrentUser currentUser = new CurrentUser(null, 0);
            for (i = 0; i < groupsEnabled.length; ++i) {
                int queueSize;
                currentUser.noOfUsers = queueSize = Integer.parseInt(queueSizes[i]);
                groupEnabled = groupsEnabled[i];
                groupDisabled = groupsDisabled[i];
                if (this.userService.isUserInGroup(user, groupEnabled)) {
                    currentUser = new CurrentUser(user, 0);
                    break;
                }
                if (!this.userService.isUserInGroup(user, groupDisabled)) continue;
                int noOfUsers = this.getUsersFromGroup(groupEnabled).size();
                if (!ignoreQueue && queueSize != 0 && noOfUsers >= queueSize && !this.disableOldestUser(groupEnabled, groupDisabled) || !ignoreQueue && queueSize != 0 && noOfUsers > queueSize) continue;
                this.userAdminService.addMembersToGroup(groupEnabled, new HashSet<String>(Arrays.asList(user.getName())));
                if (log.isDebugEnabled()) {
                    log.debug("Add user {} from group {} to group {} noOfUsers={} queueSize={}", new Object[]{user.getName(), groupsDisabled[i], groupsEnabled[i], noOfUsers, queueSize});
                }
                currentUser = new CurrentUser(user, 0);
            }
            if (currentUser.user != null) {
                for (i = 0; i < groupsEnabled.length; ++i) {
                    if (!this.userService.isUserInGroup(user, groupsDisabled[i]) || this.userService.isUserInGroup(user, groupsEnabled[i])) continue;
                    this.userAdminService.addMembersToGroup(groupsEnabled[i], new HashSet<String>(Arrays.asList(user.getName())));
                }
            }
            return currentUser;
        }
        catch (Exception e) {
            log.error("Error parsing groups " + e.getMessage(), (Throwable)e);
            return new CurrentUser(null, 0);
        }
    }

    @Override
    public CurrentUser disableUserFromGroupforPullforUser(ApplicationUser user, HttpServletRequest request) {
        try {
            OldestUser oldest = null;
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String queueSizeTxt = DAO.getQueueSize();
            String[] queueSizes = null;
            String[] groups = null;
            String[] groupsDisabled = null;
            if (queueSizeTxt != null) {
                queueSizes = queueSizeTxt.split(",");
            }
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                groupDisabled = groupsDisabled[i];
                int queueSize = Integer.parseInt(queueSizes[i]);
                int noOfUsers = this.getUsersFromGroup(group).size();
                if (queueSize > 0 && noOfUsers >= queueSize - 1) {
                    oldest = this.getOldestUser(group);
                    if (oldest == null) continue;
                    this.disableUserFromGroup((ApplicationUser)oldest.user, group, groupDisabled, true);
                    continue;
                }
                return null;
            }
            return new CurrentUser((ApplicationUser)oldest.user, 0);
        }
        catch (Exception e) {
            log.error("Error 2 parsing groups " + e.getMessage(), (Throwable)e);
            return new CurrentUser(null, 0);
        }
    }

    @Override
    public OldestUser getOldestUser(String group) {
        List<DetailedUser> users = this.getUsersFromGroup(group);
        long oldestTS = 4120528639000L;
        DetailedUser oldestUser = null;
        for (DetailedUser user : users) {
            try {
                Date lastDate;
                long lastTS;
                if (this.userManager.isAdmin(user.getName()) || (lastTS = (lastDate = user.getLastAuthenticationTimestamp()) == null ? 0L : lastDate.getTime()) >= oldestTS) continue;
                if (lastTS == 0L) {
                    return new OldestUser(user, 0L);
                }
                oldestTS = lastTS;
                oldestUser = user;
            }
            catch (Exception exception) {}
        }
        return new OldestUser(oldestUser, oldestTS);
    }

    @Override
    public boolean disableOldestUser(String group, String groupDisabled) {
        OldestUser oldestUser = this.getOldestUser(group);
        if (oldestUser != null && oldestUser.user != null) {
            long now = new Timestamp(System.currentTimeMillis()).getTime();
            long diff = now - oldestUser.ts;
            long duration = Long.parseLong(DAO.getDuration()) * 1000L * 60L;
            if (oldestUser.ts == 0L || duration == 0L || diff > duration) {
                this.disableUserFromGroup((ApplicationUser)oldestUser.user, group, groupDisabled, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<DetailedUser> getSortedUserListFromGroup(String group, int max, String filtergroup) {
        ArrayList<DetailedUser> userList = new ArrayList<DetailedUser>();
        try {
            List<DetailedUser> theUsers;
            List<DetailedUser> allUsers = null;
            List<DetailedUser> filterUsers = null;
            int numAll = 0;
            int numFilter = 0;
            String theFilter = null;
            allUsers = this.getUsersFromGroup(group);
            if (allUsers == null) {
                return userList;
            }
            if (filtergroup == null || "".equals(filtergroup)) {
                theUsers = allUsers;
            } else {
                filterUsers = this.getUsersFromGroup(filtergroup);
                numAll = allUsers.size();
                if (filterUsers != null) {
                    numFilter = filterUsers.size();
                }
                if (numFilter == 0 || numAll == 0) {
                    return userList;
                }
                if (numAll > 0 && numFilter > numAll) {
                    theUsers = allUsers;
                    theFilter = filtergroup;
                } else {
                    theUsers = filterUsers;
                    theFilter = group;
                }
                for (DetailedUser theUser : theUsers) {
                    if (this.userService.isUserInGroup((ApplicationUser)theUser, theFilter)) continue;
                    theUsers.remove(theUser);
                }
            }
            Collections.sort(theUsers, new Comparator<DetailedUser>(){

                @Override
                public int compare(DetailedUser o1, DetailedUser o2) {
                    int res = 0;
                    Long t1 = 0L;
                    Long t2 = 0L;
                    if (o1.getLastAuthenticationTimestamp() != null) {
                        t1 = o1.getLastAuthenticationTimestamp().getTime();
                    }
                    if (o2.getLastAuthenticationTimestamp() != null) {
                        t2 = o2.getLastAuthenticationTimestamp().getTime();
                    }
                    res = t1 < t2 ? -1 : (t1 == t2 ? 0 : 1);
                    return res;
                }
            });
            int count = 0;
            if (max == 0) {
                return theUsers;
            }
            for (DetailedUser o : theUsers) {
                if (count < max) {
                    userList.add(o);
                }
                ++count;
            }
            return userList;
        }
        catch (Exception e) {
            return userList;
        }
    }

    @Override
    public String getUserListFromGroup(String group) {
        List<Object> theUsers = new ArrayList();
        StringBuffer results = new StringBuffer();
        try {
            theUsers = this.getUsersFromGroup(group);
            if (theUsers == null) {
                results.append("No Users");
                return results.toString();
            }
            Collections.sort(theUsers, new Comparator<DetailedUser>(){

                @Override
                public int compare(DetailedUser o1, DetailedUser o2) {
                    int res = 0;
                    Long t1 = 0L;
                    Long t2 = 0L;
                    if (o1.getLastAuthenticationTimestamp() != null) {
                        t1 = o1.getLastAuthenticationTimestamp().getTime();
                    }
                    if (o2.getLastAuthenticationTimestamp() != null) {
                        t2 = o2.getLastAuthenticationTimestamp().getTime();
                    }
                    res = t1 < t2 ? -1 : (t1 == t2 ? 0 : 1);
                    return res;
                }
            });
            results.append("Users:\n");
            for (DetailedUser detailedUser : theUsers) {
                results.append(detailedUser.getName() + ":" + detailedUser.getLastAuthenticationTimestamp() + "\n");
            }
            return results.toString();
        }
        catch (Exception e) {
            return "Error";
        }
    }

    @Override
    public void moveUserToDisabled(ApplicationUser user) {
        String group = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String[] groups = null;
        String[] groupsDisabled = null;
        if (group != null) {
            groups = group.split(",");
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        for (int i = 0; i < groups.length; ++i) {
            String theGroup = "Error";
            if (!this.userService.isUserInGroup(user.getName(), groups[i])) continue;
            try {
                theGroup = groups[i];
                String thetoGroup = groupsDisabled[i];
                if (theGroup == null || thetoGroup == null) continue;
                this.disableUserFromGroup(user, theGroup, thetoGroup, true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private List<DetailedUser> getUsersFromGroup(String group) {
        Page users;
        ArrayList<DetailedUser> res = new ArrayList<DetailedUser>();
        PageRequestImpl pagerq = new PageRequestImpl(0, 200);
        do {
            users = (Page)this.securityService.withPermission(Permission.ADMIN, "Retrieving repository hook").call(() -> this.userAdminService.findUsersWithGroup(group, "", (PageRequest)new PageRequestImpl(0, 1000)));
            Iterator iterator = users.getValues().iterator();
            while (iterator.hasNext()) {
                res.add((DetailedUser)iterator.next());
            }
        } while ((pagerq = users.getNextPageRequest()) != null);
        return res;
    }
}

