/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.saml.SAMLHelper;
import de.accxia.apps.bitbucket.ium.servlet.filter.AccxiaResponseWrapper;
import de.accxia.apps.bitbucket.ium.servlet.filter.IntelligentUserManagerServletFilter;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerSAMLFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerServletFilter.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final UserService userService;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerSAMLFilter(UserManager userManager, UserService userService, IUMHelperService helperService, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.userService = userService;
        this.helperService = helperService;
        this.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isSamlAzure;
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        boolean isSamlIdp = !"".equals(DAO.getSamlIdp());
        boolean bl = isSamlAzure = DAO.getSamlAzure() != null;
        if (!isSamlIdp && !isSamlAzure) {
            chain.doFilter(request, response);
            return;
        }
        String samlParameter = request.getParameter("SAMLResponse");
        if (samlParameter == null || "".equals(samlParameter)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String user = isSamlIdp ? SAMLHelper.getSAMLUserFromSAMLResponse(samlParameter) : SAMLHelper.getSAMLUserFromSAMLAzureResponse(samlParameter);
        if (user == null) {
            chain.doFilter(request, response);
            return;
        }
        ApplicationUser bitbucketUser = this.userService.getUserByName(user);
        if (this.helperService.isUserInGroups(bitbucketUser, DAO.getIUMGroups())) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.helperService.isUserInGroups(bitbucketUser, DAO.getIUMGroupsDisabled())) {
            chain.doFilter(request, response);
            return;
        }
        if (isSamlIdp) {
            if (bitbucketUser == null) {
                AccxiaResponseWrapper myWrapper = new AccxiaResponseWrapper(httpResponse);
                request.getRequestDispatcher("/plugins/servlet/samlconsumer").include(request, (ServletResponse)myWrapper);
                bitbucketUser = this.userService.getUserByName(user);
                this.helperService.moveUserToDisabled(bitbucketUser);
                httpResponse.setStatus(307);
                httpResponse.setHeader("Location", DAO.getSamlIdp());
                httpResponse.getWriter().write("");
                return;
            }
            CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
            if (currentUser != null) {
                ApplicationUser theUser = currentUser.user;
                if (theUser != null) {
                    httpResponse.setStatus(307);
                    httpResponse.setHeader("Location", DAO.getSamlIdp());
                    httpResponse.getWriter().write("");
                    return;
                }
                this.renderQueueVM(currentUser.noOfUsers, httpRequest, httpResponse);
                return;
            }
        } else if (isSamlAzure) {
            CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
            if (currentUser != null) {
                this.renderRedirectVM(httpRequest, httpResponse);
                return;
            }
            this.renderQueueVM(currentUser.noOfUsers, httpRequest, httpResponse);
            return;
        }
        chain.doFilter(request, response);
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderRedirectVM(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, Object> context = new HashMap<String, Object>();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            context.put(paramName, request.getParameter(paramName));
        }
        context.put("parameters", request.getParameterMap());
        context.put("redirUrl", "/plugins/servlet/samlconsumer");
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/redirect_IUM.vm", context, (Writer)response.getWriter());
    }
}

