/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet;

import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public final class TestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String IUMGroup = null;
    private String IUMGroupDIS = null;
    private String duration = null;
    private String queueSize = null;
    private String sideLicense = null;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    private final IUMHelperService helperService;

    @Inject
    public TestServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserService userService, WebSudoManager webSudoManager, IUMHelperService helperService) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer);
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider);
        this.userService = userService;
        this.webSudoManager = webSudoManager;
        this.helperService = helperService;
    }

    public String renderTS(Timestamp ts) {
        if (ts == null) {
            return "unknown";
        }
        return new Date(ts.getTime()).toLocalDate().toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            UserProfile user = this.userManager.getRemoteUser(req);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            String testUsers = this.helperService.getUserListFromGroup("stash-users");
            res.setHeader("Content-Type", "text/plain");
            res.getWriter().write(testUsers);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(req, res);
        }
    }
}

