/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.rest.RestRoute;
import de.accxia.apps.bitbucket.ium.side.LicenseData;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class AdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AdminServlet.class);
    private String IUMGroup = null;
    private String IUMGroupDIS = null;
    private String duration = null;
    private String queueSize = null;
    private String sideLicense = null;
    private static String samlIdp = null;
    private static String samlMapping = null;
    private String samlAzure = null;
    private String urlRest = null;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final I18nService i18nService;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    private final IUMHelperService helperService;

    @Inject
    public AdminServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserService userService, I18nService i18nService, WebSudoManager webSudoManager, IUMHelperService helperService) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer);
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider);
        this.userService = userService;
        this.i18nService = i18nService;
        this.webSudoManager = webSudoManager;
        this.helperService = helperService;
    }

    public String renderTS(Timestamp ts) {
        if (ts == null) {
            return "unknown";
        }
        return new Date(ts.getTime()).toLocalDate().toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String action = req.getParameter("action");
        try {
            boolean showSideLicense;
            this.webSudoManager.willExecuteWebSudoRequest(req);
            UserProfile user = this.userManager.getRemoteUser(req);
            if (user == null || !this.userManager.isAdmin(user.getUserKey())) {
                throw new WebSudoSessionException();
            }
            boolean bl = showSideLicense = req.getParameter("sl") != null;
            if (showSideLicense) {
                this.renderSideLicenseVM(res);
            } else {
                boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(res, showSideLicense);
                    return;
                }
                if ("saml".equals(action)) {
                    this.renderSamlVM(res, "");
                    return;
                }
                if ("rest".equals(action)) {
                    this.renderRestVM(res, null);
                    return;
                }
                this.renderAdminVM(res, "");
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(req, res);
        }
    }

    public String getSideLicense() {
        if (this.sideLicense == null || this.sideLicense.isEmpty()) {
            this.sideLicense = DAO.getSideLicense();
        }
        return this.sideLicense;
    }

    public void setSideLicense(String sideLicense) {
        this.sideLicense = sideLicense;
    }

    public void deleteSideLicense() {
        this.sideLicense = "";
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block18: {
            String action = request.getParameter("action");
            try {
                boolean showSideLicense;
                this.webSudoManager.willExecuteWebSudoRequest(request);
                UserProfile theUser = this.userManager.getRemoteUser(request);
                if (theUser == null || !this.userManager.isAdmin(theUser.getUserKey())) {
                    throw new WebSudoSessionException();
                }
                boolean bl = showSideLicense = request.getParameter("sl") != null;
                if (showSideLicense) {
                    String sideLicense = request.getParameter("sideLicense");
                    if (sideLicense == null || "".equals(sideLicense)) {
                        this.deleteSideLicense();
                        ConditionEvaluatorIUMImpl.deleteSideLicense();
                    }
                    DAO.updateSideLicense(sideLicense);
                    this.setSideLicense(sideLicense);
                    ConditionEvaluatorIUMImpl.setSideLicense();
                    this.renderSideLicenseVM(response);
                    break block18;
                }
                boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                if ("saml".equals(action)) {
                    String samlIdp = "";
                    if (request.getParameter("samlIdp") != null) {
                        samlIdp = request.getParameter("samlIdp");
                    }
                    DAO.updateSamlIdp(samlIdp);
                    AdminServlet.samlIdp = samlIdp;
                    String samlMapping = "saml2:nameId";
                    if (request.getParameter("samlMapping") != null) {
                        samlMapping = request.getParameter("samlMapping");
                    }
                    DAO.updateSamlMapping(samlMapping);
                    AdminServlet.samlMapping = samlMapping;
                    String samlAzureStr = null;
                    if (request.getParameter("samlAzure") != null) {
                        samlAzureStr = request.getParameter("samlAzure");
                    }
                    DAO.updateSamlAzure(samlAzureStr);
                    this.samlAzure = samlAzureStr;
                    this.renderSamlVM(response, "");
                    return;
                }
                if ("remove".equals(action)) {
                    String res = this.helperService.disabelAllUsersFromTheEnabledGroups(request.getParameter("groupName"));
                    this.renderAdminVM(response, res);
                    return;
                }
                if ("rest".equals(action)) {
                    try {
                        this.urlRest = request.getParameter("urlRest");
                        DAO.updateRestRoute(this.urlRest);
                        RestRoute.getInstance().updateRestRoute(this.urlRest);
                        this.renderRestVM(response, this.i18nService.getMessagePattern("de.accxia.apps.bitbucket.IUM.save.rest"));
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderRestVM(response, e.getMessage());
                    }
                    return;
                }
                String reportGroups = "";
                if (request.getParameterValues("IUMGroup") != null) {
                    reportGroups = String.join((CharSequence)",", request.getParameterValues("IUMGroup"));
                }
                String reportGroupsDIS = "";
                if (request.getParameterValues("IUMGroupDIS") != null) {
                    reportGroupsDIS = String.join((CharSequence)",", request.getParameterValues("IUMGroupDIS"));
                }
                String queueSize = "10";
                if (request.getParameterValues("queueSize") != null) {
                    queueSize = String.join((CharSequence)",", request.getParameterValues("queueSize"));
                }
                String duration = "1";
                if (request.getParameterValues("duration") != null) {
                    duration = String.join((CharSequence)",", request.getParameterValues("duration"));
                }
                this.duration = duration;
                DAO.updateDuration(duration);
                this.IUMGroup = reportGroups;
                DAO.updateIUMGroup(reportGroups);
                this.IUMGroupDIS = reportGroupsDIS;
                DAO.updateIUMGroupDisabled(reportGroupsDIS);
                this.queueSize = queueSize;
                DAO.updateQueueSize(queueSize);
                this.renderAdminVM(response, "");
            }
            catch (WebSudoSessionException wes) {
                this.webSudoManager.enforceWebSudoProtection(request, response);
            }
        }
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("sideLicense", DAO.getSideLicense());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderSamlVM(HttpServletResponse response, String message) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        samlIdp = DAO.getSamlIdp();
        samlMapping = DAO.getSamlMapping();
        this.samlAzure = DAO.getSamlAzure();
        response.setContentType("text/html;charset=utf-8");
        context.put("samlIdp", samlIdp);
        context.put("samlMapping", samlMapping);
        context.put("samlAzure", this.samlAzure);
        this.renderer.render("templates/SAML_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderAdminVM(HttpServletResponse response, String message) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String wvg = DAO.getIUMGroups();
        context.put("IUMGroupArray", wvg.isEmpty() ? "" : wvg.split(","));
        wvg = DAO.getIUMGroupsDisabled();
        context.put("IUMGroupDISArray", wvg.isEmpty() ? "" : wvg.split(","));
        wvg = DAO.getQueueSize();
        context.put("queueSizeArray", wvg.isEmpty() ? "" : wvg.split(","));
        this.duration = DAO.getDuration();
        context.put("duration", this.duration.isEmpty() ? "24" : this.duration);
        context.put("message", message);
        boolean enhanced = false;
        LicenseData theLicense = ConditionEvaluatorIUMImpl.getSideLicense();
        if (theLicense != null) {
            enhanced = theLicense.getAppKey().contains("Enhanced");
        }
        context.put("enhanced", enhanced);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/admin_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        response.setContentType("text/html;charset=utf-8");
        context.put("showSideLicense", showSideLicense);
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderRestVM(HttpServletResponse response, String message) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        this.urlRest = DAO.getRestRoute();
        if (!this.urlRest.isEmpty()) {
            this.urlRest = RestRoute.removeDefaultRoute(this.urlRest);
        }
        context.put("urlRest", this.urlRest.isEmpty() ? "" : this.urlRest);
        context.put("successMessage", message);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/rest_IUM.vm", context, (Writer)response.getWriter());
    }
}

