/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.servlet.filter.AccxiaRequestWrapper;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerPullEditFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerPullEditFilter.class);
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final AuthenticationService authenticationService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerPullEditFilter(UserService userService, IUMHelperService helperService, TemplateRenderer renderer, AuthenticationService authenticationService, AuthenticationContext authenticationContext) {
        this.userService = userService;
        this.helperService = helperService;
        this.renderer = renderer;
        this.authenticationService = authenticationService;
        this.authenticationContext = authenticationContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (!req.getMethod().equalsIgnoreCase("PUT")) {
            chain.doFilter(request, response);
            return;
        }
        if (!req.getRequestURI().contains("/pull-requests")) {
            chain.doFilter(request, response);
            return;
        }
        AccxiaRequestWrapper ourRequest = new AccxiaRequestWrapper(req);
        String jsonPayload = ourRequest.getBody();
        JsonObject jsonObject = new JsonParser().parse(jsonPayload).getAsJsonObject();
        JsonArray theReviewers = jsonObject.getAsJsonArray("reviewers");
        ArrayList<String> reviewers = new ArrayList<String>();
        for (JsonElement reviewer : theReviewers) {
            String singleReviewer = reviewer.getAsJsonObject().get("user").getAsJsonObject().get("name").getAsString();
            reviewers.add(singleReviewer);
        }
        if (reviewers.size() == 0) {
            chain.doFilter((ServletRequest)ourRequest, response);
        }
        ApplicationUser reviewerUser = null;
        ArrayList<String> reEnabledUsers = new ArrayList<String>();
        ArrayList<CurrentUser> disabledUsers = new ArrayList<CurrentUser>();
        for (String reviewer : reviewers) {
            String currentUser;
            reviewerUser = this.userService.getUserByName(reviewer);
            if (!this.helperService.isUserInGroups(reviewerUser, DAO.getIUMGroupsDisabled())) continue;
            CurrentUser oldest = this.helperService.disableUserFromGroupforPullforUser(reviewerUser, req);
            if (oldest != null && oldest.user != null) {
                disabledUsers.add(oldest);
            }
            if ((currentUser = this.helperService.addUserToPullGroup(reviewer)) == null) continue;
            reEnabledUsers.add(currentUser);
        }
        chain.doFilter((ServletRequest)ourRequest, response);
        for (String reEnabledUser : reEnabledUsers) {
            this.helperService.removeUserfromPullGroup(reEnabledUser);
        }
        for (CurrentUser currentUser : disabledUsers) {
            this.helperService.enableUserFromGroup(currentUser.user.getName(), req, true);
        }
    }
}

