/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.listener;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserSessionTracker;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={IUMListener.class})
@Named(value="IUMListener")
public class IUMListener {
    private static final Logger log = LoggerFactory.getLogger(IUMListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final UserService userService;
    private final IUMHelperService helperService;

    @Inject
    public IUMListener(EventPublisher eventPublisher, UserService userService, IUMHelperService helperService) {
        this.eventPublisher = eventPublisher;
        this.userService = userService;
        this.helperService = helperService;
    }

    @EventListener
    public void AccxiaEvent(ApplicationEvent event) {
        String myClass = event.getClass().getName();
        if (ConditionEvaluatorIUMImpl.isLicenseValid() && "com.atlassian.stash.internal.event.LogoutSuccessEvent".equals(myClass)) {
            this.helperService.moveUserToDisabled(event.getUser());
            UserSessionTracker.safeRemove(event.getUser());
        }
    }
}

