/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.impl.CurrentUser;
import de.accxia.apps.bitbucket.ium.rest.RestRoute;
import de.accxia.apps.bitbucket.ium.servlet.filter.IntelligentUserManagerServletFilter;
import de.accxia.apps.bitbucket.ium.servlet.filter.UserSessionTracker;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(IntelligentUserManagerServletFilter.class);
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final AuthenticationService authenticationService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    @ComponentImport
    private final NavBuilder navBuilder;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerCerberosFilter(UserService userService, IUMHelperService helperService, TemplateRenderer renderer, NavBuilder navBuilder, AuthenticationContext authenticationContext, AuthenticationService authenticationService) {
        this.userService = userService;
        this.helperService = helperService;
        this.renderer = renderer;
        this.navBuilder = navBuilder;
        this.authenticationContext = authenticationContext;
        this.authenticationService = authenticationService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RequestURI= " + ((HttpServletRequest)request).getRequestURI());
        }
        if (!this.authenticationContext.isAuthenticated()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("j_atl_security_logout")) {
            UserSessionTracker.safeRemove(httpRequest);
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getContentType() != null && httpRequest.getContentType().contains("application/json") && httpRequest.getRequestURI().contains("/rest/analytics")) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("secure/disable")) {
            String username = request.getParameter("username");
            if (this.helperService.isUserInGroups(this.authenticationContext.getCurrentUser(), DAO.getIUMGroups())) {
                ((HttpServletResponse)response).sendRedirect(httpRequest.getContextPath() + "/");
                return;
            }
            this.renderQueueVM(this.helperService.getQuotaForGroupOfUsername(username), httpRequest, (HttpServletResponse)response);
            return;
        }
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user != null && user.isActive()) {
            CurrentUser currentUser;
            if (!this.helperService.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                chain.doFilter(request, response);
                return;
            }
            if (httpRequest.getRequestURI() != null && (httpRequest.getContentType() != null && !httpRequest.getContentType().contains("application/json") || !httpRequest.getRequestURI().contains("/rest/"))) {
                UserSessionTracker.createOrUpdate(this.authenticationContext.getCurrentUser(), httpRequest);
            }
            if (this.helperService.isUserInGroups(user, DAO.getIUMGroups())) {
                chain.doFilter(request, response);
                return;
            }
            if (this.shouldInterceptRestRequest(httpRequest)) {
                chain.doFilter((ServletRequest)httpRequest, response);
                this.authenticationService.clear();
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("For user[" + user.getName() + "] try to enable route=" + httpRequest.getRequestURI());
            }
            if ((currentUser = this.helperService.enableUserFromGroup(user, httpRequest, false)) != null && currentUser.user != null) {
                httpRequest.getSession().setAttribute("IUMUSER", (Object)user.getName());
                chain.doFilter((ServletRequest)httpRequest, response);
                return;
            }
            if (httpRequest.getContentType() == null || !httpRequest.getContentType().contains("application/json")) {
                this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("redirUrl", "/");
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private boolean shouldInterceptRestRequest(HttpServletRequest request) {
        if (RestRoute.getInstance().isEmpty()) {
            return false;
        }
        String referrer = request.getHeader("referer");
        String path = request.getRequestURI();
        boolean contain = Arrays.stream(RestRoute.getInstance().getAllRestRoutes()).anyMatch(s -> path.indexOf((String)s) != -1);
        return contain;
    }
}

