/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.conditions;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IsUserInGroupsCondition
implements Condition {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGroupsCondition.class);
    @ComponentImport
    private final AuthenticationContext authenticationContext;
    private final IUMHelperService iumHelperService;

    @Inject
    public IsUserInGroupsCondition(IUMHelperService iumHelperService, AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.iumHelperService = iumHelperService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        if (!this.authenticationContext.isAuthenticated()) {
            return false;
        }
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        if (this.iumHelperService.isUserInGroups(currentUser, DAO.getIUMGroupsDisabled())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IsUserInGroupsCondition user " + currentUser.getName() + " is in groups=" + DAO.getIUMGroupsDisabled());
            }
            return true;
        }
        return false;
    }
}

