/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.bitbucket.ium.servlet;

import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import de.accxia.apps.bitbucket.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.bitbucket.ium.config.DAO;
import de.accxia.apps.bitbucket.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class IntelligentUserManagerManagementServlet
extends HttpServlet {
    private static final long serialVersionUID = -5623574103725530973L;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserService userService;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    private final IUMHelperService helperService;
    private String fromgroup = null;
    private String filtergroup = null;
    private String togroup = null;
    private String noof = null;

    @Inject
    public IntelligentUserManagerManagementServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserService userService, WebSudoManager webSudoManager, IUMHelperService helperService) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer);
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider);
        this.userService = userService;
        this.webSudoManager = webSudoManager;
        this.helperService = helperService;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String action = request.getParameter("action");
            if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, false);
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if ("list".equals(action)) {
                UserKey username = this.userManager.getRemoteUserKey(request);
                if (username == null || !this.userManager.isAdmin(username)) {
                    this.redirectToLogin(request, response);
                    return;
                }
                String fromGroup = "";
                if (request.getParameter("fromgroup") != null) {
                    fromGroup = request.getParameter("fromgroup");
                }
                String filterGroup = "";
                if (request.getParameter("filtergroup") != null) {
                    filterGroup = request.getParameter("filtergroup");
                }
                String toGroup = "";
                if (request.getParameter("togroup") != null) {
                    toGroup = request.getParameter("togroup");
                }
                int noof = 10;
                try {
                    if (request.getParameter("noof") != null) {
                        noof = Integer.parseInt(request.getParameter("noof"));
                    }
                }
                catch (Exception e) {
                    noof = 10;
                }
                this.fromgroup = this.setValue("fromgroup", fromGroup);
                this.filtergroup = this.setValue("filtergroup", filterGroup);
                this.togroup = this.setValue("togroup", toGroup);
                this.noof = this.setValue("noof", "" + noof);
                List<DetailedUser> users = this.helperService.getSortedUserListFromGroup(this.fromgroup, noof, this.filtergroup);
                map.put("fromgroup", fromGroup);
                map.put("togroup", toGroup);
                map.put("filtergroup", filterGroup);
                map.put("noof", noof);
                map.put("users", users);
                this.renderUserVM(response, map);
                return;
            }
            if ("move".equals(action) || "copy".equals(action)) {
                String[] selectedUsers = null;
                String fromGroup = "";
                if (request.getParameter("fromgroup") != null) {
                    fromGroup = request.getParameter("fromgroup");
                }
                String toGroup = "";
                if (request.getParameter("togroup") != null) {
                    toGroup = request.getParameter("togroup");
                }
                this.fromgroup = this.setValue("fromgroup", fromGroup);
                this.togroup = this.setValue("togroup", toGroup);
                String res = "";
                if (request.getParameter("selUser") != null) {
                    selectedUsers = request.getParameterValues("selUser");
                    res = this.helperService.moveUsersInListFromGroupToGroup(selectedUsers, fromGroup, toGroup, "move".equals(action));
                }
                map.put("fromgroup", fromGroup);
                map.put("togroup", this.getValue("togroup", toGroup));
                map.put("noof", this.getValue("noof", this.noof));
                map.put("message", res);
                this.renderUserVM(response, map);
                return;
            }
            this.renderUserVM(response, map);
        }
        catch (WebSudoSessionException wes) {
            response.sendError(403);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            this.webSudoManager.willExecuteWebSudoRequest(request);
            boolean bl = showSideLicense = request.getParameter("sl") != null;
            if (showSideLicense) {
                this.renderSideLicenseVM(response);
            } else {
                boolean bl2 = showSideLicense = !"".equals(DAO.getSideLicense());
                if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                    this.renderLicenseErrorVM(response, showSideLicense);
                    return;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fromgroup", this.getValue("fromgroup", this.fromgroup));
                map.put("togroup", this.getValue("togroup", this.togroup));
                map.put("filtergroup", this.getValue("filtergroup", this.filtergroup));
                map.put("noof", this.getValue("noof", this.noof));
                this.renderUserVM(response, map);
            }
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        response.setContentType("text/html;charset=utf-8");
        context.put("showSideLicense", showSideLicense);
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderUserVM(HttpServletResponse response, Map<String, Object> context) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/user_IUM.vm", context, (Writer)response.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void renderSideLicenseVM(HttpServletResponse response) throws IOException {
        HashMap context = new HashMap();
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    public String getValue(String key, String currentVal) {
        return currentVal == null ? DAO.getValueByKey(key) : currentVal;
    }

    public String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private boolean isEmpty(String contextPath) {
        return contextPath == null || contextPath.isEmpty();
    }
}

